/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.UUID;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;

public class FlagDef_NotifyEnter
extends PlayerMovementFlagDefinition {
    public FlagDef_NotifyEnter(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claimTo) {
        if (lastLocation == null) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(to, player);
        if (flag == null) {
            return;
        }
        Flag flagTo = this.plugin.getFlagManager().getFlag(claimTo, (FlagDefinition)this);
        Flag flagFromExit = this.plugin.getFlagManager().getFlag(claimFrom, this.plugin.getFlagManager().getFlagDefinitionByName("NotifyExit"));
        if (claimFrom != null && claimTo != null) {
            if (!(claimTo.parent != claimFrom || flagTo != null && flagTo.getSet())) {
                return;
            }
            if (!(claimFrom.parent != claimTo || flagFromExit != null && flagFromExit.getSet())) {
                return;
            }
        }
        if (claimTo == null) {
            return;
        }
        Player owner = Bukkit.getPlayer((UUID)claimTo.getOwnerID());
        if (owner == null) {
            return;
        }
        if (owner.getName().equals(player.getName())) {
            return;
        }
        if (!owner.canSee(player)) {
            return;
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        String param = flag.parameters;
        if (param == null || param.isEmpty()) {
            param = "claim " + claimTo.getID();
        }
        Util.sendClaimMessage((CommandSender)owner, TextMode.Info, Messages.NotifyEnter, player.getName(), param);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        Flag flag = this.getFlagInstanceAtLocation(player.getLocation(), player);
        if (flag == null) {
            return;
        }
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, null);
        if (claim == null) {
            return;
        }
        Player owner = Bukkit.getPlayer((UUID)claim.getOwnerID());
        if (owner == null) {
            return;
        }
        if (owner.getName().equals(player.getName())) {
            return;
        }
        String param = flag.parameters;
        if (param == null || param.isEmpty()) {
            param = "claim " + claim.getID();
        }
        Util.sendClaimMessage((CommandSender)owner, TextMode.Info, Messages.NotifyEnter, player.getName(), param);
    }

    @Override
    public String getName() {
        return "NotifyEnter";
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnableNotifyEnter, parameters);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisableNotifyEnter, new String[0]);
    }
}

