/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.ItemStack;

public class FlagDef_NoVehicle
extends PlayerMovementFlagDefinition {
    public FlagDef_NoVehicle(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public boolean allowMovement(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claimTo) {
        if (player.getVehicle() == null) {
            return true;
        }
        Flag flag = this.getFlagInstanceAtLocation(to, player);
        if (flag == null) {
            return true;
        }
        if (Util.shouldBypass(player, claimTo, flag)) {
            return true;
        }
        Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NoVehicleAllowed, new String[0]);
        return false;
    }

    @EventHandler
    private void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        List passengers = vehicle.getPassengers();
        if (passengers.size() == 0) {
            return;
        }
        Entity passenger = (Entity)passengers.get(0);
        if (!(passenger instanceof Player)) {
            return;
        }
        Player player = (Player)passenger;
        this.handleVehicleMovement(player, vehicle, event.getFrom(), event.getTo(), false);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        Entity entity = player.getVehicle();
        if (!(entity instanceof Vehicle)) {
            return;
        }
        this.handleVehicleMovement(player, (Vehicle)entity, event.getFrom(), event.getTo(), true);
    }

    private void handleVehicleMovement(Player player, Vehicle vehicle, Location locFrom, Location locTo, boolean isTeleportEvent) {
        Flag flag = this.getFlagInstanceAtLocation(locTo, player);
        if (flag != null) {
            Claim claim = GriefPrevention.instance.dataStore.getClaimAt(locTo, false, null);
            if (Util.shouldBypass(player, claim, flag)) {
                return;
            }
            if (isTeleportEvent) {
                player.leaveVehicle();
                Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NoVehicleAllowed, new String[0]);
                return;
            }
            vehicle.eject();
            ItemStack itemStack = Util.getItemFromVehicle(vehicle);
            if (itemStack != null && vehicle.isValid()) {
                vehicle.getWorld().dropItem(locFrom, itemStack);
                vehicle.remove();
            }
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NoVehicleAllowed, new String[0]);
        }
    }

    @EventHandler
    private void onMount(VehicleEnterEvent event) {
        Entity entity = event.getEntered();
        Vehicle vehicle = event.getVehicle();
        if (entity instanceof Player && (vehicle instanceof Boat || vehicle instanceof Minecart)) {
            Claim claim;
            Player player = (Player)entity;
            Flag flag = this.getFlagInstanceAtLocation(vehicle.getLocation(), player);
            if (flag != null && !Util.shouldBypass(player, claim = GriefPrevention.instance.dataStore.getClaimAt(vehicle.getLocation(), false, null), flag)) {
                event.setCancelled(true);
                Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NoEnterVehicle, new String[0]);
            }
        }
    }

    @EventHandler
    private void onCollision(VehicleEntityCollisionEvent event) {
        Entity entity;
        Vehicle vehicle = event.getVehicle();
        Flag flag = this.getFlagInstanceAtLocation(vehicle.getLocation(), null);
        if (flag != null && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            Claim claim = GriefPrevention.instance.dataStore.getClaimAt(vehicle.getLocation(), false, null);
            if (Util.shouldBypass(player, claim, flag)) {
                return;
            }
            event.setCollisionCancelled(true);
            event.setCancelled(true);
        }
    }

    @Override
    public String getName() {
        return "NoVehicle";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnabledNoVehicle, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisabledNoVehicle, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Collections.singletonList(FlagDefinition.FlagType.CLAIM);
    }
}

