/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Arrays;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.WorldSettings;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class FlagDef_NoMobSpawns
extends FlagDefinition {
    public FlagDef_NoMobSpawns(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        EntityType type = event.getEntityType();
        if (type == EntityType.PLAYER || type == EntityType.ARMOR_STAND) {
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        WorldSettings settings = this.settingsManager.get(event.getEntity().getWorld());
        if (settings.noMonsterSpawnIgnoreSpawners && (reason == CreatureSpawnEvent.SpawnReason.SPAWNER || reason == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG)) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(event.getLocation(), null);
        if (flag == null) {
            return;
        }
        event.setCancelled(true);
    }

    @Override
    public String getName() {
        return "NoMobSpawns";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.DisableMobSpawns, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.EnableMobSpawns, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Arrays.asList(FlagDefinition.FlagType.WORLD, FlagDefinition.FlagType.CLAIM, FlagDefinition.FlagType.SERVER);
    }
}

