/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Arrays;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockFromToEvent;

public class FlagDef_NoFluidFlow
extends FlagDefinition {
    private Location previousLocation = null;
    private boolean previousWasCancelled = false;

    public FlagDef_NoFluidFlow(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Location location = event.getBlock().getLocation();
        if (this.previousLocation != null && location.equals((Object)this.previousLocation)) {
            if (!this.previousWasCancelled) {
                return;
            }
            event.setCancelled(true);
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(location, null);
        boolean cancel = flag != null;
        this.previousLocation = location;
        this.previousWasCancelled = cancel;
        if (cancel) {
            event.setCancelled(true);
        }
    }

    @Override
    public String getName() {
        return "NoFluidFlow";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnableNoFluidFlow, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisableNoFluidFlow, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Arrays.asList(FlagDefinition.FlagType.CLAIM, FlagDefinition.FlagType.WORLD, FlagDefinition.FlagType.SERVER);
    }
}

