/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Arrays;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.flags.TimedPlayerFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;

public class FlagDef_NoFlight
extends TimedPlayerFlagDefinition {
    public FlagDef_NoFlight(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public long getPlayerCheckFrequency_Ticks() {
        return 30L;
    }

    @Override
    public void processPlayer(Player player) {
        if (!player.isFlying()) {
            return;
        }
        this.handleFlyAttempt(player);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        event.setCancelled(this.handleFlyAttempt(event.getPlayer()));
    }

    @EventHandler
    public void onFlyCommand(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        String[] args = event.getMessage().split(" ");
        if (args.length == 1 && args[0].contains("fly")) {
            event.setCancelled(this.handleFlyAttempt(event.getPlayer()));
        }
    }

    private boolean handleFlyAttempt(Player player) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        Flag flag = this.getFlagInstanceAtLocation(player.getLocation(), player);
        if (flag == null) {
            return false;
        }
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, null);
        if (Util.shouldBypass(player, claim, flag)) {
            return false;
        }
        Flag ownerFly = GPFlags.getInstance().getFlagManager().getFlagDefinitionByName("OwnerFly").getFlagInstanceAtLocation(player.getLocation(), player);
        Flag ownerMember = GPFlags.getInstance().getFlagManager().getFlagDefinitionByName("OwnerMemberFly").getFlagInstanceAtLocation(player.getLocation(), player);
        if (ownerFly != null && claim.ownerID.equals(player.getUniqueId())) {
            return false;
        }
        if (ownerMember != null) {
            return false;
        }
        Util.sendClaimMessage((CommandSender)player, TextMode.Err, Messages.CantFlyHere, new String[0]);
        player.setFlying(false);
        this.teleportToFloor(player);
        return true;
    }

    private void teleportToFloor(Player player) {
        Location floor = player.getLocation();
        while (floor.getY() > 2.0 && !floor.getBlock().getType().isSolid() && floor.getBlock().getType() != Material.WATER) {
            floor = floor.subtract(0.0, 0.4, 0.0);
        }
        player.setFallDistance(0.0f);
        player.teleport(floor.add(0.0, 0.5, 0.0));
    }

    @Override
    public String getName() {
        return "NoFlight";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnableNoFlight, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisableNoFlight, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Arrays.asList(FlagDefinition.FlagType.CLAIM, FlagDefinition.FlagType.WORLD, FlagDefinition.FlagType.SERVER);
    }
}

