/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Arrays;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerTeleportEvent;

public class FlagDef_NetherPortalPlayerCommand
extends FlagDefinition {
    public FlagDef_NetherPortalPlayerCommand(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        PlayerTeleportEvent.TeleportCause cause = event.getCause();
        if (cause != PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            return;
        }
        Player player = event.getPlayer();
        Flag flag = this.getFlagInstanceAtLocation(event.getFrom(), player);
        if (flag == null) {
            return;
        }
        event.setCancelled(true);
        player.performCommand(flag.parameters);
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        if (parameters.isEmpty()) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.CommandRequired, new String[0]));
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public String getName() {
        return "NetherPortalPlayerCommand";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnableNetherPortalPlayerCommand, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisableNetherPortalPlayerCommand, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Arrays.asList(FlagDefinition.FlagType.CLAIM, FlagDefinition.FlagType.WORLD);
    }
}

