/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlagDef_ExitMessage
extends PlayerMovementFlagDefinition {
    private final String prefix;

    public FlagDef_ExitMessage(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
        this.prefix = plugin.getFlagsDataStore().getMessage(Messages.EnterExitPrefix, new String[0]);
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claimTo) {
        if (lastLocation == null) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(lastLocation, player);
        if (flag == null) {
            return;
        }
        Flag flagFrom = this.plugin.getFlagManager().getFlag(claimFrom, (FlagDefinition)this);
        Flag flagToEnter = this.plugin.getFlagManager().getFlag(claimTo, this.plugin.getFlagManager().getFlagDefinitionByName("EnterMessage"));
        if (claimFrom != null && claimTo != null) {
            if (!(claimFrom.parent != claimTo || flagFrom != null && flagFrom.getSet())) {
                return;
            }
            if (!(claimTo.parent != claimFrom || flagToEnter != null && flagToEnter.getSet())) {
                return;
            }
        }
        String message = flag.parameters;
        if (claimFrom != null) {
            message = message.replace("%owner%", claimFrom.getOwnerName()).replace("%name%", player.getName());
        }
        Util.sendClaimMessage((CommandSender)player, TextMode.Info, this.prefix + message);
    }

    @Override
    public String getName() {
        return "ExitMessage";
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        if (parameters.isEmpty()) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.MessageRequired, new String[0]));
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.AddedExitMessage, parameters);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.RemovedExitMessage, new String[0]);
    }
}

