/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;

public class FlagDef_EnterMessage
extends PlayerMovementFlagDefinition {
    private final String prefix;

    public FlagDef_EnterMessage(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
        this.prefix = plugin.getFlagsDataStore().getMessage(Messages.EnterExitPrefix, new String[0]);
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claimTo) {
        if (lastLocation == null) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(to, player);
        if (flag == null) {
            return;
        }
        Flag flagTo = this.plugin.getFlagManager().getFlag(claimTo, (FlagDefinition)this);
        Flag flagFromExit = this.plugin.getFlagManager().getFlag(claimFrom, this.plugin.getFlagManager().getFlagDefinitionByName("ExitMessage"));
        if (claimFrom != null && claimTo != null) {
            if (!(claimTo.parent != claimFrom || flagTo != null && flagTo.getSet())) {
                return;
            }
            if (!(claimFrom.parent != claimTo || flagFromExit != null && flagFromExit.getSet())) {
                return;
            }
        }
        String message = flag.parameters;
        if (claimTo != null) {
            message = message.replace("%owner%", claimTo.getOwnerName()).replace("%name%", player.getName());
        }
        Util.sendClaimMessage((CommandSender)player, TextMode.Info, this.prefix + message);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        Flag flag = this.getFlagInstanceAtLocation(player.getLocation(), player);
        if (flag == null) {
            return;
        }
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, null);
        String message = flag.parameters;
        message = message.replace("%owner%", claim.getOwnerName()).replace("%name%", player.getName());
        Util.sendClaimMessage((CommandSender)player, TextMode.Info, this.prefix + message);
    }

    @Override
    public String getName() {
        return "EnterMessage";
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        if (parameters.isEmpty()) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.MessageRequired, new String[0]));
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.AddedEnterMessage, parameters);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.RemovedEnterMessage, new String[0]);
    }
}

