/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.events.ClaimDeletedEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FlagDef_ChangeBiome
extends FlagDefinition {
    public FlagDef_ChangeBiome(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    private int changeBiome(Location greater, Location lesser, final Biome biome) {
        int lX = (int)lesser.getX();
        final int lZ = (int)lesser.getZ();
        int gX = (int)greater.getX();
        final int gZ = (int)greater.getZ();
        final World world = lesser.getWorld();
        assert (world != null);
        int i = 0;
        int x = lX;
        while (x < gX) {
            final int finalX = x++;
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    for (int z = lZ; z < gZ; ++z) {
                        Location loadLoc = new Location(world, (double)finalX, 100.0, (double)z);
                        Chunk loadChunk = loadLoc.getChunk();
                        if (!loadChunk.isLoaded()) {
                            loadChunk.load();
                        }
                        for (int y = 0; y <= 255; ++y) {
                            world.setBiome(finalX, y, z, biome);
                        }
                    }
                }
            };
            runnable.runTaskLater((Plugin)GPFlags.getInstance(), (long)i++);
        }
        return i;
    }

    private void changeBiome(final Claim claim, Biome biome) {
        Location greater = claim.getGreaterBoundaryCorner();
        Location lesser = claim.getLesserBoundaryCorner();
        int i = this.changeBiome(greater, lesser, biome);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                FlagDef_ChangeBiome.this.refreshChunks(claim);
            }
        };
        runnable.runTaskLater((Plugin)GPFlags.getInstance(), (long)i);
    }

    private void refreshChunks(Claim claim) {
        Location loc;
        int view = Bukkit.getServer().getViewDistance();
        Player player = Bukkit.getPlayer((String)claim.getOwnerName());
        if (player != null && player.isOnline() && claim.contains(loc = player.getLocation(), true, true)) {
            int X = loc.getChunk().getX();
            int Z = loc.getChunk().getZ();
            for (int x = X - view; x <= X + view; ++x) {
                for (int z = Z - view; z <= Z + view; ++z) {
                    player.getWorld().refreshChunk(x, z);
                }
            }
        }
    }

    public boolean changeBiome(CommandSender sender, Claim claim, String biome) {
        Biome b;
        try {
            b = Biome.valueOf((String)biome);
        }
        catch (Exception e) {
            sender.sendMessage(ChatColor.RED + "Invalid biome");
            return false;
        }
        World world = claim.getLesserBoundaryCorner().getWorld();
        assert (world != null);
        if (!sender.hasPermission("gpflags.flag.changebiome." + biome)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&cYou do not have permissions for the biome &b" + biome + " &c.")));
            return false;
        }
        this.changeBiome(claim, b);
        return true;
    }

    public void resetBiome(Long claimID) {
        this.resetBiome(GriefPrevention.instance.dataStore.getClaim(claimID.longValue()));
    }

    public void resetBiome(Claim claim) {
        Biome biome = claim.getLesserBoundaryCorner().getBlock().getRelative(BlockFace.NORTH, 6).getBiome();
        this.changeBiome(claim, biome);
    }

    @EventHandler
    public void onClaimDelete(ClaimDeletedEvent e) {
        if (e.getClaim().getOwnerName() == null) {
            return;
        }
        Claim claim = e.getClaim();
        if (GPFlags.getInstance().getFlagManager().getFlag(claim, (FlagDefinition)this) == null) {
            return;
        }
        this.resetBiome(claim);
    }

    @Override
    public String getName() {
        return "ChangeBiome";
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        if (parameters.isEmpty()) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.MessageRequired, new String[0]));
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.ChangeBiomeSet, parameters);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.ChangeBiomeUnset, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Collections.singletonList(FlagDefinition.FlagType.CLAIM);
    }
}

