/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;

public class FlagDef_BuyAccessTrust
extends PlayerMovementFlagDefinition {
    public FlagDef_BuyAccessTrust(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public String getName() {
        return "BuyAccessTrust";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnableBuyAccessTrust, parameters);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisableBuyAccessTrust, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Collections.singletonList(FlagDefinition.FlagType.CLAIM);
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        if (parameters.isEmpty()) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.CostRequired, new String[0]));
        }
        try {
            double cost = Double.parseDouble(parameters);
            if (cost < 0.0) {
                return new SetFlagResult(false, new MessageSpecifier(Messages.CostRequired, new String[0]));
            }
        }
        catch (NumberFormatException e) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.CostRequired, new String[0]));
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claimTo) {
        Flag flag = this.getFlagInstanceAtLocation(to, player);
        if (flag == null) {
            return;
        }
        if (claimTo.getPermission(player.getUniqueId().toString()) == ClaimPermission.Access) {
            return;
        }
        if (claimTo.getPermission(player.getUniqueId().toString()) == ClaimPermission.Build) {
            return;
        }
        if (claimTo.getPermission(player.getUniqueId().toString()) == ClaimPermission.Inventory) {
            return;
        }
        if (player.getUniqueId().equals(claimTo.getOwnerID())) {
            return;
        }
        Util.sendMessage((CommandSender)player, TextMode.Info, Messages.AccessTrustPrice, flag.parameters);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        Flag flag = this.getFlagInstanceAtLocation(player.getLocation(), player);
        if (flag == null) {
            return;
        }
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, null);
        if (claim.getPermission(player.getUniqueId().toString()) == ClaimPermission.Access) {
            return;
        }
        if (claim.getPermission(player.getUniqueId().toString()) == ClaimPermission.Build) {
            return;
        }
        if (claim.getPermission(player.getUniqueId().toString()) == ClaimPermission.Inventory) {
            return;
        }
        if (player.getUniqueId().equals(claim.getOwnerID())) {
            return;
        }
        Util.sendMessage((CommandSender)player, TextMode.Info, Messages.AccessTrustPrice, flag.parameters);
    }
}

