/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.WorldSettings;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.EntityEventHandler;
import me.ryanhamshire.GriefPrevention.events.PreventPvPEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class FlagDef_AllowPvP
extends PlayerMovementFlagDefinition {
    private Set<Player> justFiredCrossbow = Collections.newSetFromMap(new WeakHashMap());
    private boolean hasJoined;

    public FlagDef_AllowPvP(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claimTo) {
        if (lastLocation == null) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(to, player);
        WorldSettings settings = this.settingsManager.get(player.getWorld());
        if (flag == null) {
            if (this.getFlagInstanceAtLocation(lastLocation, player) != null) {
                if (!settings.pvpRequiresClaimFlag) {
                    return;
                }
                if (!settings.pvpExitClaimMessageEnabled) {
                    return;
                }
                Util.sendClaimMessage((CommandSender)player, TextMode.Success, settings.pvpExitClaimMessage);
            }
            return;
        }
        if (flag == this.getFlagInstanceAtLocation(lastLocation, player)) {
            return;
        }
        if (this.getFlagInstanceAtLocation(lastLocation, player) != null) {
            return;
        }
        if (!settings.pvpRequiresClaimFlag) {
            return;
        }
        if (!settings.pvpEnterClaimMessageEnabled) {
            return;
        }
        Util.sendClaimMessage((CommandSender)player, TextMode.Warn, settings.pvpEnterClaimMessage);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (this.hasJoined) {
            this.hasJoined = false;
            return;
        }
        this.hasJoined = true;
        Flag flag = this.getFlagInstanceAtLocation(player.getLocation(), null);
        if (flag == null) {
            return;
        }
        WorldSettings settings = this.settingsManager.get(player.getWorld());
        if (!settings.pvpRequiresClaimFlag) {
            return;
        }
        if (!settings.pvpEnterClaimMessageEnabled) {
            return;
        }
        Util.sendClaimMessage((CommandSender)player, TextMode.Warn, settings.pvpEnterClaimMessage);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreventPvP(PreventPvPEvent event) {
        Flag flag = this.getFlagInstanceAtLocation(event.getClaim().getLesserBoundaryCorner(), null);
        if (flag == null) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPotionSplash(PotionSplashEvent event) {
        this.handlePotionEvent((ProjectileHitEvent)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPotionSplash(LingeringPotionSplashEvent event) {
        this.handlePotionEvent((ProjectileHitEvent)event);
    }

    private void handlePotionEvent(ProjectileHitEvent event) {
        Flag flag;
        ThrownPotion potion;
        if (event instanceof PotionSplashEvent) {
            potion = ((PotionSplashEvent)event).getPotion();
        } else if (event instanceof LingeringPotionSplashEvent) {
            potion = ((LingeringPotionSplashEvent)event).getEntity();
        } else {
            return;
        }
        ProjectileSource projectileSource = potion.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player thrower = (Player)projectileSource;
        Collection effects = potion.getEffects();
        boolean hasNegativeEffect = false;
        for (PotionEffect effect : effects) {
            if (EntityEventHandler.positiveEffects.contains(effect.getType())) continue;
            hasNegativeEffect = true;
            break;
        }
        if (!hasNegativeEffect) {
            return;
        }
        WorldSettings settings = this.settingsManager.get(potion.getWorld());
        if (!settings.pvpRequiresClaimFlag) {
            return;
        }
        if (event instanceof PotionSplashEvent) {
            boolean hasProtectableTarget = false;
            for (LivingEntity effected : ((PotionSplashEvent)event).getAffectedEntities()) {
                Tameable pet;
                if (effected instanceof Player && effected != thrower) {
                    hasProtectableTarget = true;
                    break;
                }
                if (!(effected instanceof Tameable) || !(pet = (Tameable)effected).isTamed() || pet.getOwner() == null) continue;
                hasProtectableTarget = true;
                break;
            }
            if (!hasProtectableTarget) {
                return;
            }
        }
        if ((flag = this.getFlagInstanceAtLocation(thrower.getLocation(), thrower)) != null) {
            return;
        }
        event.setCancelled(true);
        Util.sendClaimMessage((CommandSender)thrower, TextMode.Err, settings.pvpDeniedMessage);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityCombustByEntity(EntityCombustByEntityEvent event) {
        EntityDamageByEntityEvent eventWrapper = new EntityDamageByEntityEvent(event.getCombuster(), event.getEntity(), EntityDamageEvent.DamageCause.FIRE_TICK, (double)event.getDuration());
        this.handleEntityDamageEvent(eventWrapper, false);
        event.setCancelled(eventWrapper.isCancelled());
    }

    private void handleEntityDamageEvent(EntityDamageByEntityEvent event, boolean sendErrorMessagesToPlayers) {
        Tameable pet;
        Entity entity;
        if (event.getEntityType() != EntityType.PLAYER && (entity = event.getEntity()) instanceof Tameable && (!(pet = (Tameable)entity).isTamed() || pet.getOwner() == null)) {
            return;
        }
        Entity damager = event.getDamager();
        WorldSettings settings = this.settingsManager.get(damager.getWorld());
        if (!settings.pvpRequiresClaimFlag) {
            return;
        }
        Projectile projectile = null;
        if (damager instanceof Projectile && (projectile = (Projectile)damager).getShooter() instanceof Player) {
            damager = (Player)projectile.getShooter();
        }
        if (damager.getType() != EntityType.PLAYER) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(damager.getLocation(), null);
        Flag flag2 = this.getFlagInstanceAtLocation(event.getEntity().getLocation(), null);
        if (flag != null && flag2 != null) {
            return;
        }
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        event.setCancelled(true);
        if (projectile != null) {
            if (projectile.hasMetadata("item-stack")) {
                MetadataValue meta = (MetadataValue)projectile.getMetadata("item-stack").get(0);
                if (meta != null) {
                    ItemStack item = (ItemStack)meta.value();
                    assert (item != null);
                    if (item.getType() != Material.AIR) {
                        item.setAmount(1);
                        ((Player)damager).getInventory().addItem(new ItemStack[]{item});
                    }
                }
                projectile.removeMetadata("item-stack", (Plugin)GPFlags.getInstance());
            }
            if (!(projectile instanceof Trident)) {
                projectile.remove();
            }
        }
        if (sendErrorMessagesToPlayers && damager instanceof Player) {
            Util.sendClaimMessage((CommandSender)damager, TextMode.Err, settings.pvpDeniedMessage);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        this.handleEntityDamageEvent(event, true);
    }

    @EventHandler
    private void onShootBow(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            ItemStack bow = event.getBow();
            if (bow == null) {
                return;
            }
            ItemMeta meta = bow.getItemMeta();
            if (meta != null && meta.hasEnchant(Enchantment.ARROW_INFINITE)) {
                return;
            }
            if (Util.isRunningMinecraft(1, 14) && bow.getType() == Material.CROSSBOW && bow.getItemMeta() != null) {
                List projs = ((CrossbowMeta)bow.getItemMeta()).getChargedProjectiles();
                ItemStack projectile = (ItemStack)projs.get(0);
                if (projs.size() > 1) {
                    if (this.justFiredCrossbow.contains(player)) {
                        return;
                    }
                    this.justFiredCrossbow.add(player);
                    Bukkit.getScheduler().runTaskLater((Plugin)GPFlags.getInstance(), () -> this.justFiredCrossbow.remove(player), 5L);
                }
                event.getProjectile().setMetadata("item-stack", (MetadataValue)new FixedMetadataValue((Plugin)GPFlags.getInstance(), (Object)projectile.clone()));
                return;
            }
            if (this.isProjectile(player.getInventory().getItemInOffHand())) {
                ItemStack projectile = player.getInventory().getItemInOffHand();
                event.getProjectile().setMetadata("item-stack", (MetadataValue)new FixedMetadataValue((Plugin)GPFlags.getInstance(), (Object)projectile.clone()));
                return;
            }
            for (ItemStack item : player.getInventory()) {
                if (!this.isProjectile(item)) continue;
                event.getProjectile().setMetadata("item-stack", (MetadataValue)new FixedMetadataValue((Plugin)GPFlags.getInstance(), (Object)item.clone()));
                return;
            }
        }
    }

    private boolean isProjectile(ItemStack item) {
        if (item == null) {
            return false;
        }
        switch (item.getType()) {
            case ARROW: 
            case SPECTRAL_ARROW: 
            case TIPPED_ARROW: 
            case FIREWORK_ROCKET: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "AllowPvP";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.AddEnablePvP, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.RemoveEnabledPvP, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Collections.singletonList(FlagDefinition.FlagType.CLAIM);
    }
}

