/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.commands;

import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandUnsetDefaultClaimFlag
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ChatColor color;
        if (!sender.hasPermission("gpflags.command.unsetdefaultclaimflag")) {
            Util.sendMessage(sender, TextMode.Err, Messages.NoCommandPermission, command.toString());
            return true;
        }
        if (args.length < 1) {
            return false;
        }
        Player player = (Player)sender;
        String flagName = args[0];
        GPFlags gpflags = GPFlags.getInstance();
        FlagDefinition def = gpflags.getFlagManager().getFlagDefinitionByName(flagName);
        if (def == null) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Util.getFlagDefsMessage((Permissible)player));
            return true;
        }
        if (!sender.hasPermission("gpflags.flag." + def.getName())) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NoFlagPermission, def.getName());
            return true;
        }
        SetFlagResult result = gpflags.getFlagManager().unSetFlag("-2", def, true);
        ChatColor chatColor = color = result.isSuccess() ? TextMode.Success : TextMode.Err;
        if (result.isSuccess()) {
            Util.sendMessage((CommandSender)player, color, Messages.DefaultFlagUnSet, new String[0]);
            gpflags.getFlagManager().save();
        } else {
            Util.sendMessage((CommandSender)player, color, result.getMessage().getMessageID(), result.getMessage().getMessageParams());
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return Util.flagTab(sender, args[0]);
        }
        return Collections.emptyList();
    }
}

