/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.commands;

import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDef_ChangeBiome;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandUnsetClaimFlag
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        SetFlagResult result;
        if (!sender.hasPermission("gpflags.command.unsetclaimflag")) {
            Util.sendMessage(sender, TextMode.Err, Messages.NoCommandPermission, command.toString());
            return true;
        }
        if (args.length < 1) {
            return false;
        }
        Player player = (Player)sender;
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, playerData.lastClaim);
        if (claim == null) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.StandInAClaim, new String[0]);
            return true;
        }
        Long claimID = claim.getID();
        if (claimID == null || claimID == -1L) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.UpdateGPForSubdivisionFlags, new String[0]);
            return true;
        }
        String flagName = args[0];
        GPFlags plugin = GPFlags.getInstance();
        FlagDefinition def = plugin.getFlagManager().getFlagDefinitionByName(flagName);
        if (def == null) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Util.getFlagDefsMessage((Permissible)player));
            return true;
        }
        if (!sender.hasPermission("gpflags.flag." + def.getName())) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NoFlagPermission, def.getName());
            return true;
        }
        if (!Util.canManageFlags(player, claim)) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NotYourClaim, new String[0]);
            return true;
        }
        if (flagName.equalsIgnoreCase("ChangeBiome")) {
            FlagDef_ChangeBiome flagD = (FlagDef_ChangeBiome)plugin.getFlagManager().getFlagDefinitionByName("changebiome");
            flagD.resetBiome(claim.getID());
        }
        ChatColor color = (result = plugin.getFlagManager().unSetFlag(claimID.toString(), def, true)).isSuccess() ? TextMode.Success : TextMode.Err;
        Util.sendMessage((CommandSender)player, color, result.getMessage().getMessageID(), result.getMessage().getMessageParams());
        if (result.isSuccess()) {
            plugin.getFlagManager().save();
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return Util.flagTab(commandSender, args[0]);
        }
        return Collections.emptyList();
    }
}

