/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandSetWorldFlag
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ChatColor color;
        if (!sender.hasPermission("gpflags.command.setworldflag")) {
            Util.sendMessage(sender, TextMode.Err, Messages.NoCommandPermission, command.toString());
            return true;
        }
        if (args.length < 2) {
            return false;
        }
        World world = Bukkit.getWorld((String)args[0]);
        if (world == null) {
            Util.sendMessage(sender, TextMode.Err, Messages.WorldNotFound, args[0]);
            return true;
        }
        String flagName = args[1];
        GPFlags gpflags = GPFlags.getInstance();
        FlagDefinition def = gpflags.getFlagManager().getFlagDefinitionByName(flagName);
        if (def == null) {
            Util.sendMessage(sender, TextMode.Err, Util.getFlagDefsMessage((Permissible)sender));
            return true;
        }
        if (!sender.hasPermission("gpflags.flag." + def.getName())) {
            Util.sendMessage(sender, TextMode.Err, Messages.NoFlagPermission, def.getName());
            return true;
        }
        if (!def.getFlagType().contains((Object)FlagDefinition.FlagType.WORLD)) {
            Util.sendMessage(sender, TextMode.Err, Messages.NoFlagInWorld, new String[0]);
            return true;
        }
        String[] params = new String[args.length - 2];
        System.arraycopy(args, 2, params, 0, args.length - 2);
        SetFlagResult result = gpflags.getFlagManager().setFlag(world.getName(), def, true, true, params);
        ChatColor chatColor = color = result.isSuccess() ? TextMode.Success : TextMode.Err;
        if (result.isSuccess()) {
            Util.sendMessage(sender, color, Messages.WorldFlagSet, new String[0]);
            gpflags.getFlagManager().save();
        } else {
            Util.sendMessage(sender, color, result.getMessage().getMessageID(), result.getMessage().getMessageParams());
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList worlds = new ArrayList();
            Bukkit.getWorlds().forEach(world -> worlds.add(world.getName()));
            return (List)StringUtil.copyPartialMatches((String)args[0], worlds, new ArrayList());
        }
        if (args.length == 2) {
            return Util.flagTab(commandSender, args[1]);
        }
        if (args.length == 3) {
            return Util.paramTab(commandSender, args);
        }
        return Collections.emptyList();
    }
}

