/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.commands;

import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandSetDefaultClaimFlag
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ChatColor color;
        if (!commandSender.hasPermission("gpflags.command.setdefaultclaimflag")) {
            Util.sendMessage(commandSender, TextMode.Err, Messages.NoCommandPermission, command.toString());
            return true;
        }
        if (args.length < 1) {
            return false;
        }
        String flagName = args[0];
        GPFlags gpFlags = GPFlags.getInstance();
        FlagDefinition def = gpFlags.getFlagManager().getFlagDefinitionByName(flagName);
        if (def == null) {
            Util.sendMessage(commandSender, TextMode.Err, Util.getFlagDefsMessage((Permissible)commandSender));
            return true;
        }
        if (!commandSender.hasPermission("gpflags.flag." + def.getName())) {
            Util.sendMessage(commandSender, TextMode.Err, Messages.NoFlagPermission, def.getName());
            return true;
        }
        if (!def.getFlagType().contains((Object)FlagDefinition.FlagType.CLAIM)) {
            Util.sendMessage(commandSender, TextMode.Err, Messages.NoFlagInClaim, new String[0]);
            return true;
        }
        String[] params = new String[args.length - 1];
        System.arraycopy(args, 1, params, 0, args.length - 1);
        SetFlagResult result = gpFlags.getFlagManager().setFlag("-2", def, true, true, params);
        ChatColor chatColor = color = result.isSuccess() ? TextMode.Success : TextMode.Err;
        if (result.isSuccess()) {
            Util.sendMessage(commandSender, color, Messages.DefaultFlagSet, new String[0]);
            gpFlags.getFlagManager().save();
        } else {
            Util.sendMessage(commandSender, color, result.getMessage().getMessageID(), result.getMessage().getMessageParams());
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return Util.flagTab(commandSender, args[0]);
        }
        if (args.length == 2) {
            return Util.paramTab(commandSender, args);
        }
        return Collections.emptyList();
    }
}

