/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandSetClaimFlag
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Long claimID;
        if (!commandSender.hasPermission("gpflags.command.setclaimflag")) {
            Util.sendMessage(commandSender, TextMode.Err, Messages.NoCommandPermission, command.toString());
            return true;
        }
        if (!(commandSender instanceof Player)) {
            Util.sendMessage(commandSender, TextMode.Warn, Messages.PlayerOnlyCommand, command.toString());
            return true;
        }
        Player player = (Player)commandSender;
        if (args.length < 1) {
            return false;
        }
        String flagName = args[0];
        GPFlags gpflags = GPFlags.getInstance();
        FlagDefinition def = gpflags.getFlagManager().getFlagDefinitionByName(flagName);
        if (def == null) {
            Util.sendMessage((CommandSender)player, TextMode.Warn, Util.getFlagDefsMessage((Permissible)player));
            return true;
        }
        if (!player.hasPermission("gpflags.flag." + def.getName())) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NoFlagPermission, flagName);
            return true;
        }
        if (!def.getFlagType().contains((Object)FlagDefinition.FlagType.CLAIM)) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NoFlagInClaim, new String[0]);
            return true;
        }
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, playerData.lastClaim);
        if (claim == null) {
            Util.sendMessage(commandSender, TextMode.Err, Messages.StandInAClaim, new String[0]);
            return true;
        }
        if (!Util.canManageFlags(player, claim)) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.NotYourClaim, new String[0]);
            return true;
        }
        String[] params = new String[args.length - 1];
        System.arraycopy(args, 1, params, 0, args.length - 1);
        Collection<Flag> flags = gpflags.getFlagManager().getFlags(claim.getID().toString());
        for (Flag flag : flags) {
            if (flagName.equalsIgnoreCase("OwnerFly") && flag.getFlagDefinition().getName().equalsIgnoreCase("OwnerMemberFly")) {
                Util.sendMessage((CommandSender)player, TextMode.Warn, Messages.NoOwnerFlag, new String[0]);
                return true;
            }
            if (!flagName.equalsIgnoreCase("OwnerMemberFly") || !flag.getFlagDefinition().getName().equalsIgnoreCase("OwnerFly")) continue;
            Util.sendMessage((CommandSender)player, TextMode.Warn, Messages.NoOwnerFlag, new String[0]);
            return true;
        }
        if (flagName.equalsIgnoreCase("ChangeBiome")) {
            String biome;
            if (args.length < 2) {
                return false;
            }
            String[] flagD = (String[])gpflags.getFlagManager().getFlagDefinitionByName("changebiome");
            if (!flagD.changeBiome(commandSender, claim, biome = params[0].toUpperCase().replace(" ", "_"))) {
                return true;
            }
        }
        if (flagName.equalsIgnoreCase("NoMobSpawnsType")) {
            if (params.length == 0) {
                return false;
            }
            for (String type : params[0].split(";")) {
                if (player.hasPermission("gpflags.flag.nomobspawnstype." + type)) continue;
                Util.sendMessage((CommandSender)player, TextMode.Err, Messages.MobTypePerm, type);
                return true;
            }
        }
        if ((claimID = claim.getID()) == null || claimID == -1L) {
            Util.sendMessage((CommandSender)player, TextMode.Err, Messages.UpdateGPForSubdivisionFlags, new String[0]);
            return true;
        }
        SetFlagResult result = gpflags.getFlagManager().setFlag(claimID.toString(), def, true, true, params);
        ChatColor color = result.isSuccess() ? TextMode.Success : TextMode.Err;
        Util.sendMessage((CommandSender)player, color, result.getMessage().getMessageID(), result.getMessage().getMessageParams());
        if (result.isSuccess()) {
            gpflags.getFlagManager().save();
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return Util.flagTab(commandSender, args[0]);
        }
        if (args.length == 2) {
            return Util.paramTab(commandSender, args);
        }
        return Collections.emptyList();
    }
}

