/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.commands;

import java.util.Collection;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.VaultHook;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandBuyBuildTrust
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (!(sender instanceof Player)) {
            Util.sendMessage(sender, TextMode.Err, Messages.PlayerOnlyCommand, command.toString());
            return true;
        }
        Player player = (Player)sender;
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, null);
        if (claim == null) {
            Util.sendMessage(sender, TextMode.Err, Messages.CannotBuyTrustHere, new String[0]);
            return true;
        }
        Collection<Flag> flags = GPFlags.getInstance().getFlagManager().getFlags(claim.getID().toString());
        for (Flag flag : flags) {
            double cost;
            if (!flag.getFlagDefinition().getName().equalsIgnoreCase("BuyBuildTrust")) continue;
            if (claim.getPermission(player.getUniqueId().toString()) == ClaimPermission.Build || player.getUniqueId().equals(claim.getOwnerID())) {
                Util.sendMessage(sender, TextMode.Err, Messages.AlreadyHaveTrust, new String[0]);
                return true;
            }
            if (flag.parameters == null || flag.parameters.isEmpty()) {
                Util.sendMessage(sender, TextMode.Err, Messages.ProblemWithFlagSetup, new String[0]);
                return true;
            }
            try {
                cost = Double.parseDouble(flag.parameters);
            }
            catch (NumberFormatException e) {
                Util.sendMessage(sender, TextMode.Err, Messages.ProblemWithFlagSetup, new String[0]);
                return true;
            }
            if (!VaultHook.takeMoney(player, cost)) {
                Util.sendMessage(sender, TextMode.Err, Messages.NotEnoughMoney, new String[0]);
                return true;
            }
            if (claim.getOwnerID() != null) {
                VaultHook.giveMoney(claim.getOwnerID(), cost);
            }
            claim.setPermission(player.getUniqueId().toString(), ClaimPermission.Build);
            Util.sendMessage(sender, TextMode.Info, Messages.BoughtTrust, flag.parameters);
            return true;
        }
        Util.sendMessage(sender, TextMode.Err, Messages.CannotBuyTrustHere, new String[0]);
        return true;
    }
}

