/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.FlagsDataStore;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.WorldSettings;
import me.ryanhamshire.GPFlags.commands.CommandBuyAccessTrust;
import me.ryanhamshire.GPFlags.commands.CommandBuyBuildTrust;
import me.ryanhamshire.GPFlags.commands.CommandBuyContainerTrust;
import me.ryanhamshire.GPFlags.commands.CommandBuySubclaim;
import me.ryanhamshire.GPFlags.flags.FlagDef_AllowBlockExplosions;
import me.ryanhamshire.GPFlags.flags.FlagDef_AllowPvP;
import me.ryanhamshire.GPFlags.flags.FlagDef_AllowWitherDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_BuyAccessTrust;
import me.ryanhamshire.GPFlags.flags.FlagDef_BuyBuildTrust;
import me.ryanhamshire.GPFlags.flags.FlagDef_BuyContainerTrust;
import me.ryanhamshire.GPFlags.flags.FlagDef_BuySubclaim;
import me.ryanhamshire.GPFlags.flags.FlagDef_ChangeBiome;
import me.ryanhamshire.GPFlags.flags.FlagDef_CommandBlackList;
import me.ryanhamshire.GPFlags.flags.FlagDef_CommandWhiteList;
import me.ryanhamshire.GPFlags.flags.FlagDef_EnterCommand;
import me.ryanhamshire.GPFlags.flags.FlagDef_EnterCommand_Members;
import me.ryanhamshire.GPFlags.flags.FlagDef_EnterCommand_Owner;
import me.ryanhamshire.GPFlags.flags.FlagDef_EnterMessage;
import me.ryanhamshire.GPFlags.flags.FlagDef_EnterPlayerCommand;
import me.ryanhamshire.GPFlags.flags.FlagDef_ExitCommand;
import me.ryanhamshire.GPFlags.flags.FlagDef_ExitCommand_Members;
import me.ryanhamshire.GPFlags.flags.FlagDef_ExitCommand_Owner;
import me.ryanhamshire.GPFlags.flags.FlagDef_ExitMessage;
import me.ryanhamshire.GPFlags.flags.FlagDef_ExitPlayerCommand;
import me.ryanhamshire.GPFlags.flags.FlagDef_HealthRegen;
import me.ryanhamshire.GPFlags.flags.FlagDef_InfiniteArrows;
import me.ryanhamshire.GPFlags.flags.FlagDef_KeepInventory;
import me.ryanhamshire.GPFlags.flags.FlagDef_KeepLevel;
import me.ryanhamshire.GPFlags.flags.FlagDef_KeepLoaded;
import me.ryanhamshire.GPFlags.flags.FlagDef_NetherPortalConsoleCommand;
import me.ryanhamshire.GPFlags.flags.FlagDef_NetherPortalPlayerCommand;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoAnvilDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoBlockForm;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoBlockGravity;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoBlockSpread;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoChorusFruit;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoCombatLoot;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoDripstoneSpread;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoEliteMobSpawns;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoElytra;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoEnderPearl;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoEnter;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoEnterPlayer;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoExpiration;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoExplosionDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoFallDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoFireDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoFireSpread;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoFlight;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoFluidFlow;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoGrowth;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoHunger;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoIceForm;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoItemDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoItemDrop;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoItemPickup;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoLeafDecay;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoLootProtection;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoMcMMODeathPenalty;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoMcMMOSkills;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoMcMMOXP;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoMobDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoMobSpawns;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoMobSpawnsType;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoMonsterSpawns;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoMonsters;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoOpenDoors;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoPetDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoPlayerDamage;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoPlayerDamageByMonster;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoPotionEffects;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoSnowForm;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoStructureGrowth;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoVehicle;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoVineGrowth;
import me.ryanhamshire.GPFlags.flags.FlagDef_NoWeatherChange;
import me.ryanhamshire.GPFlags.flags.FlagDef_NotifyEnter;
import me.ryanhamshire.GPFlags.flags.FlagDef_NotifyExit;
import me.ryanhamshire.GPFlags.flags.FlagDef_OwnerFly;
import me.ryanhamshire.GPFlags.flags.FlagDef_OwnerMemberFly;
import me.ryanhamshire.GPFlags.flags.FlagDef_PlayerGamemode;
import me.ryanhamshire.GPFlags.flags.FlagDef_PlayerTime;
import me.ryanhamshire.GPFlags.flags.FlagDef_PlayerWeather;
import me.ryanhamshire.GPFlags.flags.FlagDef_ProtectNamedMobs;
import me.ryanhamshire.GPFlags.flags.FlagDef_RaidMemberOnly;
import me.ryanhamshire.GPFlags.flags.FlagDef_ReadLecterns;
import me.ryanhamshire.GPFlags.flags.FlagDef_RespawnLocation;
import me.ryanhamshire.GPFlags.flags.FlagDef_SpawnReasonWhitelist;
import me.ryanhamshire.GPFlags.flags.FlagDef_SpleefArena;
import me.ryanhamshire.GPFlags.flags.FlagDef_TrappedDestination;
import me.ryanhamshire.GPFlags.flags.FlagDef_ViewContainers;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;

public class GPFlagsConfig {
    private final GPFlags plugin;
    private final FlagManager flagManager;
    public static boolean LOG_ENTER_EXIT_COMMANDS = true;

    public GPFlagsConfig(GPFlags plugin) {
        this.plugin = plugin;
        this.flagManager = plugin.getFlagManager();
        this.loadConfig();
    }

    public void loadConfig() {
        this.flagManager.clear();
        YamlConfiguration inConfig = YamlConfiguration.loadConfiguration((File)new File(FlagsDataStore.configFilePath));
        YamlConfiguration outConfig = new YamlConfiguration();
        List worlds = this.plugin.getServer().getWorlds();
        ArrayList<String> worldSettingsKeys = new ArrayList<String>();
        for (World world : worlds) {
            worldSettingsKeys.add(world.getName());
        }
        for (String worldName : worldSettingsKeys) {
            WorldSettings settings = this.plugin.getWorldSettingsManager().create(worldName);
            LOG_ENTER_EXIT_COMMANDS = inConfig.getBoolean("Settings.Log Enter/Exit Messages To Console", true);
            outConfig.set("Settings.Log Enter/Exit Messages To Console", (Object)LOG_ENTER_EXIT_COMMANDS);
            settings.worldGamemodeDefault = inConfig.getString("World Flags." + worldName + ".Default Gamemode", "survival");
            String worldGMDefault = settings.worldGamemodeDefault;
            if (!(worldGMDefault.equalsIgnoreCase("survival") || worldGMDefault.equalsIgnoreCase("creative") || worldGMDefault.equalsIgnoreCase("adventure") || worldGMDefault.equalsIgnoreCase("spectator"))) {
                settings.worldGamemodeDefault = "survival";
            }
            outConfig.set("World Flags." + worldName + ".Default Gamemode", (Object)settings.worldGamemodeDefault);
            settings.pvpRequiresClaimFlag = inConfig.getBoolean("World Flags." + worldName + ".PvP Only In PvP-Flagged Claims", false);
            outConfig.set("World Flags." + worldName + ".PvP Only In PvP-Flagged Claims", (Object)settings.pvpRequiresClaimFlag);
            settings.pvpDeniedMessage = inConfig.getString("World Flags." + worldName + ".Message To Send When PvP Is Denied", "Player vs. player combat is restricted to designated areas.");
            outConfig.set("World Flags." + worldName + ".Message To Send When PvP Is Denied", (Object)settings.pvpDeniedMessage);
            settings.pvpEnterClaimMessageEnabled = inConfig.getBoolean("World Flags." + worldName + ".Send Message On Enter PvP Enabled Claim", false);
            outConfig.set("World Flags." + worldName + ".Send Message On Enter PvP Enabled Claim", (Object)settings.pvpEnterClaimMessageEnabled);
            settings.pvpEnterClaimMessage = inConfig.getString("World Flags." + worldName + ".Message", "PvP is enabled in this claim, be careful");
            outConfig.set("World Flags." + worldName + ".Message", (Object)settings.pvpEnterClaimMessage);
            settings.pvpExitClaimMessageEnabled = inConfig.getBoolean("World Flags." + worldName + ".Send Message On Exit PvP Enabled Claim", false);
            outConfig.set("World Flags." + worldName + ".Send Message On Exit PvP Enabled Claim", (Object)settings.pvpExitClaimMessageEnabled);
            settings.pvpExitClaimMessage = inConfig.getString("World Flags." + worldName + ".ExitMessage", "PvP is disabled in this area, you are now safe");
            outConfig.set("World Flags." + worldName + ".ExitMessage", (Object)settings.pvpExitClaimMessage);
            settings.noMonsterSpawnIgnoreSpawners = inConfig.getBoolean("World Flags." + worldName + ".NoMonsterSpawn Flag Ignores Spawners and Eggs", true);
            outConfig.set("World Flags." + worldName + ".NoMonsterSpawn Flag Ignores Spawners and Eggs", (Object)settings.noMonsterSpawnIgnoreSpawners);
            settings.noMobSpawnIgnoreSpawners = inConfig.getBoolean("World Flags." + worldName + ".NoMobSpawn Flag Ignores Spawners and Eggs", true);
            outConfig.set("World Flags." + worldName + ".NoMobSpawn Flag Ignores Spawners and Eggs", (Object)settings.noMobSpawnIgnoreSpawners);
            outConfig.options().header("GriefPrevention Flags\nPlugin Version: " + this.plugin.getDescription().getVersion() + "\nServer Version: " + this.plugin.getServer().getVersion() + "\n\n");
        }
        try {
            outConfig.save(FlagsDataStore.configFilePath);
            Util.log("Finished loading configuration.");
        }
        catch (IOException exception) {
            Util.log("Unable to write to the configuration file at \"" + FlagsDataStore.configFilePath + "\"");
        }
        if (!this.plugin.registeredFlagDefinitions) {
            block26: {
                this.plugin.registeredFlagDefinitions = true;
                this.flagManager.registerFlagDefinition(new FlagDef_NoMonsterSpawns(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoMonsters(this.flagManager, this.plugin));
                FlagDef_AllowPvP allowPvPDef = new FlagDef_AllowPvP(this.flagManager, this.plugin);
                allowPvPDef.firstTimeSetup();
                this.flagManager.registerFlagDefinition(allowPvPDef);
                this.flagManager.registerFlagDefinition(new FlagDef_EnterMessage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ExitMessage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_EnterCommand(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_EnterPlayerCommand(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ExitCommand(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ExitPlayerCommand(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_RespawnLocation(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_KeepInventory(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_InfiniteArrows(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_KeepLevel(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_KeepLoaded(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NetherPortalPlayerCommand(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NetherPortalConsoleCommand(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoCombatLoot(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoMobSpawns(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoPlayerDamage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoPlayerDamageByMonster(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoEnter(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoMobDamage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoFluidFlow(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_HealthRegen(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoHunger(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_CommandWhiteList(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_CommandBlackList(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoStructureGrowth(this.flagManager, this.plugin));
                FlagDef_NoFlight noFlight = new FlagDef_NoFlight(this.flagManager, this.plugin);
                noFlight.firstTimeSetup();
                this.flagManager.registerFlagDefinition(noFlight);
                this.flagManager.registerFlagDefinition(new FlagDef_TrappedDestination(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoLootProtection(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoEnderPearl(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoExpiration(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoLeafDecay(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoPetDamage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoWeatherChange(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoItemPickup(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoChorusFruit(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_SpleefArena(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoItemDrop(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoGrowth(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_OwnerFly(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_OwnerMemberFly(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoEnterPlayer(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_PlayerWeather(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_PlayerTime(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_PlayerGamemode(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoVineGrowth(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoSnowForm(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoIceForm(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoFireSpread(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoFireDamage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoFallDamage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_EnterCommand_Owner(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_EnterCommand_Members(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ExitCommand_Owner(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ExitCommand_Members(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoExplosionDamage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_AllowBlockExplosions(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ProtectNamedMobs(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoBlockGravity(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ChangeBiome(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoOpenDoors(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoVehicle(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoBlockForm(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoBlockSpread(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoDripstoneSpread(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoMobSpawnsType(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoItemDamage(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoElytra(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NotifyEnter(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NotifyExit(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_NoPotionEffects(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_SpawnReasonWhitelist(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ViewContainers(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_ReadLecterns(this.flagManager, this.plugin));
                this.flagManager.registerFlagDefinition(new FlagDef_AllowWitherDamage(this.flagManager, this.plugin));
                try {
                    Class.forName("org.bukkit.event.raid.RaidTriggerEvent");
                    this.flagManager.registerFlagDefinition(new FlagDef_RaidMemberOnly(this.flagManager, this.plugin));
                }
                catch (ClassNotFoundException e) {
                    if (!Util.isRunningMinecraft(1, 14)) break block26;
                    Util.log("&cRaidEvent classes not found:");
                    Util.log("&7  - Update to latest Minecraft version for raid flag to work");
                }
            }
            try {
                Class.forName("com.destroystokyo.paper.event.block.AnvilDamagedEvent");
                this.flagManager.registerFlagDefinition(new FlagDef_NoAnvilDamage(this.flagManager, this.plugin));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                if (Bukkit.getPluginManager().getPlugin("mcMMO") != null) {
                    this.flagManager.registerFlagDefinition(new FlagDef_NoMcMMOSkills(this.flagManager, this.plugin));
                    this.flagManager.registerFlagDefinition(new FlagDef_NoMcMMODeathPenalty(this.flagManager, this.plugin));
                    this.flagManager.registerFlagDefinition(new FlagDef_NoMcMMOXP(this.flagManager, this.plugin));
                }
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            try {
                if (Bukkit.getPluginManager().getPlugin("EliteMobs") != null) {
                    this.flagManager.registerFlagDefinition(new FlagDef_NoEliteMobSpawns(this.flagManager, this.plugin));
                }
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            try {
                if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
                    this.plugin.getCommand("buybuildtrust").setExecutor((CommandExecutor)new CommandBuyBuildTrust());
                    this.plugin.getCommand("buycontainertrust").setExecutor((CommandExecutor)new CommandBuyContainerTrust());
                    this.plugin.getCommand("buyaccesstrust").setExecutor((CommandExecutor)new CommandBuyAccessTrust());
                    this.plugin.getCommand("buysubclaim").setExecutor((CommandExecutor)new CommandBuySubclaim());
                    this.flagManager.registerFlagDefinition(new FlagDef_BuyBuildTrust(this.flagManager, this.plugin));
                    this.flagManager.registerFlagDefinition(new FlagDef_BuyContainerTrust(this.flagManager, this.plugin));
                    this.flagManager.registerFlagDefinition(new FlagDef_BuyAccessTrust(this.flagManager, this.plugin));
                    this.flagManager.registerFlagDefinition(new FlagDef_BuySubclaim(this.flagManager, this.plugin));
                }
            }
            catch (NoClassDefFoundError e) {}
        } else {
            this.flagManager.getFlagDefinitions().forEach(flagDefinition -> flagDefinition.updateSettings(this.plugin.getWorldSettingsManager()));
        }
        try {
            File flagsFile = new File(FlagsDataStore.flagsFilePath);
            List<MessageSpecifier> errors = this.flagManager.load(flagsFile);
            if (errors.size() > 0) {
                File errorFile = new File(FlagsDataStore.flagsErrorFilePath);
                Files.copy((File)flagsFile, (File)errorFile);
                for (MessageSpecifier error : errors) {
                    Util.log("Load Error: " + this.plugin.getFlagsDataStore().getMessage(error.messageID, error.messageParams));
                }
                Util.log("Problems encountered reading the flags data file! Please share this log and your 'flagsError.yml' file with the developer.");
            }
        }
        catch (Exception e) {
            Util.log("Unable to initialize the file system data store.  Details:");
            Util.log(e.getMessage());
            e.printStackTrace();
        }
        Collection topLevelClaims = GriefPrevention.instance.dataStore.getClaims();
        HashSet<String> validIDs = new HashSet<String>();
        for (Claim claim : topLevelClaims) {
            validIDs.add(claim.getID().toString());
            for (Claim subclaim : claim.children) {
                validIDs.add(subclaim.getID().toString());
            }
        }
        this.flagManager.removeExceptClaimIDs(validIDs);
        Util.log("Finished loading data.");
    }
}

