/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.FlagsDataStore;
import me.ryanhamshire.GPFlags.GPFlagsConfig;
import me.ryanhamshire.GPFlags.WorldSettingsManager;
import me.ryanhamshire.GPFlags.commands.CommandAllFlags;
import me.ryanhamshire.GPFlags.commands.CommandGPFlags;
import me.ryanhamshire.GPFlags.commands.CommandListClaimFlags;
import me.ryanhamshire.GPFlags.commands.CommandSetClaimFlag;
import me.ryanhamshire.GPFlags.commands.CommandSetClaimFlagPlayer;
import me.ryanhamshire.GPFlags.commands.CommandSetDefaultClaimFlag;
import me.ryanhamshire.GPFlags.commands.CommandSetServerFlag;
import me.ryanhamshire.GPFlags.commands.CommandSetWorldFlag;
import me.ryanhamshire.GPFlags.commands.CommandUnsetClaimFlag;
import me.ryanhamshire.GPFlags.commands.CommandUnsetClaimFlagPlayer;
import me.ryanhamshire.GPFlags.commands.CommandUnsetDefaultClaimFlag;
import me.ryanhamshire.GPFlags.commands.CommandUnsetServerFlag;
import me.ryanhamshire.GPFlags.commands.CommandUnsetWorldFlag;
import me.ryanhamshire.GPFlags.flags.FlagDef_ViewContainers;
import me.ryanhamshire.GPFlags.listener.EntityMoveListener;
import me.ryanhamshire.GPFlags.listener.PlayerListener;
import me.ryanhamshire.GPFlags.metrics.Metrics;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GPFlags
extends JavaPlugin {
    private static GPFlags instance;
    private FlagsDataStore flagsDataStore;
    private final FlagManager flagManager = new FlagManager();
    private WorldSettingsManager worldSettingsManager;
    boolean registeredFlagDefinitions = false;
    private PlayerListener playerListener;

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        this.playerListener = new PlayerListener();
        Bukkit.getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        try {
            Class.forName("io.papermc.paper.event.entity.EntityMoveEvent");
            Bukkit.getPluginManager().registerEvents((Listener)new EntityMoveListener(), (Plugin)this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.flagsDataStore = new FlagsDataStore();
        this.reloadConfig();
        this.getCommand("allflags").setExecutor((CommandExecutor)new CommandAllFlags());
        this.getCommand("gpflags").setExecutor((CommandExecutor)new CommandGPFlags());
        this.getCommand("listclaimflags").setExecutor((CommandExecutor)new CommandListClaimFlags());
        this.getCommand("setclaimflag").setExecutor((CommandExecutor)new CommandSetClaimFlag());
        this.getCommand("setclaimflagplayer").setExecutor((CommandExecutor)new CommandSetClaimFlagPlayer());
        this.getCommand("setdefaultclaimflag").setExecutor((CommandExecutor)new CommandSetDefaultClaimFlag());
        this.getCommand("setserverflag").setExecutor((CommandExecutor)new CommandSetServerFlag());
        this.getCommand("setworldflag").setExecutor((CommandExecutor)new CommandSetWorldFlag());
        this.getCommand("unsetclaimflag").setExecutor((CommandExecutor)new CommandUnsetClaimFlag());
        this.getCommand("unsetclaimflagplayer").setExecutor((CommandExecutor)new CommandUnsetClaimFlagPlayer());
        this.getCommand("unsetdefaultclaimflag").setExecutor((CommandExecutor)new CommandUnsetDefaultClaimFlag());
        this.getCommand("unsetserverflag").setExecutor((CommandExecutor)new CommandUnsetServerFlag());
        this.getCommand("unsetworldflag").setExecutor((CommandExecutor)new CommandUnsetWorldFlag());
        Collection claims = GriefPrevention.instance.dataStore.getClaims();
        for (Claim claim : claims) {
            if (GPFlags.getInstance().getFlagManager().getFlag(claim, "AllowBlockExplosions") != null) {
                claim.areExplosivesAllowed = true;
            }
            if (GPFlags.getInstance().getFlagManager().getFlag(claim, "KeepLoaded") == null) continue;
            ArrayList chunks = claim.getChunks();
            for (Chunk chunk : chunks) {
                chunk.setForceLoaded(true);
                chunk.load(true);
            }
        }
        Metrics metrics = new Metrics(this, 17786);
        metrics.addCustomChart(new Metrics.AdvancedPie("most_popular_flags", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            for (String flag : GPFlags.getInstance().getFlagManager().getUsedFlags()) {
                valueMap.put(flag, 1);
            }
            return valueMap;
        }));
        float finish = (float)(System.currentTimeMillis() - start) / 1000.0f;
        Util.log("Successfully loaded in &b%.2f seconds", Float.valueOf(finish));
        if (this.getDescription().getVersion().contains("SNAPSHOT")) {
            Util.log("&eYou are running a snapshot version, things may not operate as expected");
        }
    }

    public void onDisable() {
        FlagDef_ViewContainers.getViewingInventories().forEach(inv -> {
            inv.setContents(new ItemStack[inv.getSize()]);
            new ArrayList<HumanEntity>(inv.getViewers()).forEach(HumanEntity::closeInventory);
        });
        if (this.flagsDataStore != null) {
            this.flagsDataStore.close();
            this.flagsDataStore = null;
        }
        instance = null;
        this.playerListener = null;
    }

    public void reloadConfig() {
        this.worldSettingsManager = new WorldSettingsManager();
        new GPFlagsConfig(this);
    }

    public static GPFlags getInstance() {
        return instance;
    }

    public FlagsDataStore getFlagsDataStore() {
        return this.flagsDataStore;
    }

    public FlagManager getFlagManager() {
        return this.flagManager;
    }

    public WorldSettingsManager getWorldSettingsManager() {
        return this.worldSettingsManager;
    }

    public PlayerListener getPlayerListener() {
        return this.playerListener;
    }
}

