/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagsDataStore;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class FlagManager {
    private final ConcurrentHashMap<String, FlagDefinition> definitions;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Flag>> flags;
    private final List<String> worlds = new ArrayList<String>();
    public static final String DEFAULT_FLAG_ID = "-2";

    public FlagManager() {
        this.definitions = new ConcurrentHashMap();
        this.flags = new ConcurrentHashMap();
        Bukkit.getWorlds().forEach(world -> this.worlds.add(world.getName()));
    }

    public void registerFlagDefinition(FlagDefinition def) {
        String name = def.getName();
        this.definitions.put(name.toLowerCase(), def);
    }

    public FlagDefinition getFlagDefinitionByName(String name) {
        return this.definitions.get(name.toLowerCase());
    }

    public Collection<FlagDefinition> getFlagDefinitions() {
        return new ArrayList<FlagDefinition>(this.definitions.values());
    }

    public Collection<String> getFlagDefinitionNames() {
        return new ArrayList<String>(this.definitions.keySet());
    }

    public SetFlagResult setFlag(Claim claim, FlagDefinition def, boolean isActive, boolean newFlag, String ... args) {
        return this.setFlag(claim.getID().toString(), def, isActive, newFlag, args);
    }

    public SetFlagResult setFlag(String claimId, FlagDefinition def, boolean isActive, boolean newFlag, String ... args) {
        String key;
        SetFlagResult result;
        StringBuilder parameters = new StringBuilder();
        for (String arg : args) {
            parameters.append(arg).append(" ");
        }
        parameters = new StringBuilder(parameters.toString().trim());
        if (isActive) {
            result = def.validateParameters(parameters.toString());
            if (!result.success) {
                return result;
            }
        } else {
            result = new SetFlagResult(true, def.getUnSetMessage());
        }
        Flag flag = new Flag(def, parameters.toString());
        flag.setSet(isActive);
        ConcurrentHashMap<String, Flag> claimFlags = this.flags.get(claimId);
        if (claimFlags == null) {
            claimFlags = new ConcurrentHashMap();
            this.flags.put(claimId, claimFlags);
        }
        if (!claimFlags.containsKey(key = def.getName().toLowerCase()) && isActive) {
            def.incrementInstances();
        }
        claimFlags.put(key, flag);
        if (newFlag) {
            Claim claim;
            try {
                claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(claimId));
            }
            catch (Exception ignored) {
                return result;
            }
            if (claim != null) {
                if (isActive) {
                    def.onFlagSet(claim, parameters.toString());
                } else {
                    def.onFlagUnset(claim);
                }
            }
        }
        return result;
    }

    public Flag getFlag(Claim claim, FlagDefinition flagDef) {
        if (claim == null || flagDef == null) {
            return null;
        }
        return this.getFlag(claim.getID().toString(), flagDef);
    }

    public Flag getFlag(String claimID, FlagDefinition flagDef) {
        if (claimID == null || flagDef == null) {
            return null;
        }
        return this.getFlag(claimID, flagDef.getName());
    }

    public Flag getFlag(Claim claim, String flag) {
        if (claim == null || flag == null) {
            return null;
        }
        return this.getFlag(claim.getID().toString(), flag);
    }

    public Flag getFlag(String claimID, String flag) {
        if (claimID == null || flag == null) {
            return null;
        }
        String flagString = flag.toLowerCase(Locale.ROOT);
        ConcurrentHashMap<String, Flag> claimFlags = this.flags.get(claimID);
        if (claimFlags != null && claimFlags.containsKey(flagString)) {
            return claimFlags.get(flagString);
        }
        if (claimID.equalsIgnoreCase("everywhere") || this.worlds.contains(claimID)) {
            return null;
        }
        ConcurrentHashMap<String, Flag> defaultFlags = this.flags.get(DEFAULT_FLAG_ID);
        if (defaultFlags != null && defaultFlags.containsKey(flagString)) {
            try {
                Integer.parseInt(claimID);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            return defaultFlags.get(flagString);
        }
        return null;
    }

    public Collection<Flag> getFlags(Claim claim) {
        if (claim == null) {
            return null;
        }
        return this.getFlags(claim.getID().toString());
    }

    public Collection<Flag> getFlags(String claimID) {
        if (claimID == null) {
            return null;
        }
        ConcurrentHashMap<String, Flag> claimFlags = this.flags.get(claimID);
        if (claimFlags == null) {
            return new ArrayList<Flag>();
        }
        return new ArrayList<Flag>(claimFlags.values());
    }

    public SetFlagResult unSetFlag(Claim claim, FlagDefinition def, boolean newFlag) {
        return this.unSetFlag(claim.getID().toString(), def, newFlag);
    }

    public SetFlagResult unSetFlag(String claimID, FlagDefinition def, boolean newFlag) {
        ConcurrentHashMap<String, Flag> claimFlags = this.flags.get(claimID);
        if (claimFlags == null || !claimFlags.containsKey(def.getName().toLowerCase())) {
            return this.setFlag(claimID, def, false, newFlag, new String[0]);
        }
        claimFlags.remove(def.getName().toLowerCase());
        return new SetFlagResult(true, def.getUnSetMessage());
    }

    List<MessageSpecifier> load(String input) throws InvalidConfigurationException {
        this.flags.clear();
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.loadFromString(input);
        ArrayList<MessageSpecifier> errors = new ArrayList<MessageSpecifier>();
        Set claimIDs = yaml.getKeys(false);
        for (String claimID : claimIDs) {
            Set flagNames = yaml.getConfigurationSection(claimID).getKeys(false);
            for (String flagName : flagNames) {
                String paramsDefault = yaml.getString(claimID + "." + flagName);
                String params = yaml.getString(claimID + "." + flagName + ".params", paramsDefault);
                boolean set = yaml.getBoolean(claimID + "." + flagName + ".value", true);
                FlagDefinition def = this.getFlagDefinitionByName(flagName);
                if (def == null) continue;
                SetFlagResult result = this.setFlag(claimID, def, set, false, params);
                if (result.success) continue;
                errors.add(result.message);
            }
        }
        return errors;
    }

    public void save() {
        try {
            this.save(FlagsDataStore.flagsFilePath);
        }
        catch (Exception e) {
            Util.log("Failed to save flag data.  Details:");
            e.printStackTrace();
        }
    }

    public HashSet<String> getUsedFlags() {
        HashSet<String> usedFlags = new HashSet<String>();
        Set claimIDs = this.flags.keySet();
        for (String claimID : claimIDs) {
            ConcurrentHashMap<String, Flag> claimFlags = this.flags.get(claimID);
            usedFlags.addAll(claimFlags.keySet());
        }
        return usedFlags;
    }

    public String flagsToString() {
        YamlConfiguration yaml = new YamlConfiguration();
        Set claimIDs = this.flags.keySet();
        for (String claimID : claimIDs) {
            ConcurrentHashMap<String, Flag> claimFlags = this.flags.get(claimID);
            Set flagNames = claimFlags.keySet();
            for (String flagName : flagNames) {
                Flag flag = claimFlags.get(flagName);
                String paramsPath = claimID + "." + flagName + ".params";
                yaml.set(paramsPath, (Object)flag.parameters);
                String valuePath = claimID + "." + flagName + ".value";
                yaml.set(valuePath, (Object)flag.getSet());
            }
        }
        return yaml.saveToString();
    }

    public void save(String filepath) throws IOException {
        String fileContent = this.flagsToString();
        File file = new File(filepath);
        file.getParentFile().mkdirs();
        file.createNewFile();
        Files.write((byte[])fileContent.getBytes("UTF-8"), (File)file);
    }

    public List<MessageSpecifier> load(File file) throws IOException, InvalidConfigurationException {
        if (!file.exists()) {
            return this.load("");
        }
        List lines = Files.readLines((File)file, (Charset)Charset.forName("UTF-8"));
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(line).append('\n');
        }
        return this.load(builder.toString());
    }

    public void clear() {
        this.flags.clear();
    }

    void removeExceptClaimIDs(HashSet<String> validClaimIDs) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String key : this.flags.keySet()) {
            if (validClaimIDs.contains(key)) continue;
            try {
                int numericalValue = Integer.parseInt(key);
                if (numericalValue < 0) continue;
                toRemove.add(key);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (String key : toRemove) {
            this.flags.remove(key);
        }
        this.save();
    }
}

