/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandList {
    private final ConcurrentHashMap<String, Boolean> seenCommands = new ConcurrentHashMap();
    private final ArrayList<String> commandsFromConfig = new ArrayList();

    public CommandList(String commandNamesList) {
        String[] commandNames = commandNamesList.split(";");
        for (int i = 0; i < commandNames.length; ++i) {
            String commandName = commandNames[i].trim().toLowerCase();
            if (commandName.startsWith("/")) {
                commandName = commandName.substring(1);
            }
            this.commandsFromConfig.add(commandName);
        }
    }

    public boolean Contains(String commandName) {
        Boolean result;
        if ((commandName = commandName.toLowerCase().trim()).startsWith("/")) {
            commandName = commandName.substring(1);
        }
        if ((result = this.seenCommands.get(commandName)) != null) {
            return result;
        }
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(commandName);
        aliases.add("minecraft:" + commandName);
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            JavaPlugin javaPlugin = (JavaPlugin)plugin;
            PluginCommand command = javaPlugin.getCommand(commandName);
            if (command == null) continue;
            aliases.add(command.getName().toLowerCase());
            aliases.add(plugin.getName().toLowerCase() + ":" + command.getName().toLowerCase());
            for (String alias : command.getAliases()) {
                aliases.add(alias.toLowerCase());
                aliases.add(plugin.getName().toLowerCase() + ":" + alias.toLowerCase());
            }
        }
        PluginCommand command = Bukkit.getServer().getPluginCommand(commandName);
        if (command != null) {
            for (String alias : command.getAliases()) {
                aliases.add(alias.toLowerCase());
                aliases.add("minecraft:" + alias.toLowerCase());
            }
        }
        result = false;
        for (String alias : aliases) {
            if (!this.commandsFromConfig.contains(alias)) continue;
            result = true;
            break;
        }
        for (String alias : aliases) {
            this.seenCommands.put(alias, result);
        }
        return result;
    }
}

