/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    protected static final Pattern INTERVAL_PATTERN = Pattern.compile("((?:\\d+)|(?:\\d+\\.\\d+))\\s*(second|minute|hour|day|week|month|year|s|m|h|d|w)", 2);

    public static int parseInterval(String arg) {
        if (arg.matches("^\\d+$")) {
            return Integer.parseInt(arg);
        }
        Matcher match = INTERVAL_PATTERN.matcher(arg);
        int interval = 0;
        while (match.find()) {
            interval += Math.round(Float.parseFloat(match.group(1)) * (float)DateUtils.getSecondsIn(match.group(2)));
        }
        return interval;
    }

    public static int getSecondsIn(String type) {
        if ("second".equals(type = type.toLowerCase()) || "s".equals(type)) {
            return 1;
        }
        if ("minute".equals(type) || "m".equals(type)) {
            return 60;
        }
        if ("hour".equals(type) || "h".equals(type)) {
            return 3600;
        }
        if ("day".equals(type) || "d".equals(type)) {
            return 86400;
        }
        if ("week".equals(type) || "w".equals(type)) {
            return 604800;
        }
        if ("month".equals(type)) {
            return 2592000;
        }
        if ("year".equals(type)) {
            return 31104000;
        }
        return 0;
    }
}

