/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit.regexperms;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import ru.tehkode.permissions.PermissionCheckResult;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.ErrorReport;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.utils.FieldReplacer;

public class PermissiblePEX
extends PermissibleBase {
    private static final FieldReplacer<PermissibleBase, Map> PERMISSIONS_FIELD = new FieldReplacer<PermissibleBase, Map>(PermissibleBase.class, "permissions", Map.class);
    private static final FieldReplacer<PermissibleBase, List> ATTACHMENTS_FIELD = new FieldReplacer<PermissibleBase, List>(PermissibleBase.class, "attachments", List.class);
    private static final Method CALC_CHILD_PERMS_METH;
    private final Map<String, PermissionAttachmentInfo> permissions;
    private final List<PermissionAttachment> attachments;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final AtomicBoolean LAST_CALL_ERRORED;
    protected final Player player;
    protected final PermissionsEx plugin;
    private Permissible previousPermissible = null;
    protected final Map<String, PermissionCheckResult> cache = new ConcurrentHashMap<String, PermissionCheckResult>();

    public PermissiblePEX(Player player, PermissionsEx plugin) {
        super((ServerOperator)player);
        this.player = player;
        this.plugin = plugin;
        this.permissions = new LinkedHashMap<String, PermissionAttachmentInfo>(){

            @Override
            public PermissionAttachmentInfo put(String k, PermissionAttachmentInfo v) {
                PermissionAttachmentInfo existing = (PermissionAttachmentInfo)this.get(k);
                if (existing != null) {
                    return existing;
                }
                return super.put(k, v);
            }
        };
        PERMISSIONS_FIELD.set(this, this.permissions);
        this.attachments = ATTACHMENTS_FIELD.get(this);
        this.recalculatePermissions();
    }

    public Permissible getPreviousPermissible() {
        return this.previousPermissible;
    }

    public void setPreviousPermissible(Permissible previousPermissible) {
        this.previousPermissible = previousPermissible;
    }

    public boolean isDebug() {
        boolean debug = this.plugin.isDebug();
        try {
            PermissionUser user = this.plugin.getPermissionsManager().getUser(this.player);
            if (user != null) {
                debug |= user.isDebug();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(String permission) {
        this.lock.readLock().lock();
        try {
            PermissionCheckResult res = this.permissionValue(permission);
            switch (res) {
                case TRUE: 
                case FALSE: {
                    boolean bl = res.toBoolean();
                    return bl;
                }
            }
            if (super.isPermissionSet(permission)) {
                boolean ret = super.hasPermission(permission);
                if (this.isDebug()) {
                    this.plugin.getLogger().info("User " + this.player.getName() + " checked for permission '" + permission + "', superperms-matched a value of " + ret);
                }
                boolean bl = ret;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(Permission permission) {
        this.lock.readLock().lock();
        try {
            PermissionCheckResult res = this.permissionValue(permission.getName());
            switch (res) {
                case TRUE: 
                case FALSE: {
                    boolean bl = res.toBoolean();
                    return bl;
                }
            }
            if (super.isPermissionSet(permission.getName())) {
                boolean ret = super.hasPermission(permission);
                if (this.isDebug()) {
                    this.plugin.getLogger().info("User " + this.player.getName() + " checked for permission '" + permission.getName() + "', superperms-matched a value of " + ret);
                }
                boolean bl = ret;
                return bl;
            }
            boolean bl = permission.getDefault().getValue(this.player.isOp());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculatePermissions() {
        if (this.lock != null) {
            this.lock.writeLock().lock();
            try {
                this.clearPermissions();
                this.cache.clear();
                ListIterator<PermissionAttachment> it = this.attachments.listIterator(this.attachments.size());
                while (it.hasPrevious()) {
                    PermissionAttachment attach = it.previous();
                    this.calculateChildPerms(attach.getPermissions(), false, attach);
                }
                for (Permission p : this.player.getServer().getPluginManager().getDefaultPermissions(this.isOp())) {
                    this.permissions.put(p.getName(), new PermissionAttachmentInfo((Permissible)this.player, p.getName(), null, true));
                    this.calculateChildPerms(p.getChildren(), false, null);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected void calculateChildPerms(Map<String, Boolean> children, boolean invert, PermissionAttachment attachment) {
        try {
            CALC_CHILD_PERMS_METH.invoke((Object)this, children, invert, attachment);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPermissionSet(String permission) {
        this.lock.readLock().lock();
        try {
            boolean bl = super.isPermissionSet(permission) || this.permissionValue(permission) != PermissionCheckResult.UNDEFINED;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return new LinkedHashSet<PermissionAttachmentInfo>(this.permissions.values());
    }

    private PermissionCheckResult checkSingle(String expression, String permission, boolean value) {
        if (this.plugin.getPermissionsManager().getPermissionMatcher().isMatches(expression, permission)) {
            PermissionCheckResult res = PermissionCheckResult.fromBoolean(value);
            if (this.isDebug()) {
                this.plugin.getLogger().info("User " + this.player.getName() + " checked for permission '" + permission + "', regex-matched a value of " + (Object)((Object)res) + " from " + expression + " (CACHE MISS)");
            }
            return res;
        }
        return PermissionCheckResult.UNDEFINED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PermissionCheckResult permissionValue(String permission) {
        this.lock.readLock().lock();
        try {
            PermissionAttachmentInfo permissionAttachmentInfo;
            permission = permission.toLowerCase();
            PermissionCheckResult res = this.cache.get(permission);
            if (res != null) {
                if (this.isDebug()) {
                    this.plugin.getLogger().info("User " + this.player.getName() + " checked for permission '" + permission + "', regex-matched a value of " + (Object)((Object)res) + " from cache.");
                }
                PermissionCheckResult permissionCheckResult = res;
                return permissionCheckResult;
            }
            res = PermissionCheckResult.UNDEFINED;
            Iterator<Object> i$ = this.permissions.values().iterator();
            while (i$.hasNext() && (res = this.checkSingle((permissionAttachmentInfo = i$.next()).getPermission(), permission, permissionAttachmentInfo.getValue())) == PermissionCheckResult.UNDEFINED) {
            }
            if (res == PermissionCheckResult.UNDEFINED) {
                for (Map.Entry entry : this.plugin.getRegexPerms().getPermissionList().getParents(permission)) {
                    res = this.permissionValue((String)entry.getKey());
                    if (res == PermissionCheckResult.UNDEFINED) continue;
                    res = PermissionCheckResult.fromBoolean(!(res.toBoolean() ^ (Boolean)entry.getValue()));
                    if (!this.isDebug()) break;
                    this.plugin.getLogger().info("User " + this.player.getName() + " checked for permission '" + permission + "', match from parent '" + (String)entry.getKey() + "' (CACHE MISS)");
                    break;
                }
            }
            this.cache.put(permission, res);
            if (res == PermissionCheckResult.UNDEFINED && this.isDebug()) {
                this.plugin.getLogger().info("User " + this.player.getName() + " checked for permission '" + permission + "', no match found (CACHE MISS)");
            }
            LAST_CALL_ERRORED.set(false);
            PermissionCheckResult permissionCheckResult = res;
            return permissionCheckResult;
        }
        catch (Throwable t) {
            if (LAST_CALL_ERRORED.compareAndSet(false, true)) {
                ErrorReport.handleError("Permissible permissionValue for " + this.player.getName(), t);
            }
            PermissionCheckResult permissionCheckResult = PermissionCheckResult.UNDEFINED;
            return permissionCheckResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    static {
        try {
            CALC_CHILD_PERMS_METH = PermissibleBase.class.getDeclaredMethod("calculateChildPermissions", Map.class, Boolean.TYPE, PermissionAttachment.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        CALC_CHILD_PERMS_METH.setAccessible(true);
        LAST_CALL_ERRORED = new AtomicBoolean(false);
    }
}

