/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.ErrorReport;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.events.PermissionSystemEvent;

public class SuperpermsListener
implements Listener {
    private final PermissionsEx plugin;
    private final Map<String, PermissionAttachment> attachments = new HashMap<String, PermissionAttachment>();

    public SuperpermsListener(PermissionsEx plugin) {
        this.plugin = plugin;
        for (Player player : plugin.getServer().getOnlinePlayers()) {
            this.updateAttachment(player);
        }
    }

    protected void updateAttachment(Player player) {
        this.updateAttachment(player, player.getWorld().getName());
    }

    protected void updateAttachment(Player player, String worldName) {
        PermissionUser user;
        PermissionAttachment attach = this.attachments.get(player.getName());
        Permission playerPerm = this.getCreateWrapper(player, "");
        Permission playerOptionPerm = this.getCreateWrapper(player, ".options");
        if (attach == null) {
            attach = player.addAttachment((Plugin)this.plugin);
            this.attachments.put(player.getName(), attach);
            attach.setPermission(playerPerm, true);
        }
        if ((user = this.plugin.getPermissionsManager().getUser(player)) != null) {
            this.updatePlayerPermission(playerPerm, player, user, worldName);
            this.updatePlayerMetadata(playerOptionPerm, user, worldName);
            player.recalculatePermissions();
        }
    }

    private String permissionName(Player player, String suffix) {
        return "permissionsex.player." + player.getName() + suffix;
    }

    private void removePEXPerm(Player player, String suffix) {
        this.plugin.getServer().getPluginManager().removePermission(this.permissionName(player, suffix));
    }

    private Permission getCreateWrapper(Player player, String suffix) {
        String name = this.permissionName(player, suffix);
        Permission perm = this.plugin.getServer().getPluginManager().getPermission(name);
        if (perm == null) {
            perm = new Permission(name, "Internal permission for PEX. DO NOT SET DIRECTLY", PermissionDefault.FALSE);
            this.plugin.getServer().getPluginManager().addPermission(perm);
        }
        return perm;
    }

    private void updatePlayerPermission(Permission permission, Player player, PermissionUser user, String worldName) {
        permission.getChildren().clear();
        permission.getChildren().put(this.permissionName(player, ".options"), true);
        for (String perm : user.getPermissions(worldName)) {
            boolean value = true;
            if (perm.startsWith("-")) {
                value = false;
                perm = perm.substring(1);
            }
            if (permission.getChildren().containsKey(perm)) continue;
            permission.getChildren().put(perm, value);
        }
    }

    private void updatePlayerMetadata(Permission rootPermission, PermissionUser user, String worldName) {
        rootPermission.getChildren().clear();
        String[] groups = user.getGroupsNames(worldName);
        Map<String, String> options = user.getOptions(worldName);
        for (String group : groups) {
            rootPermission.getChildren().put("groups." + group, true);
            rootPermission.getChildren().put("group." + group, true);
        }
        for (Map.Entry<String, String> option : options.entrySet()) {
            rootPermission.getChildren().put("options." + option.getKey() + "." + option.getValue(), true);
        }
        rootPermission.getChildren().put("prefix." + user.getPrefix(worldName), true);
        rootPermission.getChildren().put("suffix." + user.getSuffix(worldName), true);
    }

    protected void removeAttachment(Player player) {
        PermissionAttachment attach = this.attachments.remove(player.getName());
        if (attach != null) {
            attach.remove();
        }
        this.removePEXPerm(player, "");
        this.removePEXPerm(player, ".options");
    }

    public void onDisable() {
        for (PermissionAttachment attach : this.attachments.values()) {
            attach.remove();
        }
        this.attachments.clear();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        try {
            this.updateAttachment(event.getPlayer());
        }
        catch (Throwable t) {
            ErrorReport.handleError("Superperms event join", t);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerLoginEvent event) {
        try {
            Player player = event.getPlayer();
            this.updateAttachment(player, null);
        }
        catch (Throwable t) {
            ErrorReport.handleError("Superperms event login", t);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        try {
            this.removeAttachment(event.getPlayer());
        }
        catch (Throwable t) {
            ErrorReport.handleError("Superperms event quit", t);
        }
    }

    private void updateSelective(PermissionEntityEvent event, PermissionUser user) {
        Player p = this.plugin.getServer().getPlayerExact(user.getName());
        if (p != null) {
            switch (event.getAction()) {
                case SAVED: {
                    break;
                }
                case PERMISSIONS_CHANGED: 
                case TIMEDPERMISSION_EXPIRED: {
                    this.updatePlayerPermission(this.getCreateWrapper(p, ""), p, user, p.getWorld().getName());
                    p.recalculatePermissions();
                    break;
                }
                case OPTIONS_CHANGED: 
                case INFO_CHANGED: {
                    this.updatePlayerMetadata(this.getCreateWrapper(p, ".options"), user, p.getWorld().getName());
                    p.recalculatePermissions();
                    break;
                }
                default: {
                    this.updateAttachment(p);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityEvent(PermissionEntityEvent event) {
        try {
            if (event.getEntity() instanceof PermissionUser) {
                this.updateSelective(event, (PermissionUser)event.getEntity());
            } else if (event.getEntity() instanceof PermissionGroup) {
                for (PermissionUser user : this.plugin.getPermissionsManager().getUsers(event.getEntity().getName(), true)) {
                    this.updateSelective(event, user);
                }
            }
        }
        catch (Throwable t) {
            ErrorReport.handleError("Superperms event permission entity", t);
        }
    }

    @EventHandler
    public void onWorldChanged(PlayerChangedWorldEvent event) {
        try {
            this.updateAttachment(event.getPlayer());
        }
        catch (Throwable t) {
            ErrorReport.handleError("Superperms event world change", t);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onSystemEvent(PermissionSystemEvent event) {
        try {
            if (event.getAction() == PermissionSystemEvent.Action.DEBUGMODE_TOGGLE) {
                return;
            }
            switch (event.getAction()) {
                case DEBUGMODE_TOGGLE: 
                case REINJECT_PERMISSIBLES: {
                    return;
                }
            }
            for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                this.updateAttachment(p);
            }
        }
        catch (Throwable t) {
            ErrorReport.handleError("Superperms event permission system event", t);
        }
    }
}

