/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit;

import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import ru.tehkode.permissions.PermissionBackend;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.backends.FileBackend;
import ru.tehkode.permissions.backends.SQLBackend;
import ru.tehkode.permissions.bukkit.ErrorReport;
import ru.tehkode.permissions.bukkit.SuperpermsListener;
import ru.tehkode.permissions.bukkit.commands.GroupCommands;
import ru.tehkode.permissions.bukkit.commands.PromotionCommands;
import ru.tehkode.permissions.bukkit.commands.UserCommands;
import ru.tehkode.permissions.bukkit.commands.UtilityCommands;
import ru.tehkode.permissions.bukkit.commands.WorldCommands;
import ru.tehkode.permissions.bukkit.regexperms.RegexPermissions;
import ru.tehkode.permissions.commands.CommandsManager;
import ru.tehkode.permissions.exceptions.PermissionBackendException;
import ru.tehkode.permissions.exceptions.PermissionsNotAvailable;
import ru.tehkode.utils.StringUtils;

public class PermissionsEx
extends JavaPlugin {
    protected static final String CONFIG_FILE = "config.yml";
    protected PermissionManager permissionsManager;
    protected CommandsManager commandsManager;
    protected FileConfiguration config;
    protected SuperpermsListener superms;
    private RegexPermissions regexPerms;
    private boolean errored = false;
    private static PermissionsEx instance;

    public PermissionsEx() {
        instance = this;
        PermissionBackend.registerBackendAlias("sql", SQLBackend.class);
        PermissionBackend.registerBackendAlias("file", FileBackend.class);
    }

    private void logBackendExc(PermissionBackendException e) {
        this.getLogger().log(Level.SEVERE, "\n========== UNABLE TO LOAD PERMISSIONS BACKEND =========\nYour configuration must be fixed before PEX will enable\nDetails: " + e.getMessage() + "\n" + "=======================================================", e);
    }

    public void onLoad() {
        try {
            this.config = this.getConfig();
            this.commandsManager = new CommandsManager((Plugin)this);
            this.permissionsManager = new PermissionManager((Configuration)this.config);
        }
        catch (PermissionBackendException e) {
            this.logBackendExc(e);
            this.errored = true;
        }
        catch (Throwable t) {
            ErrorReport.handleError("In onLoad", t);
            this.errored = true;
        }
    }

    public void onEnable() {
        if (this.errored) {
            this.getLogger().severe("==== PermissionsEx could not be enabled due to an earlier error. Look at the previous server log for more info ====");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        try {
            if (this.permissionsManager == null) {
                this.permissionsManager = new PermissionManager((Configuration)this.config);
            }
            this.commandsManager.register(new UserCommands());
            this.commandsManager.register(new GroupCommands());
            this.commandsManager.register(new PromotionCommands());
            this.commandsManager.register(new WorldCommands());
            this.commandsManager.register(new UtilityCommands());
            PlayerEventsListener cleaner = new PlayerEventsListener();
            cleaner.logLastPlayerLogin = this.config.getBoolean("permissions.log-players", cleaner.logLastPlayerLogin);
            this.getServer().getPluginManager().registerEvents((Listener)cleaner, (Plugin)this);
            this.getServer().getServicesManager().register(PermissionManager.class, (Object)this.permissionsManager, (Plugin)this, ServicePriority.Normal);
            this.regexPerms = new RegexPermissions(this);
            this.superms = new SuperpermsListener(this);
            this.getServer().getPluginManager().registerEvents((Listener)this.superms, (Plugin)this);
            this.saveConfig();
            this.permissionsManager.initTimer();
        }
        catch (PermissionBackendException e) {
            this.logBackendExc(e);
            this.getPluginLoader().disablePlugin((Plugin)this);
        }
        catch (Throwable t) {
            ErrorReport.handleError("Error while enabling: ", t);
            this.getPluginLoader().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        try {
            if (this.permissionsManager != null) {
                this.permissionsManager.end();
            }
            this.getServer().getServicesManager().unregister(PermissionManager.class, (Object)this.permissionsManager);
            if (this.regexPerms != null) {
                this.regexPerms.onDisable();
            }
            if (this.superms != null) {
                this.superms.onDisable();
            }
        }
        catch (Throwable t) {
            ErrorReport.handleError("While disabling", t);
        }
        ErrorReport.shutdown();
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        try {
            PluginDescriptionFile pdf = this.getDescription();
            if (args.length > 0) {
                return this.commandsManager.execute(sender, command, args);
            }
            if (sender instanceof Player) {
                sender.sendMessage("[" + ChatColor.RED + "PermissionsEx" + ChatColor.WHITE + "] version [" + ChatColor.BLUE + pdf.getVersion() + ChatColor.WHITE + "]");
                return !this.permissionsManager.has((Player)sender, "permissions.manage");
            }
            sender.sendMessage("[PermissionsEx] version [" + pdf.getVersion() + "]");
            return false;
        }
        catch (Throwable t) {
            ErrorReport.handleError("While " + sender.getName() + " was executing /" + command.getName() + " " + StringUtils.implode(args, " "), t, sender);
            return true;
        }
    }

    public boolean isDebug() {
        return this.permissionsManager.isDebug();
    }

    public static Plugin getPlugin() {
        return instance;
    }

    public RegexPermissions getRegexPerms() {
        return this.regexPerms;
    }

    public static boolean isAvailable() {
        Plugin plugin = PermissionsEx.getPlugin();
        return plugin.isEnabled() && ((PermissionsEx)plugin).permissionsManager != null;
    }

    public static PermissionManager getPermissionManager() {
        if (!PermissionsEx.isAvailable()) {
            throw new PermissionsNotAvailable();
        }
        return ((PermissionsEx)PermissionsEx.getPlugin()).permissionsManager;
    }

    public PermissionManager getPermissionsManager() {
        return this.permissionsManager;
    }

    public static PermissionUser getUser(Player player) {
        return PermissionsEx.getPermissionManager().getUser(player);
    }

    public static PermissionUser getUser(String name) {
        return PermissionsEx.getPermissionManager().getUser(name);
    }

    public boolean has(Player player, String permission) {
        return this.permissionsManager.has(player, permission);
    }

    public boolean has(Player player, String permission, String world) {
        return this.permissionsManager.has(player, permission, world);
    }

    public class PlayerEventsListener
    implements Listener {
        protected boolean logLastPlayerLogin = false;

        @EventHandler
        public void onPlayerLogin(PlayerLoginEvent event) {
            try {
                if (!this.logLastPlayerLogin) {
                    return;
                }
                PermissionUser user = PermissionsEx.getPermissionManager().getUser(event.getPlayer());
                user.setOption("last-login-time", Long.toString(System.currentTimeMillis() / 1000L));
            }
            catch (Throwable t) {
                ErrorReport.handleError("While login cleanup event", t);
            }
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            try {
                if (this.logLastPlayerLogin) {
                    PermissionsEx.getPermissionManager().getUser(event.getPlayer()).setOption("last-logout-time", Long.toString(System.currentTimeMillis() / 1000L));
                }
                PermissionsEx.getPermissionManager().resetUser(event.getPlayer().getName());
            }
            catch (Throwable t) {
                ErrorReport.handleError("While logout cleanup event", t);
            }
        }
    }
}

