/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.utils.StringUtils;

public class ErrorReport {
    private static final ExecutorService ASYNC_EXEC = Executors.newSingleThreadExecutor();
    private static final String UTF8_ENCODING = "utf-8";
    private static final ThreadLocal<Yaml> YAML_INSTANCE = new ThreadLocal<Yaml>(){

        @Override
        protected Yaml initialValue() {
            DumperOptions opts = new DumperOptions();
            opts.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
            opts.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
            opts.setPrettyFlow(true);
            opts.setWidth(Integer.MAX_VALUE);
            return new Yaml(opts);
        }
    };
    private static final URL GIST_POST_URL;
    public static final String LONG_URL_FORMAT = "https://github.com/PEXPlugins/PermissionsEx/issues/new?title=%s&body=%s";
    private String shortURL;
    private final String title;
    private final String message;
    private final Throwable error;

    private ErrorReport(String title, String message, Throwable error) {
        this.title = title;
        this.message = message;
        this.error = error;
    }

    public static String shortenURL(String url) {
        URL shortUrlApi;
        try {
            shortUrlApi = new URL("http://is.gd/create.php?format=simple&url=" + URLEncoder.encode(url, UTF8_ENCODING));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return url;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return url;
        }
        try {
            URLConnection conn = shortUrlApi.openConnection();
            return StringUtils.readStream(conn.getInputStream());
        }
        catch (IOException ex) {
            return url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gistText(String text) {
        Yaml yaml = YAML_INSTANCE.get();
        OutputStreamWriter requestWriter = null;
        InputStream responseReader = null;
        try {
            URLConnection conn = GIST_POST_URL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("description", "PEX Error Report");
            request.put("public", "false");
            HashMap filesMap = new HashMap();
            HashMap<String, String> singleFileMap = new HashMap<String, String>();
            singleFileMap.put("content", text);
            filesMap.put("report.md", singleFileMap);
            request.put("files", filesMap);
            requestWriter = new OutputStreamWriter(conn.getOutputStream());
            yaml.dump(request, (Writer)requestWriter);
            responseReader = conn.getInputStream();
            Map data = (Map)yaml.load(responseReader);
            if (data.containsKey("html_url")) {
                String string = data.get("html_url").toString();
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (requestWriter != null) {
                try {
                    requestWriter.close();
                }
                catch (IOException ignore) {}
            }
            if (responseReader != null) {
                try {
                    responseReader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    public String getShortURL() {
        if (this.shortURL == null) {
            this.shortURL = ErrorReport.shortenURL(this.getLongURL());
        }
        return this.shortURL;
    }

    public String getLongURL() {
        try {
            return String.format(LONG_URL_FORMAT, URLEncoder.encode(this.title, UTF8_ENCODING), URLEncoder.encode(this.message, UTF8_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getErrorBody() {
        return this.message;
    }

    public String buildUserErrorMessage() {
        StringBuilder build = new StringBuilder("Error occurred with PermissionsEx! Please post it to ").append(this.getShortURL()).append(". Full error:\n");
        StringWriter writer = new StringWriter();
        PrintWriter pWriter = new PrintWriter(writer);
        if (this.error != null) {
            this.error.printStackTrace(pWriter);
            build.append(writer);
            pWriter.close();
        } else {
            build.append("Not specified");
        }
        return build.toString();
    }

    public static void handleError(Throwable error) {
        ErrorReport.handleError(null, error);
    }

    public static void handleError(String cause, Throwable error) {
        ErrorReport.handleError(cause, error, null);
    }

    public static void handleError(final String cause, final Throwable error, final CommandSender target) {
        if (!ASYNC_EXEC.isShutdown()) {
            ASYNC_EXEC.submit(new Runnable(){

                @Override
                public void run() {
                    String msg = ErrorReport.withException(cause, error).buildUserErrorMessage();
                    if (target != null) {
                        target.sendMessage(msg);
                    } else {
                        PermissionsEx.getPlugin().getLogger().severe(msg);
                    }
                }
            });
        } else {
            String msg = ErrorReport.withException(cause, error).buildUserErrorMessage();
            if (target != null) {
                target.sendMessage(msg);
            } else {
                PermissionsEx.getPlugin().getLogger().severe(msg);
            }
        }
    }

    public static void shutdown() {
        ASYNC_EXEC.shutdown();
    }

    public static ErrorReport withException(String cause, Throwable error) {
        String configuration;
        Builder builder = ErrorReport.builder(error);
        Plugin pexPlugin = PermissionsEx.getPlugin();
        builder.addHeading("Basic info").addText("**Bukkit version:** " + Bukkit.getBukkitVersion() + " running on " + Bukkit.getVersion());
        if (pexPlugin != null) {
            StringBuilder pluginList = new StringBuilder("**Plugins:** (*italics* are disabled)\n");
            Plugin[] plugins = pexPlugin.getServer().getPluginManager().getPlugins();
            for (int i = 0; i < plugins.length; ++i) {
                Plugin plugin = plugins[i];
                pluginList.append("- ");
                if (plugin.getDescription() != null) {
                    if (plugin.isEnabled()) {
                        pluginList.append(plugin.getDescription().getFullName());
                    } else {
                        pluginList.append("*").append(plugin.getDescription().getFullName()).append("*");
                    }
                } else {
                    pluginList.append("Unknown");
                }
                pluginList.append(" (```").append(plugin.getClass().getName()).append("```)").append('\n');
            }
            builder.addText(pluginList.toString());
        }
        builder.addHeading("What PEX Saw");
        if (cause != null) {
            builder.addText("**Reason:** " + cause);
        }
        if (error != null) {
            StringWriter w = new StringWriter();
            error.printStackTrace(new PrintWriter(w));
            w.flush();
            String exStackTrace = w.getBuffer().toString();
            builder.addText("**Stacktrace:**").addCode(exStackTrace, null);
        }
        YamlConfiguration pexConfig = new YamlConfiguration();
        boolean successfulLoad = false;
        File mainConfigFile = new File(pexPlugin.getDataFolder(), "config.yml");
        String permissionsDb = "Permissions configuration could not be read. Does it exist?";
        if (mainConfigFile.exists()) {
            try {
                pexConfig.load(mainConfigFile);
                successfulLoad = true;
            }
            catch (IOException ignore) {
            }
            catch (InvalidConfigurationException ignore) {
                // empty catch block
            }
            try {
                configuration = StringUtils.readStream(new FileInputStream(mainConfigFile));
            }
            catch (IOException e1) {
                configuration = "Unable to read configuration file at: " + mainConfigFile.getAbsolutePath();
            }
        } else {
            configuration = "PEX configuration does not exist!";
        }
        configuration = configuration.replaceAll("password: (.*)", "password: XXXXXXXXXX");
        builder.addHeading("PEX configuration").addCode(configuration, "yaml");
        if (pexConfig.getString("permissions.backend", "file").equalsIgnoreCase("file")) {
            File file = new File(pexPlugin.getDataFolder(), pexConfig.getString("permissions.backends.file.file", "permissions.yml"));
            if (file.exists()) {
                try {
                    permissionsDb = StringUtils.readStream(new FileInputStream(file));
                }
                catch (IOException ignore) {}
            }
        } else {
            permissionsDb = "Backend is not file, see configuration file for details";
        }
        builder.addHeading("Permissions database");
        if (!successfulLoad) {
            builder.addText("PEX configuration could not be successfully loaded, attempting to read default permissions file");
        }
        builder.addCode(permissionsDb, "yaml");
        return builder.build();
    }

    public static Builder builder(Throwable error) {
        return new Builder("", error);
    }

    static {
        try {
            GIST_POST_URL = new URL("https://api.github.com/gists");
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ErrorReport.handleError("Unknown error in thread " + t.getName() + "-" + t.getId(), e);
        }
    }

    public static class Builder {
        private final String name;
        private final StringBuilder message = new StringBuilder();
        private final Throwable error;

        private Builder(String name, Throwable error) {
            this.name = name;
            this.error = error;
        }

        public Builder addHeading(String text) {
            this.message.append("### ").append(text).append(" ###\n");
            return this;
        }

        public Builder addText(String text) {
            this.message.append('\n').append(text).append('\n');
            return this;
        }

        public Builder addCode(String text, String format) {
            this.message.append("```");
            if (format != null) {
                this.message.append(format);
            }
            this.message.append('\n').append(text).append("\n```\n");
            return this;
        }

        public ErrorReport build() {
            Builder builder = new Builder(this.name, this.error);
            builder.addHeading("Description").addText("[Insert description of issue here]");
            builder.addHeading("Detailed Information");
            if (new File("plugins" + File.separator + "PermissionsEx", "report-disable").exists()) {
                builder.addText("I am stupid and chose to disable error reporting, therefore removing any chance of getting help with my error");
            } else {
                builder.addText("[Is available here](" + ErrorReport.gistText(this.message.toString()) + ")");
            }
            return new ErrorReport(this.name, builder.message.toString(), this.error);
        }
    }
}

