/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.tehkode.permissions.backends.SQLBackend;

public class SQLConnection {
    private static final Pattern TABLE_PATTERN = Pattern.compile("\\{([^}]+)\\}");
    private final Map<String, PreparedStatement> cachedStatements = new HashMap<String, PreparedStatement>();
    private Statement statement;
    protected Connection db;
    private final String driver;
    protected final String uri;
    protected final String user;
    protected final String password;
    private final SQLBackend backend;

    public SQLConnection(String uri, String user, String password, SQLBackend backend) {
        this.uri = uri;
        this.user = user;
        this.password = password;
        this.backend = backend;
        this.driver = uri.split(":", 2)[0];
        try {
            Class.forName(SQLConnection.getDriverClass(this.driver)).newInstance();
            this.connect();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public PreparedStatement prep(String query) throws SQLException {
        this.checkConnection();
        PreparedStatement statement = this.cachedStatements.get(query);
        if (statement == null) {
            statement = this.db.prepareStatement(this.expandQuery(query));
            this.cachedStatements.put(query, statement);
        }
        return statement;
    }

    public String expandQuery(String query) {
        StringBuffer ret = new StringBuffer();
        Matcher m = TABLE_PATTERN.matcher(query);
        while (m.find()) {
            m.appendReplacement(ret, this.backend.getTableName(m.group(1)));
        }
        m.appendTail(ret);
        return ret.toString();
    }

    public Statement getStatement() throws SQLException {
        this.checkConnection();
        if (this.statement == null) {
            this.statement = this.db.createStatement();
        }
        return this.statement;
    }

    public boolean hasTable(String table) throws SQLException {
        this.checkConnection();
        return this.db.getMetaData().getTables(null, null, table, null).next();
    }

    public PreparedStatement prepAndBind(String query, Object ... args) throws SQLException {
        PreparedStatement statement = this.prep(query);
        this.bind(statement, args);
        return statement;
    }

    public PreparedStatement bind(PreparedStatement statement, Object ... args) throws SQLException {
        statement.clearParameters();
        int argsExpected = statement.getParameterMetaData().getParameterCount();
        if (args.length != argsExpected) {
            throw new SQLException("Invalid argument number provided; expected " + argsExpected + " but got " + args.length);
        }
        for (int i = 0; i < args.length; ++i) {
            statement.setObject(i + 1, args[i]);
        }
        return statement;
    }

    protected void checkConnection() throws SQLException {
        if (this.db.getClass().getName().startsWith("org.sqlite")) {
            return;
        }
        if (!this.db.isValid(3)) {
            Logger.getLogger("PermissionsEx").warning("Lost connection with sql server. Reconnecting.");
            this.connect();
        }
    }

    protected final void connect() throws SQLException {
        Logger.getLogger("PermissionsEx").info("[PermissionsEx-SQL] Connecting to database \"" + this.uri + "\"");
        this.cachedStatements.clear();
        this.statement = null;
        this.db = DriverManager.getConnection("jdbc:" + this.uri, this.user, this.password);
    }

    protected static String getDriverClass(String alias) {
        if (alias.equals("mysql")) {
            alias = "com.mysql.jdbc.Driver";
        } else if (alias.equals("sqlite")) {
            alias = "org.sqlite.JDBC";
        } else if (alias.matches("postgres?")) {
            alias = "org.postgresql.Driver";
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.db.close();
        }
        catch (SQLException e) {
            Logger.getLogger("PermissionsEx").log(Level.WARNING, "Error while disconnecting from database: {0}", e.getMessage());
        }
        finally {
            super.finalize();
        }
    }
}

