/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.ProxyPermissionUser;
import ru.tehkode.permissions.backends.FileBackend;
import ru.tehkode.permissions.backends.file.FileEntity;
import ru.tehkode.permissions.events.PermissionEntityEvent;

public class FileUser
extends ProxyPermissionUser {
    protected ConfigurationSection node;
    protected FileBackend backend;

    public FileUser(String playerName, PermissionManager manager, FileBackend backend) {
        super(new FileEntity(playerName, manager, backend, "users"));
        this.backend = backend;
        this.node = ((FileEntity)this.backendEntity).getConfigNode();
    }

    @Override
    protected String[] getGroupsNamesImpl(String worldName) {
        Object groups = this.node.get(FileEntity.formatPath(worldName, "group"));
        if (groups instanceof String) {
            String groupsString = (String)groups;
            String[] groupsArray = groupsString.contains(",") ? ((String)groups).split(",") : new String[]{groupsString};
            this.node.set("group", Arrays.asList(groupsArray));
            this.save();
            return groupsArray;
        }
        if (groups instanceof List) {
            return ((List)groups).toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public void setGroups(String[] groups, String worldName) {
        if (groups == null) {
            return;
        }
        this.node.set(FileEntity.formatPath(worldName, "group"), Arrays.asList(groups));
        this.save();
        this.callEvent(PermissionEntityEvent.Action.INHERITANCE_CHANGED);
    }
}

