/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.ProxyPermissionGroup;
import ru.tehkode.permissions.backends.FileBackend;
import ru.tehkode.permissions.backends.file.FileEntity;

public class FileGroup
extends ProxyPermissionGroup {
    protected ConfigurationSection node;

    public FileGroup(String name, PermissionManager manager, FileBackend backend) {
        super(new FileEntity(name, manager, backend, "groups"));
        this.node = ((FileEntity)this.backendEntity).getConfigNode();
    }

    @Override
    public String[] getParentGroupsNamesImpl(String worldName) {
        List parents = this.node.getStringList(FileEntity.formatPath(worldName, "inheritance"));
        if (parents.isEmpty()) {
            return new String[0];
        }
        return parents.toArray(new String[parents.size()]);
    }

    @Override
    public void setParentGroups(String[] parentGroups, String worldName) {
        if (parentGroups == null) {
            return;
        }
        this.node.set(FileEntity.formatPath(worldName, "inheritance"), Arrays.asList(parentGroups));
        this.save();
    }
}

