/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.backends.FileBackend;

public class FileEntity
extends PermissionEntity {
    protected ConfigurationSection node;
    protected FileBackend backend;
    protected String nodePath;

    public FileEntity(String entityName, PermissionManager manager, FileBackend backend, String baseNode) {
        super(entityName, manager);
        this.backend = backend;
        this.node = this.getNode(baseNode, this.getName());
    }

    protected final ConfigurationSection getNode(String baseNode, String entityName) {
        this.nodePath = FileBackend.buildPath(baseNode, entityName);
        ConfigurationSection entityNode = this.backend.permissions.getConfigurationSection(this.nodePath);
        if (entityNode != null) {
            this.virtual = false;
            return entityNode;
        }
        ConfigurationSection users = this.backend.permissions.getConfigurationSection(baseNode);
        if (users != null) {
            for (Map.Entry entry : users.getValues(false).entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(entityName) || !(entry.getValue() instanceof ConfigurationSection)) continue;
                this.setName((String)entry.getKey());
                this.nodePath = FileBackend.buildPath(baseNode, this.getName());
                this.virtual = false;
                return (ConfigurationSection)entry.getValue();
            }
        }
        this.virtual = true;
        ConfigurationSection section = this.backend.permissions.createSection(this.nodePath);
        this.backend.permissions.set(this.nodePath, null);
        return section;
    }

    public ConfigurationSection getConfigNode() {
        return this.node;
    }

    @Override
    public String[] getPermissions(String world) {
        List permissions = this.node.getStringList(FileEntity.formatPath(world, "permissions"));
        if (permissions == null) {
            return new String[0];
        }
        return permissions.toArray(new String[permissions.size()]);
    }

    @Override
    public void setPermissions(String[] permissions, String world) {
        this.node.set(FileEntity.formatPath(world, "permissions"), permissions.length > 0 ? Arrays.asList(permissions) : null);
        this.save();
    }

    @Override
    public String[] getWorlds() {
        ConfigurationSection worldsSection = this.node.getConfigurationSection("worlds");
        if (worldsSection == null) {
            return new String[0];
        }
        return worldsSection.getKeys(false).toArray(new String[0]);
    }

    @Override
    public Map<String, String> getOptions(String world) {
        ConfigurationSection optionsSection = this.node.getConfigurationSection(FileEntity.formatPath(world, "options"));
        if (optionsSection != null) {
            return this.collectOptions(optionsSection);
        }
        return new HashMap<String, String>(0);
    }

    @Override
    public String getOption(String option, String world, String defaultValue) {
        return this.node.getString(FileEntity.formatPath(world, "options", option), defaultValue);
    }

    @Override
    public void setOption(String option, String value, String world) {
        this.node.set(FileEntity.formatPath(world, "options", option), (Object)value);
        this.save();
    }

    @Override
    public String getPrefix(String worldName) {
        return this.node.getString(FileEntity.formatPath(worldName, "prefix"));
    }

    @Override
    public String getSuffix(String worldName) {
        return this.node.getString(FileEntity.formatPath(worldName, "suffix"));
    }

    @Override
    public void setPrefix(String prefix, String worldName) {
        this.node.set(FileEntity.formatPath(worldName, "prefix"), (Object)prefix);
        this.save();
    }

    @Override
    public void setSuffix(String suffix, String worldName) {
        this.node.set(FileEntity.formatPath(worldName, "suffix"), (Object)suffix);
        this.save();
    }

    @Override
    public Map<String, String[]> getAllPermissions() {
        ConfigurationSection worldsSection;
        HashMap<String, String[]> allPermissions = new HashMap<String, String[]>();
        List commonPermissions = this.node.getStringList("permissions");
        if (commonPermissions != null) {
            allPermissions.put(null, commonPermissions.toArray(new String[0]));
        }
        if ((worldsSection = this.node.getConfigurationSection("worlds")) != null) {
            for (String world : worldsSection.getKeys(false)) {
                List worldPermissions = this.node.getStringList(FileBackend.buildPath("worlds", world, "permissions"));
                if (commonPermissions == null) continue;
                allPermissions.put(world, worldPermissions.toArray(new String[0]));
            }
        }
        return allPermissions;
    }

    @Override
    public Map<String, Map<String, String>> getAllOptions() {
        HashMap<String, Map<String, String>> allOptions = new HashMap<String, Map<String, String>>();
        allOptions.put(null, this.getOptions(null));
        for (String worldName : this.getWorlds()) {
            allOptions.put(worldName, this.getOptions(worldName));
        }
        return allOptions;
    }

    private Map<String, String> collectOptions(ConfigurationSection section) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (String key : section.getKeys(true)) {
            if (section.isConfigurationSection(key)) continue;
            options.put(key.replace(section.getRoot().options().pathSeparator(), '.'), section.getString(key));
        }
        return options;
    }

    @Override
    public void save() {
        this.backend.permissions.set(this.nodePath, (Object)this.node);
        this.backend.save();
        this.virtual = false;
    }

    @Override
    public void remove() {
        this.backend.permissions.set(this.nodePath, null);
        this.backend.save();
    }

    protected static String formatPath(String worldName, String node, String value) {
        String path = FileBackend.buildPath(node, value);
        if (worldName != null && !worldName.isEmpty()) {
            path = FileBackend.buildPath("worlds", worldName, path);
        }
        return path;
    }

    protected static String formatPath(String worldName, String node) {
        String path = node;
        if (worldName != null && !worldName.isEmpty()) {
            path = FileBackend.buildPath("worlds", worldName, path);
        }
        return path;
    }
}

