/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.FileBackend;
import ru.tehkode.permissions.backends.file.FileConfig;
import ru.tehkode.permissions.backends.file.FileEntity;

public class FileData
implements PermissionsUserData,
PermissionsGroupData {
    protected transient FileConfig config;
    protected String nodePath;
    protected ConfigurationSection node;
    protected boolean virtual = true;

    public FileData(String basePath, String name, FileConfig config) {
        this.config = config;
        this.node = this.findNode(name, basePath);
    }

    private ConfigurationSection findNode(String entityName, String basePath) {
        this.nodePath = FileBackend.buildPath(basePath, entityName);
        ConfigurationSection entityNode = this.config.getConfigurationSection(this.nodePath);
        if (entityNode != null) {
            this.virtual = false;
            return entityNode;
        }
        ConfigurationSection users = this.config.getConfigurationSection(basePath);
        if (users != null) {
            for (Map.Entry entry : users.getValues(false).entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(entityName) || !(entry.getValue() instanceof ConfigurationSection)) continue;
                this.nodePath = FileBackend.buildPath(basePath, entityName);
                return (ConfigurationSection)entry.getValue();
            }
        }
        ConfigurationSection section = this.config.createSection(this.nodePath);
        this.config.set(this.nodePath, null);
        return section;
    }

    @Override
    public List<String> getPermissions(String worldName) {
        List result = this.node.getStringList(FileData.formatPath(worldName, "permissions"));
        return result == null ? new LinkedList() : result;
    }

    @Override
    public void setPermissions(List<String> permissions, String worldName) {
        this.node.set(FileData.formatPath(worldName, "permissions"), permissions.isEmpty() ? null : permissions);
    }

    @Override
    public Map<String, List<String>> getPermissionsMap() {
        ConfigurationSection worldsSection;
        HashMap<String, List<String>> allPermissions = new HashMap<String, List<String>>();
        List commonPermissions = this.node.getStringList("permissions");
        if (commonPermissions != null) {
            allPermissions.put(null, commonPermissions);
        }
        if ((worldsSection = this.node.getConfigurationSection("worlds")) != null) {
            for (String world : worldsSection.getKeys(false)) {
                List worldPermissions = this.node.getStringList(FileBackend.buildPath("worlds", world, "permissions"));
                if (commonPermissions == null) continue;
                allPermissions.put(world, worldPermissions);
            }
        }
        return allPermissions;
    }

    @Override
    public Set<String> getWorlds() {
        ConfigurationSection worldsSection = this.node.getConfigurationSection("worlds");
        if (worldsSection == null) {
            return new HashSet<String>();
        }
        return worldsSection.getKeys(false);
    }

    @Override
    public String getPrefix(String worldName) {
        return this.node.getString(FileData.formatPath(worldName, "prefix"));
    }

    @Override
    public void setPrefix(String prefix, String worldName) {
        this.node.set(FileData.formatPath(worldName, "prefix"), (Object)prefix);
    }

    @Override
    public String getSuffix(String worldName) {
        return this.node.getString(FileData.formatPath(worldName, "suffix"));
    }

    @Override
    public void setSuffix(String suffix, String worldName) {
        this.node.set(FileData.formatPath(worldName, "suffix"), (Object)suffix);
    }

    @Override
    public String getOption(String option, String worldName) {
        return this.node.getString(FileData.formatPath(worldName, "options", option));
    }

    @Override
    public void setOption(String option, String worldName, String value) {
        this.node.set(FileData.formatPath(worldName, "options", option), (Object)value);
    }

    @Override
    public Map<String, String> getOptions(String worldName) {
        ConfigurationSection optionsSection = this.node.getConfigurationSection(FileData.formatPath(worldName, "options"));
        if (optionsSection == null) {
            return new HashMap<String, String>(0);
        }
        return this.collectOptions(optionsSection);
    }

    @Override
    public Map<String, Map<String, String>> getOptionsMap() {
        HashMap<String, Map<String, String>> allOptions = new HashMap<String, Map<String, String>>();
        allOptions.put(null, this.getOptions(null));
        for (String worldName : this.getWorlds()) {
            allOptions.put(worldName, this.getOptions(worldName));
        }
        return allOptions;
    }

    @Override
    public boolean isVirtual() {
        return this.config.isConfigurationSection(this.nodePath);
    }

    @Override
    public void save() {
        this.config.save();
    }

    @Override
    public void remove() {
        this.config.set(this.nodePath, null);
        this.save();
    }

    @Override
    public List<String> getGroups(String worldName) {
        Object groups = this.node.get(FileEntity.formatPath(worldName, "group"));
        if (groups instanceof String) {
            String groupsString = (String)groups;
            String[] groupsArray = groupsString.contains(",") ? ((String)groups).split(",") : new String[]{groupsString};
            return Arrays.asList(groupsArray);
        }
        if (groups instanceof List) {
            return (List)groups;
        }
        return new ArrayList<String>(0);
    }

    @Override
    public void setGroups(List<PermissionGroup> groups, String worldName) {
        this.node.set(FileEntity.formatPath(worldName, "group"), groups);
    }

    @Override
    public List<String> getParents(String worldName) {
        List parents = this.node.getStringList(FileEntity.formatPath(worldName, "inheritance"));
        if (parents.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return parents;
    }

    @Override
    public void setParents(String worldName, List<String> parents) {
        this.node.set(FileEntity.formatPath(worldName, "inheritance"), parents);
    }

    private Map<String, String> collectOptions(ConfigurationSection section) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (String key : section.getKeys(true)) {
            if (section.isConfigurationSection(key)) continue;
            options.put(key.replace(section.getRoot().options().pathSeparator(), '.'), section.getString(key));
        }
        return options;
    }

    protected static String formatPath(String worldName, String node, String value) {
        String path = FileBackend.buildPath(node, value);
        if (worldName != null && !worldName.isEmpty()) {
            path = FileBackend.buildPath("worlds", worldName, path);
        }
        return path;
    }

    protected static String formatPath(String worldName, String node) {
        String path = node;
        if (worldName != null && !worldName.isEmpty()) {
            path = FileBackend.buildPath("worlds", worldName, path);
        }
        return path;
    }
}

