/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionBackend;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.backends.sql.SQLConnection;
import ru.tehkode.permissions.backends.sql.SQLEntity;
import ru.tehkode.permissions.backends.sql.SQLGroup;
import ru.tehkode.permissions.backends.sql.SQLUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.exceptions.PermissionBackendException;
import ru.tehkode.utils.StringUtils;

public class SQLBackend
extends PermissionBackend {
    protected Map<String, String[]> worldInheritanceCache = new HashMap<String, String[]>();
    private Map<String, Object> tableNames;
    private ThreadLocal<SQLConnection> conn;

    public SQLBackend(PermissionManager manager, Configuration config) {
        super(manager, config);
    }

    @Override
    public void initialize() throws PermissionBackendException {
        final String dbUri = this.config.getString("permissions.backends.sql.uri", "");
        final String dbUser = this.config.getString("permissions.backends.sql.user", "");
        final String dbPassword = this.config.getString("permissions.backends.sql.password", "");
        if (dbUri == null || dbUri.isEmpty()) {
            this.config.set("permissions.backends.sql.uri", (Object)"mysql://localhost/exampledb");
            this.config.set("permissions.backends.sql.user", (Object)"databaseuser");
            this.config.set("permissions.backends.sql.password", (Object)"databasepassword");
            throw new PermissionBackendException("SQL connection is not configured, see config.yml");
        }
        this.conn = new ThreadLocal<SQLConnection>(){

            @Override
            public SQLConnection initialValue() {
                return new SQLConnection(dbUri, dbUser, dbPassword, SQLBackend.this);
            }
        };
        try {
            this.getSQL();
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            throw new PermissionBackendException(e);
        }
        Logger.getLogger("PermissionsEx").info("[PermissionsEx-SQL] Successfully connected to database");
        this.setupAliases(this.config);
        this.deployTables();
    }

    public SQLConnection getSQL() {
        return this.conn.get();
    }

    public String getTableName(String identifier) {
        Map<String, Object> tableNames = this.tableNames;
        if (tableNames == null) {
            return identifier;
        }
        Object ret = tableNames.get(identifier);
        if (ret == null) {
            return identifier;
        }
        return ret.toString();
    }

    @Override
    public PermissionUser getUser(String name) {
        return new SQLUser(name, this.manager, this);
    }

    @Override
    public PermissionGroup getGroup(String name) {
        return new SQLGroup(name, this.manager, this);
    }

    @Override
    public PermissionGroup getDefaultGroup(String worldName) {
        try {
            ResultSet result;
            if (worldName == null) {
                result = this.getSQL().prepAndBind("SELECT `name` FROM `{permissions_entity}` WHERE `type` = ? AND `default` = 1 LIMIT 1", SQLEntity.Type.GROUP.ordinal()).executeQuery();
                if (!result.next()) {
                    throw new RuntimeException("There is no default group set, this is a serious issue");
                }
            } else {
                result = this.getSQL().prepAndBind("SELECT `name` FROM `{permissions}` WHERE `permission` = 'default' AND `value` = 'true' AND `type` = ? AND `world` = ?", SQLEntity.Type.GROUP.ordinal(), worldName).executeQuery();
                if (!result.next()) {
                    return null;
                }
            }
            return this.manager.getGroup(result.getString("name"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDefaultGroup(PermissionGroup group, String worldName) {
        try {
            if (worldName == null) {
                this.getSQL().prepAndBind("UPDATE `{permissions_entity}` SET `default` = 0 WHERE `type` = ? AND `default` = 1 LIMIT 1", SQLEntity.Type.GROUP.ordinal()).execute();
                this.getSQL().prepAndBind("UPDATE `{permissions_entity}` SET `default` = 1 WHERE `type` = ? AND `name` = ? LIMIT 1", SQLEntity.Type.GROUP.ordinal(), group.getName()).execute();
            } else {
                this.getSQL().prepAndBind("DELETE FROM `{permissions}` WHERE `permission` = 'default' AND `world` = ? AND `type` = ?", worldName, SQLEntity.Type.GROUP.ordinal()).execute();
                this.getSQL().prepAndBind("INSERT INTO `{permissions}` (`name`, `permission`, `type`, `world`, `value`) VALUES (?, 'default', ?, ?, 'true')", group.getName(), SQLEntity.Type.GROUP.ordinal(), worldName).execute();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set default group", e);
        }
    }

    @Override
    public PermissionGroup[] getGroups() {
        Set<String> groupNames = SQLEntity.getEntitiesNames(this.getSQL(), SQLEntity.Type.GROUP, false);
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        for (String groupName : groupNames) {
            groups.add(this.manager.getGroup(groupName));
        }
        Collections.sort(groups);
        return groups.toArray(new PermissionGroup[0]);
    }

    @Override
    public PermissionUser[] getRegisteredUsers() {
        Set<String> userNames = SQLEntity.getEntitiesNames(this.getSQL(), SQLEntity.Type.USER, false);
        PermissionUser[] users = new PermissionUser[userNames.size()];
        int index = 0;
        for (String groupName : userNames) {
            users[index++] = this.manager.getUser(groupName);
        }
        return users;
    }

    @Override
    public Collection<String> getRegisteredGroupNames() {
        return SQLEntity.getEntitiesNames(this.getSQL(), SQLEntity.Type.GROUP, false);
    }

    @Override
    public Collection<String> getRegisteredUserNames() {
        return SQLEntity.getEntitiesNames(this.getSQL(), SQLEntity.Type.USER, false);
    }

    protected final void setupAliases(Configuration config) {
        ConfigurationSection aliases = config.getConfigurationSection("permissions.backends.sql.aliases");
        if (aliases == null) {
            return;
        }
        this.tableNames = aliases.getValues(false);
    }

    private void executeStream(SQLConnection conn, InputStream str) throws SQLException, IOException {
        String deploySQL = StringUtils.readStream(str);
        Statement s = conn.getStatement();
        for (String sqlQuery : deploySQL.trim().split(";")) {
            if ((sqlQuery = sqlQuery.trim()).isEmpty()) continue;
            sqlQuery = conn.expandQuery(sqlQuery + ";");
            s.addBatch(sqlQuery);
        }
        s.executeBatch();
    }

    protected final void deployTables() throws PermissionBackendException {
        try {
            if (this.getSQL().hasTable("permissions")) {
                return;
            }
            InputStream databaseDumpStream = this.getClass().getResourceAsStream("/sql/" + this.getSQL().getDriver() + ".sql");
            if (databaseDumpStream == null) {
                throw new Exception("Can't find appropriate database dump for used database (" + this.getSQL().getDriver() + "). Is it bundled?");
            }
            Logger.getLogger("PermissionsEx").info("Deploying default database scheme");
            this.executeStream(this.getSQL(), databaseDumpStream);
            PermissionGroup defGroup = this.getGroup("default");
            String deployFile = this.config.getString("permissions.backends.sql.deploy", "");
            if (deployFile.length() > 0) {
                File deploy = new File(PermissionsEx.getPlugin().getDataFolder(), deployFile);
                if (!deploy.exists()) {
                    throw new Exception("Permissions deploy file for SQL does not exist!");
                }
                this.executeStream(this.getSQL(), new FileInputStream(deploy));
                this.config.set("permissions.backends.sql.deploy", null);
            } else {
                defGroup.addPermission("modifyworld.*");
                this.setDefaultGroup(defGroup, null);
            }
            Logger.getLogger("PermissionsEx").info("Database scheme deploying complete.");
        }
        catch (Exception e) {
            throw new PermissionBackendException("Deploying of default data failed. Please initialize database manually using " + this.getSQL().getDriver() + ".sql", e);
        }
    }

    private static String blankIfNull(String in) {
        return in == null ? "" : in;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void dumpData(OutputStreamWriter writer) throws IOException {
        String world;
        for (PermissionUser user : this.manager.getUsers()) {
            writer.append("/* User ").append(user.getName()).append(" */\n");
            writer.append("INSERT INTO `{permissions_entity}` ( `name`, `type`, `prefix`, `suffix` ) VALUES ( '").append(user.getName()).append("', 1, '").append(SQLBackend.blankIfNull(user.getOwnPrefix())).append("','").append(SQLBackend.blankIfNull(user.getOwnSuffix())).append("' );\n");
            for (String group : user.getGroupsNames()) {
                writer.append("INSERT INTO `{permissions_inheritance}` ( `child`, `parent`, `type` ) VALUES ( '").append(user.getName()).append("', '").append(group).append("',  1);\n");
            }
            for (Map.Entry<String, String[]> entry : user.getAllPermissions().entrySet()) {
                for (String permission : entry.getValue()) {
                    world = entry.getKey();
                    if (world == null) {
                        world = "";
                    }
                    writer.append("INSERT INTO `{permissions}` ( `name`, `type`, `permission`, `world`, `value` ) VALUES ('").append(user.getName()).append("', 1, '").append(permission).append("', '").append(world).append("', ''); \n");
                }
            }
            for (String world2 : user.getWorlds()) {
                if (world2 == null) continue;
                String worldPrefix = user.getOwnPrefix(world2);
                String worldSuffix = user.getOwnSuffix(world2);
                if (worldPrefix != null && !worldPrefix.isEmpty()) {
                    writer.append("INSERT INTO `{permissions}` (`name`, `type`, `permission`, `world`, `value`) VALUES ('").append(user.getName()).append("', 1, 'prefix', '").append(world2).append("', '").append(worldPrefix).append("');\n");
                }
                if (worldSuffix == null || worldSuffix.isEmpty()) continue;
                writer.append("INSERT INTO `{permissions}` (`name`, `type`, `permission`, `world`, `value`) VALUES ('").append(user.getName()).append("', 1, 'suffix', '").append(world2).append("', '").append(worldSuffix).append("');\n");
            }
            for (Map.Entry<String, Object> entry : user.getAllOptions().entrySet()) {
                for (Map.Entry option : ((Map)entry.getValue()).entrySet()) {
                    String value = ((String)option.getValue()).replace("'", "\\'");
                    String world3 = entry.getKey();
                    if (world3 == null) {
                        world3 = "";
                    }
                    writer.append("INSERT INTO `{permissions}` ( `name`, `type`, `permission`, `world`, `value` ) VALUES ('").append(user.getName()).append("', 1, '").append((CharSequence)option.getKey()).append("', '").append(world3).append("', '").append(value).append("' );\n");
                }
            }
        }
        PermissionGroup defaultGroup = this.manager.getDefaultGroup();
        for (PermissionGroup group : this.manager.getGroups()) {
            writer.append("/* Group ").append(group.getName()).append(" */\n");
            writer.append("INSERT INTO `{permissions_entity}` ( `name`, `type`, `prefix`, `suffix`, `default` ) VALUES ( '").append(group.getName()).append("', 0, '").append(SQLBackend.blankIfNull(group.getOwnPrefix())).append("','").append(SQLBackend.blankIfNull(group.getOwnSuffix())).append("', ").append(group.equals(defaultGroup) ? "1" : "0").append(" );\n");
            for (String world4 : group.getWorlds()) {
                if (world4 == null) continue;
                String worldPrefix = group.getOwnPrefix(world4);
                String worldSuffix = group.getOwnSuffix(world4);
                if (worldPrefix != null && !worldPrefix.isEmpty()) {
                    writer.append("INSERT INTO `{permissions}` (`name`, `type`, `permission`, `world`, `value`) VALUES ('").append(group.getName()).append("', 0, 'prefix', '").append(world4).append("', '").append(worldPrefix).append("');\n");
                }
                if (worldSuffix == null || worldSuffix.isEmpty()) continue;
                writer.append("INSERT INTO `{permissions}` (`name`, `type`, `permission`, `world`, `value`) VALUES ('").append(group.getName()).append("', 0, 'suffix', '").append(world4).append("', '").append(worldSuffix).append("');\n");
            }
            for (String parent : group.getParentGroupsNames()) {
                writer.append("INSERT INTO `{permissions_inheritance}` ( `child`, `parent`, `type` ) VALUES ( '").append(group.getName()).append("', '").append(parent).append("',  0);\n");
            }
            for (Map.Entry<String, String[]> entry : group.getAllPermissions().entrySet()) {
                for (String permission : entry.getValue()) {
                    String world5 = entry.getKey();
                    if (world5 == null) {
                        world5 = "";
                    }
                    writer.append("INSERT INTO `{permissions}` ( `name`, `type`, `permission`, `world`, `value`) VALUES ('").append(group.getName()).append("', 0, '").append(permission).append("', '").append(world5).append("', '');\n");
                }
            }
            for (Map.Entry<String, Object> entry : group.getAllOptions().entrySet()) {
                for (Map.Entry option : ((Map)entry.getValue()).entrySet()) {
                    String value = ((String)option.getValue()).replace("'", "\\'");
                    world = entry.getKey();
                    if (world == null) {
                        world = "";
                    }
                    writer.append("INSERT INTO `{permissions}` ( `name`, `type`, `permission`, `world`, `value` ) VALUES ('").append(group.getName()).append("', 0, '").append((CharSequence)option.getKey()).append("', '").append(world).append("', '").append(value).append("' );\n");
                }
            }
        }
        writer.append("/* World Inheritance */\n");
        for (World world6 : Bukkit.getServer().getWorlds()) {
            String[] parentWorlds = this.manager.getWorldInheritance(world6.getName());
            if (parentWorlds.length == 0) continue;
            for (String parentWorld : parentWorlds) {
                writer.append("INSERT INTO `{permissions_inheritance}` ( `child`, `parent`, `type` ) VALUES ( '").append(world6.getName()).append("', '").append(parentWorld).append("',  2);\n");
            }
        }
        writer.flush();
    }

    @Override
    public String[] getWorldInheritance(String world) {
        if (world == null || world.isEmpty()) {
            return new String[0];
        }
        if (!this.worldInheritanceCache.containsKey(world)) {
            try {
                ResultSet result = this.getSQL().prepAndBind("SELECT `parent` FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = 2;", world).executeQuery();
                LinkedList<String> worldParents = new LinkedList<String>();
                while (result.next()) {
                    worldParents.add(result.getString("parent"));
                }
                this.worldInheritanceCache.put(world, worldParents.toArray(new String[0]));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.worldInheritanceCache.get(world);
    }

    @Override
    public void setWorldInheritance(String worldName, String[] parentWorlds) {
        if (worldName == null || worldName.isEmpty()) {
            return;
        }
        try {
            this.getSQL().prepAndBind("DELETE FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = 2", worldName).execute();
            PreparedStatement statement = this.getSQL().prepAndBind("INSERT INTO `{permissions_inheritance}` (`child`, `parent`, `type`) VALUES (?, ?, 2)", worldName, "toset");
            for (String parentWorld : parentWorlds) {
                statement.setString(2, parentWorld);
                statement.addBatch();
            }
            statement.executeBatch();
            this.worldInheritanceCache.put(worldName, parentWorlds);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reload() {
        this.worldInheritanceCache.clear();
    }
}

