/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.tehkode.permissions.PermissionBackend;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.backends.file.FileGroup;
import ru.tehkode.permissions.backends.file.FileUser;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public class FileBackend
extends PermissionBackend {
    public static final char PATH_SEPARATOR = '/';
    public FileConfiguration permissions;
    public File permissionsFile;

    public FileBackend(PermissionManager manager, Configuration config) {
        super(manager, config);
    }

    @Override
    public void initialize() throws PermissionBackendException {
        File baseDirectory;
        String baseDir;
        String permissionFilename = this.config.getString("permissions.backends.file.file");
        if (permissionFilename == null) {
            permissionFilename = "permissions.yml";
            this.config.set("permissions.backends.file.file", (Object)"permissions.yml");
        }
        if ((baseDir = this.config.getString("permissions.basedir", "plugins/PermissionsEx")).contains("\\") && !"\\".equals(File.separator)) {
            baseDir = baseDir.replace("\\", File.separator);
        }
        if (!(baseDirectory = new File(baseDir)).exists()) {
            baseDirectory.mkdirs();
        }
        this.permissionsFile = new File(baseDir, permissionFilename);
        this.reload();
    }

    @Override
    public String[] getWorldInheritance(String world) {
        List parentWorlds;
        if (world != null && !world.isEmpty() && (parentWorlds = this.permissions.getStringList(FileBackend.buildPath("worlds", world, "/inheritance"))) != null) {
            return parentWorlds.toArray(new String[parentWorlds.size()]);
        }
        return new String[0];
    }

    @Override
    public void setWorldInheritance(String world, String[] parentWorlds) {
        if (world == null || world.isEmpty()) {
            return;
        }
        this.permissions.set(FileBackend.buildPath("worlds", world, "inheritance"), Arrays.asList(parentWorlds));
        this.save();
    }

    @Override
    public PermissionUser getUser(String userName) {
        return new FileUser(userName, this.manager, this);
    }

    @Override
    public PermissionGroup getGroup(String groupName) {
        return new FileGroup(groupName, this.manager, this);
    }

    @Override
    public PermissionGroup getDefaultGroup(String worldName) {
        ConfigurationSection groups = this.permissions.getConfigurationSection("groups");
        if (groups == null) {
            throw new RuntimeException("No groups defined. Check your permissions file.");
        }
        String defaultGroupProperty = "default";
        if (worldName != null) {
            defaultGroupProperty = FileBackend.buildPath("worlds", worldName, defaultGroupProperty);
        }
        for (Map.Entry entry : groups.getValues(false).entrySet()) {
            ConfigurationSection groupSection;
            if (!(entry.getValue() instanceof ConfigurationSection) || !(groupSection = (ConfigurationSection)entry.getValue()).getBoolean(defaultGroupProperty, false)) continue;
            return this.manager.getGroup((String)entry.getKey());
        }
        if (worldName == null) {
            throw new RuntimeException("Default user group is not defined. Please select one using the \"default: true\" property");
        }
        return null;
    }

    @Override
    public void setDefaultGroup(PermissionGroup group, String worldName) {
        ConfigurationSection groups = this.permissions.getConfigurationSection("groups");
        String defaultGroupProperty = "default";
        if (worldName != null) {
            defaultGroupProperty = FileBackend.buildPath("worlds", worldName, defaultGroupProperty);
        }
        for (Map.Entry entry : groups.getValues(false).entrySet()) {
            if (!(entry.getValue() instanceof ConfigurationSection)) continue;
            ConfigurationSection groupSection = (ConfigurationSection)entry.getValue();
            groupSection.set(defaultGroupProperty, (Object)false);
            if (!groupSection.getName().equals(group.getName())) {
                groupSection.set(defaultGroupProperty, null);
                continue;
            }
            groupSection.set(defaultGroupProperty, (Object)true);
        }
        this.save();
    }

    @Override
    public PermissionGroup[] getGroups() {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        ConfigurationSection groupsSection = this.permissions.getConfigurationSection("groups");
        if (groupsSection == null) {
            return new PermissionGroup[0];
        }
        for (String groupName : groupsSection.getKeys(false)) {
            groups.add(this.manager.getGroup(groupName));
        }
        Collections.sort(groups);
        return groups.toArray(new PermissionGroup[0]);
    }

    @Override
    public PermissionUser[] getRegisteredUsers() {
        LinkedList<PermissionUser> users = new LinkedList<PermissionUser>();
        ConfigurationSection usersSection = this.permissions.getConfigurationSection("users");
        if (usersSection != null) {
            for (String userName : usersSection.getKeys(false)) {
                users.add(this.manager.getUser(userName));
            }
        }
        return users.toArray(new PermissionUser[users.size()]);
    }

    @Override
    public Collection<String> getRegisteredUserNames() {
        ConfigurationSection users = this.permissions.getConfigurationSection("users");
        return users != null ? users.getKeys(false) : Collections.emptySet();
    }

    @Override
    public Collection<String> getRegisteredGroupNames() {
        ConfigurationSection groups = this.permissions.getConfigurationSection("groups");
        return groups != null ? groups.getKeys(false) : Collections.emptySet();
    }

    public static String buildPath(String ... path) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        char separator = '/';
        for (String node : path) {
            if (node.isEmpty()) continue;
            if (!first) {
                builder.append(separator);
            }
            builder.append(node);
            first = false;
        }
        return builder.toString();
    }

    @Override
    public void reload() throws PermissionBackendException {
        YamlConfiguration newPermissions = new YamlConfiguration();
        newPermissions.options().pathSeparator('/');
        try {
            newPermissions.load(this.permissionsFile);
            Logger.getLogger("PermissionsEx").info("Permissions file successfully reloaded");
            this.permissions = newPermissions;
        }
        catch (FileNotFoundException e) {
            if (this.permissions == null) {
                this.permissions = newPermissions;
                this.initNewConfiguration();
            }
        }
        catch (Throwable e) {
            throw new PermissionBackendException("Error loading permissions file!", e);
        }
    }

    private void initNewConfiguration() throws PermissionBackendException {
        if (!this.permissionsFile.exists()) {
            try {
                this.permissionsFile.createNewFile();
                this.permissions.set("groups/default/default", (Object)true);
                LinkedList<String> defaultPermissions = new LinkedList<String>();
                defaultPermissions.add("modifyworld.*");
                this.permissions.set("groups/default/permissions", defaultPermissions);
                this.save();
            }
            catch (IOException e) {
                throw new PermissionBackendException(e);
            }
        }
    }

    public void save() {
        try {
            this.permissions.save(this.permissionsFile);
        }
        catch (IOException e) {
            Logger.getLogger("Minecraft").severe("[PermissionsEx] Error during saving permissions file: " + e.getMessage());
        }
    }

    private void dumpGroupInfo(PermissionGroup group, String worldName, ConfigurationSection groupSection) {
        String suffix;
        String worldPath = worldName == null ? "" : FileBackend.buildPath("worlds", worldName);
        String prefix = group.getOwnPrefix(worldName);
        if (prefix != null && !prefix.isEmpty()) {
            groupSection.set(FileBackend.buildPath(worldPath, "prefix"), (Object)prefix);
        }
        if ((suffix = group.getOwnSuffix(worldName)) != null && !suffix.isEmpty()) {
            groupSection.set(FileBackend.buildPath(worldPath, "suffix"), (Object)suffix);
        }
        if (group.isDefault(worldName)) {
            groupSection.set(FileBackend.buildPath(worldPath, "default"), (Object)true);
        }
    }

    private void dumpUserInfo(PermissionUser user, String worldName, ConfigurationSection userSection) {
        String pathPrefix;
        String[] groups = user.getGroupsNames(worldName);
        String prefix = user.getOwnPrefix(worldName);
        String suffix = user.getOwnSuffix(worldName);
        String string = pathPrefix = worldName == null ? "" : FileBackend.buildPath("worlds", worldName);
        if (groups.length > 0) {
            userSection.set(FileBackend.buildPath(pathPrefix, "group"), Arrays.asList(groups));
        }
        if (prefix != null && !prefix.isEmpty()) {
            userSection.set(FileBackend.buildPath(pathPrefix, "prefix"), (Object)user.getOwnPrefix(worldName));
        }
        if (suffix != null && !suffix.isEmpty()) {
            userSection.set(FileBackend.buildPath(pathPrefix, "suffix"), (Object)suffix);
        }
    }

    @Override
    public void dumpData(OutputStreamWriter writer) throws IOException {
        YamlConfiguration config = new YamlConfiguration();
        config.options().pathSeparator('/').indent(4);
        for (PermissionGroup permissionGroup : this.manager.getGroups()) {
            ConfigurationSection groupSection = config.createSection(FileBackend.buildPath("groups", permissionGroup.getName()));
            if (permissionGroup.getParentGroupsNames().length > 0) {
                groupSection.set("inheritance", Arrays.asList(permissionGroup.getParentGroupsNames()));
            }
            this.dumpEntityData(permissionGroup, groupSection);
            for (Map.Entry<String, PermissionGroup[]> entry : permissionGroup.getAllParentGroups().entrySet()) {
                if (entry.getKey() == null) continue;
                ArrayList<String> groups = new ArrayList<String>();
                for (PermissionGroup parentGroup : entry.getValue()) {
                    if (parentGroup == null) continue;
                    groups.add(parentGroup.getName());
                }
                if (groups.isEmpty()) continue;
                groupSection.set(FileBackend.buildPath("worlds", entry.getKey(), "inheritance"), groups);
            }
            for (String worldName : permissionGroup.getWorlds()) {
                if (worldName == null) continue;
                this.dumpGroupInfo(permissionGroup, worldName, groupSection);
            }
            this.dumpGroupInfo(permissionGroup, null, groupSection);
        }
        for (World world : Bukkit.getServer().getWorlds()) {
            String[] parentWorlds = this.manager.getWorldInheritance(world.getName());
            if (parentWorlds.length == 0) continue;
            config.set(FileBackend.buildPath("worlds", world.getName(), "inheritance"), Arrays.asList(parentWorlds));
        }
        for (PermissionEntity permissionEntity : this.manager.getUsers()) {
            ConfigurationSection userSection = config.createSection(FileBackend.buildPath("users", permissionEntity.getName()));
            this.dumpUserInfo((PermissionUser)permissionEntity, null, userSection);
            this.dumpEntityData(permissionEntity, userSection);
            for (String world : permissionEntity.getWorlds()) {
                if (world == null) continue;
                this.dumpUserInfo((PermissionUser)permissionEntity, null, userSection);
            }
        }
        writer.write(config.saveToString());
        writer.flush();
    }

    private void dumpEntityData(PermissionEntity entity, ConfigurationSection section) {
        String nodePath;
        for (Map.Entry<String, String[]> entry : entity.getAllPermissions().entrySet()) {
            if (entry.getValue().length == 0) continue;
            nodePath = "permissions";
            if (entry.getKey() != null && !entry.getKey().isEmpty()) {
                nodePath = FileBackend.buildPath("worlds", entry.getKey(), nodePath);
            }
            section.set(nodePath, Arrays.asList((Object[])entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : entity.getAllOptions().entrySet()) {
            if (((Map)entry.getValue()).isEmpty()) continue;
            nodePath = "options";
            if (entry.getKey() != null && !entry.getKey().isEmpty()) {
                nodePath = FileBackend.buildPath("worlds", entry.getKey(), nodePath);
            }
            section.set(nodePath, entry.getValue());
        }
    }
}

