/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ru.tehkode.permissions.PermissionMatcher;

public class RegExpMatcher
implements PermissionMatcher {
    public static final String RAW_REGEX_CHAR = "$";
    protected static Pattern rangeExpression = Pattern.compile("(\\d+)-(\\d+)");
    protected static HashMap<String, Pattern> patternCache = new HashMap();

    @Override
    public boolean isMatches(String expression, String permission) {
        Pattern permissionMatcher = patternCache.get(expression);
        if (permissionMatcher == null) {
            permissionMatcher = this.createPattern(expression);
            patternCache.put(expression, permissionMatcher);
        }
        return permissionMatcher.matcher(permission).matches();
    }

    protected Pattern createPattern(String expression) {
        try {
            return Pattern.compile(RegExpMatcher.prepareRegexp(expression), 2);
        }
        catch (PatternSyntaxException e) {
            return Pattern.compile(Pattern.quote(expression), 2);
        }
    }

    public static String prepareRegexp(String expression) {
        boolean rawRegexp;
        if (expression.startsWith("-")) {
            expression = expression.substring(1);
        }
        if (expression.startsWith("#")) {
            expression = expression.substring(1);
        }
        if (rawRegexp = expression.startsWith(RAW_REGEX_CHAR)) {
            expression = expression.substring(1);
        }
        String regexp = rawRegexp ? expression : expression.replace(".", "\\.").replace("*", "(.*)");
        try {
            Matcher rangeMatcher = rangeExpression.matcher(regexp);
            while (rangeMatcher.find()) {
                int to;
                StringBuilder range = new StringBuilder();
                int from = Integer.parseInt(rangeMatcher.group(1));
                if (from > (to = Integer.parseInt(rangeMatcher.group(2)))) {
                    int temp = from;
                    from = to;
                    to = temp;
                }
                range.append("(");
                for (int i = from; i <= to; ++i) {
                    range.append(i);
                    if (i >= to) continue;
                    range.append("|");
                }
                range.append(")");
                regexp = regexp.replace(rangeMatcher.group(0), range.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return regexp;
    }
}

