/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.exceptions.RankingException;

public abstract class PermissionUser
extends PermissionEntity {
    private static final String PERMISSION_NOT_FOUND = "<not found>";
    protected Map<String, List<PermissionGroup>> cachedGroups = new HashMap<String, List<PermissionGroup>>();
    protected Map<String, String[]> cachedPermissions = new HashMap<String, String[]>();
    protected Map<String, String> cachedPrefix = new HashMap<String, String>();
    protected Map<String, String> cachedSuffix = new HashMap<String, String>();
    protected Map<String, String> cachedAnwsers = new ConcurrentHashMap<String, String>();
    protected Map<String, String> cachedOptions = new HashMap<String, String>();

    public PermissionUser(String playerName, PermissionManager manager) {
        super(playerName, manager);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.manager.getBackend().isCreateUserRecords() && this.isVirtual()) {
            this.setGroups(this.getGroups(null), null);
            this.save();
        }
        if (this.isDebug()) {
            Logger.getLogger("Minecraft").info("[PermissionsEx] User " + this.getName() + " initialized");
        }
    }

    public String getOwnPrefix() {
        return this.getOwnPrefix(null);
    }

    public abstract String getOwnPrefix(String var1);

    public final String getOwnSuffix() {
        return this.getOwnSuffix(null);
    }

    public abstract String getOwnSuffix(String var1);

    public abstract String[] getOwnPermissions(String var1);

    @Override
    public String getOption(String optionName, String worldName, String defaultValue) {
        String cacheIndex = worldName + "|" + optionName;
        if (this.cachedOptions.containsKey(cacheIndex)) {
            return this.cachedOptions.get(cacheIndex);
        }
        String value = this.getOwnOption(optionName, worldName, null);
        if (value != null) {
            this.cachedOptions.put(cacheIndex, value);
            return value;
        }
        if (worldName != null) {
            for (String world : this.manager.getWorldInheritance(worldName)) {
                value = this.getOption(optionName, world, null);
                if (value == null) continue;
                this.cachedOptions.put(cacheIndex, value);
                return value;
            }
            value = this.getOption(optionName, null, null);
            if (value != null) {
                this.cachedOptions.put(cacheIndex, value);
                return value;
            }
        }
        for (PermissionGroup group : this.getGroups(worldName)) {
            value = group.getOption(optionName, worldName, null);
            if (value == null) continue;
            this.cachedOptions.put(cacheIndex, value);
            return value;
        }
        return defaultValue;
    }

    public abstract String getOwnOption(String var1, String var2, String var3);

    public String getOwnOption(String option) {
        return this.getOwnOption(option, null, null);
    }

    public String getOwnOption(String option, String world) {
        return this.getOwnOption(option, world, null);
    }

    public int getOwnOptionInteger(String optionName, String world, int defaultValue) {
        String option = this.getOwnOption(optionName, world, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(option);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getOwnOptionBoolean(String optionName, String world, boolean defaultValue) {
        String option = this.getOwnOption(optionName, world, Boolean.toString(defaultValue));
        if ("false".equalsIgnoreCase(option)) {
            return false;
        }
        if ("true".equalsIgnoreCase(option)) {
            return true;
        }
        return defaultValue;
    }

    public double getOwnOptionDouble(String optionName, String world, double defaultValue) {
        String option = this.getOwnOption(optionName, world, Double.toString(defaultValue));
        try {
            return Double.parseDouble(option);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected abstract String[] getGroupsNamesImpl(String var1);

    public PermissionGroup[] getGroups() {
        return this.getGroups(null);
    }

    public PermissionGroup[] getGroups(String worldName) {
        if (!this.cachedGroups.containsKey(worldName)) {
            this.cachedGroups.put(worldName, this.getGroups(worldName, this.manager.getDefaultGroup(worldName)));
        }
        return this.cachedGroups.get(worldName).toArray(new PermissionGroup[0]);
    }

    private List<PermissionGroup> getGroups(String worldName, PermissionGroup fallback) {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        for (String groupName : this.getGroupsNamesImpl(worldName)) {
            PermissionGroup group;
            if (groupName == null || groupName.isEmpty() || !this.checkMembership(group = this.manager.getGroup(groupName), worldName) || groups.contains(group)) continue;
            groups.add(group);
        }
        if (worldName != null) {
            for (String world : this.manager.getWorldInheritance(worldName)) {
                groups.addAll(this.getGroups(world, null));
            }
            groups.addAll(this.getGroups(null, null));
        }
        if (groups.isEmpty() && fallback != null) {
            groups.add(fallback);
        }
        if (groups.size() > 1) {
            Collections.sort(groups);
        }
        return groups;
    }

    public Map<String, PermissionGroup[]> getAllGroups() {
        HashMap<String, PermissionGroup[]> allGroups = new HashMap<String, PermissionGroup[]>();
        for (String worldName : this.getWorlds()) {
            allGroups.put(worldName, this.getWorldGroups(worldName));
        }
        allGroups.put(null, this.getWorldGroups(null));
        return allGroups;
    }

    protected PermissionGroup[] getWorldGroups(String worldName) {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        for (String groupName : this.getGroupsNamesImpl(worldName)) {
            PermissionGroup group;
            if (groupName == null || groupName.isEmpty() || groups.contains(group = this.manager.getGroup(groupName))) continue;
            groups.add(group);
        }
        Collections.sort(groups);
        return groups.toArray(new PermissionGroup[0]);
    }

    public String[] getGroupsNames() {
        return this.getGroupsNames(null);
    }

    public String[] getGroupsNames(String worldName) {
        LinkedList<String> groups = new LinkedList<String>();
        for (PermissionGroup group : this.getGroups(worldName)) {
            if (group == null) continue;
            groups.add(group.getName());
        }
        return groups.toArray(new String[0]);
    }

    public abstract void setGroups(String[] var1, String var2);

    public void setGroups(String[] groups) {
        this.setGroups(groups, null);
    }

    public void setGroups(PermissionGroup[] parentGroups, String worldName) {
        LinkedList<String> groups = new LinkedList<String>();
        for (PermissionGroup group : parentGroups) {
            groups.add(group.getName());
        }
        this.setGroups(groups.toArray(new String[0]), worldName);
    }

    public void setGroups(PermissionGroup[] parentGroups) {
        this.setGroups(parentGroups, null);
    }

    public void addGroup(String groupName, String worldName) {
        if (groupName == null || groupName.isEmpty()) {
            return;
        }
        ArrayList<String> groups = new ArrayList<String>(Arrays.asList(this.getGroupsNamesImpl(worldName)));
        if (groups.contains(groupName)) {
            return;
        }
        if (this.manager.userAddGroupsLast) {
            groups.add(groupName);
        } else {
            groups.add(0, groupName);
        }
        this.setGroups(groups.toArray(new String[0]), worldName);
    }

    public void addGroup(String groupName) {
        this.addGroup(groupName, null);
    }

    public void addGroup(PermissionGroup group, String worldName) {
        if (group == null) {
            return;
        }
        this.addGroup(group.getName(), worldName);
    }

    public void addGroup(PermissionGroup group) {
        this.addGroup(group, null);
    }

    public void addGroup(String groupName, String worldName, long lifetime) {
        this.addGroup(groupName, worldName);
        if (lifetime > 0L) {
            this.setOption("group-" + groupName + "-until", Long.toString(System.currentTimeMillis() / 1000L + lifetime), worldName);
        }
    }

    public void removeGroup(String groupName, String worldName) {
        if (groupName == null || groupName.isEmpty()) {
            return;
        }
        ArrayList<String> groups = new ArrayList<String>(Arrays.asList(this.getGroupsNamesImpl(worldName)));
        if (!groups.contains(groupName)) {
            return;
        }
        groups.remove(groupName);
        this.setGroups(groups.toArray(new String[0]), worldName);
    }

    public void removeGroup(String groupName) {
        this.removeGroup(this.manager.getGroup(groupName));
    }

    public void removeGroup(PermissionGroup group, String worldName) {
        if (group == null) {
            return;
        }
        this.removeGroup(group.getName(), worldName);
    }

    public void removeGroup(PermissionGroup group) {
        for (String worldName : this.getWorlds()) {
            this.removeGroup(group, worldName);
        }
        this.removeGroup(group, null);
    }

    public boolean inGroup(PermissionGroup group, String worldName, boolean checkInheritance) {
        for (PermissionGroup parentGroup : this.getGroups(worldName)) {
            if (parentGroup.equals(group)) {
                return true;
            }
            if (!checkInheritance || !parentGroup.isChildOf(group, worldName, true)) continue;
            return true;
        }
        return false;
    }

    public boolean inGroup(PermissionGroup group, boolean checkInheritance) {
        for (String worldName : this.getWorlds()) {
            if (!this.inGroup(group, worldName, checkInheritance)) continue;
            return true;
        }
        return this.inGroup(group, null, checkInheritance);
    }

    public boolean inGroup(String groupName, String worldName, boolean checkInheritance) {
        return this.inGroup(this.manager.getGroup(groupName), worldName, checkInheritance);
    }

    public boolean inGroup(String groupName, boolean checkInheritance) {
        return this.inGroup(this.manager.getGroup(groupName), checkInheritance);
    }

    public boolean inGroup(PermissionGroup group, String worldName) {
        return this.inGroup(group, worldName, true);
    }

    public boolean inGroup(PermissionGroup group) {
        return this.inGroup(group, true);
    }

    public boolean inGroup(String groupName, String worldName) {
        return this.inGroup(this.manager.getGroup(groupName), worldName, true);
    }

    public boolean inGroup(String groupName) {
        return this.inGroup(groupName, true);
    }

    public PermissionGroup promote(PermissionUser promoter, String ladderName) throws RankingException {
        if (ladderName == null || ladderName.isEmpty()) {
            ladderName = "default";
        }
        int promoterRank = this.getPromoterRankAndCheck(promoter, ladderName);
        int rank = this.getRank(ladderName);
        PermissionGroup sourceGroup = this.getRankLadders().get(ladderName);
        PermissionGroup targetGroup = null;
        for (Map.Entry<Integer, PermissionGroup> entry : this.manager.getRankLadder(ladderName).entrySet()) {
            int groupRank = entry.getValue().getRank();
            if (groupRank >= rank || groupRank <= promoterRank || targetGroup != null && groupRank <= targetGroup.getRank()) continue;
            targetGroup = entry.getValue();
        }
        if (targetGroup == null) {
            throw new RankingException("User are not promoteable", this, promoter);
        }
        this.swapGroups(sourceGroup, targetGroup);
        this.callEvent(PermissionEntityEvent.Action.RANK_CHANGED);
        return targetGroup;
    }

    public PermissionGroup demote(PermissionUser demoter, String ladderName) throws RankingException {
        if (ladderName == null || ladderName.isEmpty()) {
            ladderName = "default";
        }
        int promoterRank = this.getPromoterRankAndCheck(demoter, ladderName);
        int rank = this.getRank(ladderName);
        PermissionGroup sourceGroup = this.getRankLadders().get(ladderName);
        PermissionGroup targetGroup = null;
        for (Map.Entry<Integer, PermissionGroup> entry : this.manager.getRankLadder(ladderName).entrySet()) {
            int groupRank = entry.getValue().getRank();
            if (groupRank <= rank || groupRank <= promoterRank || targetGroup != null && groupRank >= targetGroup.getRank()) continue;
            targetGroup = entry.getValue();
        }
        if (targetGroup == null) {
            throw new RankingException("User are not demoteable", this, demoter);
        }
        this.swapGroups(sourceGroup, targetGroup);
        this.callEvent(PermissionEntityEvent.Action.RANK_CHANGED);
        return targetGroup;
    }

    public boolean isRanked(String ladder) {
        return this.getRank(ladder) > 0;
    }

    public int getRank(String ladder) {
        Map<String, PermissionGroup> ladders = this.getRankLadders();
        if (ladders.containsKey(ladder)) {
            return ladders.get(ladder).getRank();
        }
        return 0;
    }

    public PermissionGroup getRankLadderGroup(String ladder) {
        if (ladder == null || ladder.isEmpty()) {
            ladder = "default";
        }
        return this.getRankLadders().get(ladder);
    }

    public Map<String, PermissionGroup> getRankLadders() {
        HashMap<String, PermissionGroup> ladders = new HashMap<String, PermissionGroup>();
        for (PermissionGroup group : this.getGroups()) {
            if (!group.isRanked()) continue;
            ladders.put(group.getRankLadder(), group);
        }
        return ladders;
    }

    @Override
    public String[] getPermissions(String worldName) {
        if (!this.cachedPermissions.containsKey(worldName)) {
            LinkedList<String> permissions = new LinkedList<String>();
            this.getInheritedPermissions(worldName, permissions, true, false);
            this.cachedPermissions.put(worldName, permissions.toArray(new String[0]));
        }
        return this.cachedPermissions.get(worldName);
    }

    @Override
    public void addPermission(String permission, String worldName) {
        LinkedList<String> permissions = new LinkedList<String>(Arrays.asList(this.getOwnPermissions(worldName)));
        if (permissions.contains(permission)) {
            permissions.remove(permission);
        }
        permissions.add(0, permission);
        this.setPermissions(permissions.toArray(new String[0]), worldName);
    }

    @Override
    public void removePermission(String permission, String worldName) {
        LinkedList<String> permissions = new LinkedList<String>(Arrays.asList(this.getOwnPermissions(worldName)));
        permissions.remove(permission);
        this.setPermissions(permissions.toArray(new String[0]), worldName);
    }

    protected void getInheritedPermissions(String worldName, List<String> permissions, boolean groupInheritance, boolean worldInheritance) {
        permissions.addAll(Arrays.asList(this.getTimedPermissions(worldName)));
        permissions.addAll(Arrays.asList(this.getOwnPermissions(worldName)));
        if (worldName != null) {
            for (String parentWorld : this.manager.getWorldInheritance(worldName)) {
                this.getInheritedPermissions(parentWorld, permissions, false, true);
            }
            if (!worldInheritance) {
                this.getInheritedPermissions(null, permissions, false, true);
            }
        }
        if (groupInheritance) {
            for (PermissionGroup parentGroup : this.getGroups(worldName)) {
                parentGroup.getInheritedPermissions(worldName, permissions, true, false, new HashSet<PermissionGroup>());
            }
        }
        for (String node : permissions.toArray(new String[0])) {
            this.getInheritedChildPermissions(node, permissions);
        }
    }

    protected void getInheritedChildPermissions(String perm, List<String> list) {
        this.getInheritedChildPermissions(perm, list, false);
    }

    protected void getInheritedChildPermissions(String perm, List<String> list, boolean invert) {
        if (perm.startsWith("-")) {
            invert = !invert;
            perm = perm.substring(1);
        }
        this.getInheritedChildPermissions(Bukkit.getPluginManager().getPermission(perm), list, invert);
    }

    protected void getInheritedChildPermissions(Permission perm, List<String> list, boolean invert) {
        if (perm == null) {
            return;
        }
        for (Map.Entry entry : perm.getChildren().entrySet()) {
            boolean has = (Boolean)entry.getValue() ^ invert;
            String node = (has ? "" : "-") + (String)entry.getKey();
            if (list.contains(node)) continue;
            list.add(node);
            this.getInheritedChildPermissions(node, list, !has);
        }
    }

    @Override
    public void addTimedPermission(String permission, String world, int lifeTime) {
        super.addTimedPermission(permission, world, lifeTime);
        this.clearCache();
    }

    @Override
    public void removeTimedPermission(String permission, String world) {
        super.removeTimedPermission(permission, world);
        this.clearCache();
    }

    protected int getPromoterRankAndCheck(PermissionUser promoter, String ladderName) throws RankingException {
        if (!this.isRanked(ladderName)) {
            throw new RankingException("User are not in this ladder", this, promoter);
        }
        int rank = this.getRank(ladderName);
        int promoterRank = 0;
        if (promoter != null && promoter.isRanked(ladderName) && (promoterRank = promoter.getRank(ladderName)) >= rank) {
            throw new RankingException("Promoter don't have high enough rank to change " + this.getName() + "'s rank", this, promoter);
        }
        return promoterRank;
    }

    protected void swapGroups(PermissionGroup src, PermissionGroup dst) {
        ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>(Arrays.asList(this.getGroups()));
        groups.remove(src);
        groups.add(dst);
        this.setGroups(groups.toArray(new PermissionGroup[0]));
    }

    @Override
    public String getPrefix(String worldName) {
        if (!this.cachedPrefix.containsKey(worldName)) {
            String localPrefix = this.getOwnPrefix(worldName);
            if (worldName != null && (localPrefix == null || localPrefix.isEmpty())) {
                for (String parentWorld : this.manager.getWorldInheritance(worldName)) {
                    String prefix = this.getOwnPrefix(parentWorld);
                    if (prefix == null || prefix.isEmpty()) continue;
                    localPrefix = prefix;
                    break;
                }
                if (localPrefix == null || localPrefix.isEmpty()) {
                    localPrefix = this.getOwnPrefix(null);
                }
            }
            if (localPrefix == null || localPrefix.isEmpty()) {
                Object group;
                Object[] arr$ = this.getGroups(worldName);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && ((localPrefix = ((PermissionGroup)(group = arr$[i$])).getPrefix(worldName)) == null || localPrefix.isEmpty()); ++i$) {
                }
            }
            if (localPrefix == null) {
                localPrefix = "";
            }
            this.cachedPrefix.put(worldName, localPrefix);
        }
        return this.cachedPrefix.get(worldName);
    }

    @Override
    public boolean has(String permission) {
        Player player = Bukkit.getServer().getPlayer(this.getName());
        if (player != null) {
            return this.has(permission, player.getWorld().getName());
        }
        return super.has(permission);
    }

    @Override
    public String getSuffix(String worldName) {
        if (!this.cachedSuffix.containsKey(worldName)) {
            String localSuffix = this.getOwnSuffix(worldName);
            if (worldName != null && (localSuffix == null || localSuffix.isEmpty())) {
                for (String parentWorld : this.manager.getWorldInheritance(worldName)) {
                    String suffix = this.getOwnSuffix(parentWorld);
                    if (suffix == null || suffix.isEmpty()) continue;
                    localSuffix = suffix;
                    break;
                }
                if (localSuffix == null || localSuffix.isEmpty()) {
                    localSuffix = this.getOwnSuffix(null);
                }
            }
            if (localSuffix == null || localSuffix.isEmpty()) {
                Object group;
                Object[] arr$ = this.getGroups(worldName);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && ((localSuffix = ((PermissionGroup)(group = arr$[i$])).getSuffix(worldName)) == null || localSuffix.isEmpty()); ++i$) {
                }
            }
            if (localSuffix == null) {
                localSuffix = "";
            }
            this.cachedSuffix.put(worldName, localSuffix);
        }
        return this.cachedSuffix.get(worldName);
    }

    @Override
    public String getMatchingExpression(String permission, String world) {
        String result;
        String cacheId = world + ":" + permission;
        if (!this.cachedAnwsers.containsKey(cacheId)) {
            result = super.getMatchingExpression(permission, world);
            if (result == null) {
                result = PERMISSION_NOT_FOUND;
            }
            this.cachedAnwsers.put(cacheId, result);
        }
        if (PERMISSION_NOT_FOUND.equals(result = this.cachedAnwsers.get(cacheId))) {
            result = null;
        }
        return result;
    }

    protected void clearCache() {
        this.cachedPrefix.clear();
        this.cachedSuffix.clear();
        this.cachedGroups.clear();
        this.cachedPermissions.clear();
        this.cachedAnwsers.clear();
        this.cachedOptions.clear();
    }

    @Override
    public void setPrefix(String prefix, String worldName) {
        this.clearCache();
    }

    @Override
    public void setSuffix(String postfix, String worldName) {
        this.clearCache();
    }

    @Override
    public void remove() {
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.REMOVED);
    }

    @Override
    public void save() {
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.SAVED);
    }

    @Override
    public boolean explainExpression(String expression) {
        Player player;
        if (expression == null && this.manager.allowOps && (player = Bukkit.getServer().getPlayer(this.getName())) != null && player.isOp()) {
            return true;
        }
        return super.explainExpression(expression);
    }

    protected boolean checkMembership(PermissionGroup group, String worldName) {
        int groupLifetime = this.getOwnOptionInteger("group-" + group.getName() + "-until", worldName, 0);
        if (groupLifetime > 0 && (long)groupLifetime < System.currentTimeMillis() / 1000L) {
            this.setOption("group-" + group.getName() + "-until", null, worldName);
            this.removeGroup(group, worldName);
            return false;
        }
        return true;
    }
}

