/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionBackend;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionMatcher;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.RegExpMatcher;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.events.PermissionEvent;
import ru.tehkode.permissions.events.PermissionSystemEvent;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public class PermissionManager {
    public static final int TRANSIENT_PERMISSION = 0;
    protected static final Logger logger = Logger.getLogger("Minecraft");
    protected Map<String, PermissionUser> users = new HashMap<String, PermissionUser>();
    protected Map<String, PermissionGroup> groups = new HashMap<String, PermissionGroup>();
    protected Map<String, PermissionGroup> defaultGroups = new HashMap<String, PermissionGroup>();
    protected PermissionBackend backend = null;
    protected Configuration config;
    protected Timer timer;
    protected boolean debugMode = false;
    protected boolean allowOps = false;
    protected boolean userAddGroupsLast = false;
    protected PermissionMatcher matcher = new RegExpMatcher();

    public PermissionManager(Configuration config) throws PermissionBackendException {
        this.config = config;
        this.initBackend();
        this.debugMode = config.getBoolean("permissions.debug", this.debugMode);
        this.allowOps = config.getBoolean("permissions.allowOps", this.allowOps);
        this.userAddGroupsLast = config.getBoolean("permissions.user-add-groups-last", this.userAddGroupsLast);
    }

    public boolean has(Player player, String permission) {
        return this.has(player.getName(), permission, player.getWorld().getName());
    }

    public boolean has(Player player, String permission, String world) {
        return this.has(player.getName(), permission, world);
    }

    public boolean has(String playerName, String permission, String world) {
        PermissionUser user = this.getUser(playerName);
        if (user == null) {
            return false;
        }
        return user.has(permission, world);
    }

    public PermissionUser getUser(String username) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Null or empty name passed! Name must not be empty");
        }
        PermissionUser user = this.users.get(username.toLowerCase());
        if (user == null) {
            user = this.backend.getUser(username);
            if (user != null) {
                user.initialize();
                this.users.put(username.toLowerCase(), user);
            } else {
                throw new IllegalStateException("User " + username + " is null");
            }
        }
        return user;
    }

    public PermissionUser getUser(Player player) {
        return this.getUser(player.getName());
    }

    public PermissionUser[] getUsers() {
        return this.backend.getUsers();
    }

    public Collection<String> getUserNames() {
        return this.backend.getRegisteredUserNames();
    }

    public PermissionUser[] getUsers(String groupName, String worldName) {
        return this.backend.getUsers(groupName, worldName);
    }

    public PermissionUser[] getUsers(String groupName) {
        return this.backend.getUsers(groupName);
    }

    public PermissionUser[] getUsers(String groupName, String worldName, boolean inheritance) {
        return this.backend.getUsers(groupName, worldName, inheritance);
    }

    public PermissionUser[] getUsers(String groupName, boolean inheritance) {
        return this.backend.getUsers(groupName, inheritance);
    }

    public void resetUser(String userName) {
        this.users.remove(userName.toLowerCase());
    }

    public void clearUserCache(String userName) {
        PermissionUser user = this.getUser(userName);
        if (user != null) {
            user.clearCache();
        }
    }

    public void clearUserCache(Player player) {
        this.clearUserCache(player.getName());
    }

    public PermissionGroup getGroup(String groupname) {
        if (groupname == null || groupname.isEmpty()) {
            return null;
        }
        PermissionGroup group = this.groups.get(groupname.toLowerCase());
        if (group == null) {
            group = this.backend.getGroup(groupname);
            if (group != null) {
                group.initialize();
                this.groups.put(groupname.toLowerCase(), group);
            } else {
                throw new IllegalStateException("Group " + groupname + " is null");
            }
        }
        return group;
    }

    public PermissionGroup[] getGroups() {
        return this.backend.getGroups();
    }

    public PermissionGroup[] getGroups(String groupName, String worldName) {
        return this.backend.getGroups(groupName, worldName);
    }

    public PermissionGroup[] getGroups(String groupName) {
        return this.backend.getGroups(groupName);
    }

    public PermissionGroup[] getGroups(String groupName, String worldName, boolean inheritance) {
        return this.backend.getGroups(groupName, worldName, inheritance);
    }

    public PermissionGroup[] getGroups(String groupName, boolean inheritance) {
        return this.backend.getGroups(groupName, inheritance);
    }

    public PermissionGroup getDefaultGroup(String worldName) {
        String worldIndex;
        String string = worldIndex = worldName != null ? worldName : "";
        if (!this.defaultGroups.containsKey(worldIndex)) {
            this.defaultGroups.put(worldIndex, this.getDefaultGroup(worldName, this.getDefaultGroup(null, null)));
        }
        return this.defaultGroups.get(worldIndex);
    }

    public PermissionGroup getDefaultGroup() {
        return this.getDefaultGroup(null);
    }

    private PermissionGroup getDefaultGroup(String worldName, PermissionGroup fallback) {
        PermissionGroup defaultGroup = this.backend.getDefaultGroup(worldName);
        if (defaultGroup == null && worldName == null) {
            throw new IllegalStateException("No default group defined. Use \"pex set default group <group> [world]\" to define default group.");
        }
        if (defaultGroup != null) {
            return defaultGroup;
        }
        if (worldName != null) {
            for (String parentWorld : this.getWorldInheritance(worldName)) {
                defaultGroup = this.getDefaultGroup(parentWorld, null);
                if (defaultGroup == null) continue;
                return defaultGroup;
            }
        }
        return fallback;
    }

    public void setDefaultGroup(PermissionGroup group, String worldName) {
        if (group == null || group.equals(this.defaultGroups)) {
            return;
        }
        this.backend.setDefaultGroup(group, worldName);
        this.defaultGroups.clear();
        this.callEvent(PermissionSystemEvent.Action.DEFAULTGROUP_CHANGED);
        this.callEvent(new PermissionEntityEvent(group, PermissionEntityEvent.Action.DEFAULTGROUP_CHANGED));
    }

    public void setDefaultGroup(PermissionGroup group) {
        this.setDefaultGroup(group, null);
    }

    public void resetGroup(String groupName) {
        this.groups.remove(groupName);
    }

    public void setDebug(boolean debug) {
        this.debugMode = debug;
        this.callEvent(PermissionSystemEvent.Action.DEBUGMODE_TOGGLE);
    }

    public boolean isDebug() {
        return this.debugMode;
    }

    public Map<Integer, PermissionGroup> getRankLadder(String ladderName) {
        HashMap<Integer, PermissionGroup> ladder = new HashMap<Integer, PermissionGroup>();
        for (PermissionGroup group : this.getGroups()) {
            if (!group.isRanked() || !group.getRankLadder().equalsIgnoreCase(ladderName)) continue;
            ladder.put(group.getRank(), group);
        }
        return ladder;
    }

    public String[] getWorldInheritance(String worldName) {
        return this.backend.getWorldInheritance(worldName);
    }

    public void setWorldInheritance(String world, String[] parentWorlds) {
        this.backend.setWorldInheritance(world, parentWorlds);
        this.callEvent(PermissionSystemEvent.Action.WORLDINHERITANCE_CHANGED);
    }

    public PermissionBackend getBackend() {
        return this.backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackend(String backendName) throws PermissionBackendException {
        PermissionManager permissionManager = this;
        synchronized (permissionManager) {
            this.clearCache();
            this.backend = PermissionBackend.getBackend(backendName, this, this.config);
            this.backend.initialize();
        }
        this.callEvent(PermissionSystemEvent.Action.BACKEND_CHANGED);
    }

    protected void registerTask(TimerTask task, int delay) {
        if (this.timer == null || delay == 0) {
            return;
        }
        this.timer.schedule(task, delay * 1000);
    }

    public void reset() throws PermissionBackendException {
        this.clearCache();
        if (this.backend != null) {
            this.backend.reload();
        }
        this.callEvent(PermissionSystemEvent.Action.RELOADED);
    }

    public void end() {
        try {
            this.reset();
        }
        catch (PermissionBackendException permissionBackendException) {
            // empty catch block
        }
        this.timer.cancel();
    }

    public void initTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("PermissionsEx-Cleaner");
    }

    protected void clearCache() {
        this.users.clear();
        this.groups.clear();
        this.defaultGroups.clear();
        this.initTimer();
    }

    private void initBackend() throws PermissionBackendException {
        String backendName = this.config.getString("permissions.backend");
        if (backendName == null || backendName.isEmpty()) {
            backendName = "file";
            this.config.set("permissions.backend", (Object)backendName);
        }
        this.setBackend(backendName);
    }

    protected void callEvent(PermissionEvent event) {
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    protected void callEvent(PermissionSystemEvent.Action action) {
        this.callEvent(new PermissionSystemEvent(action));
    }

    public PermissionMatcher getPermissionMatcher() {
        return this.matcher;
    }

    public void setPermissionMatcher(PermissionMatcher matcher) {
        this.matcher = matcher;
    }

    public Collection<String> getGroupNames() {
        return this.backend.getRegisteredGroupNames();
    }
}

