/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.events.PermissionEntityEvent;

public abstract class PermissionGroup
extends PermissionEntity
implements Comparable<PermissionGroup> {
    protected static final String NON_INHERITABLE_PREFIX = "#";
    protected int weight = 0;
    protected boolean dirtyWeight = true;

    public PermissionGroup(String groupName, PermissionManager manager) {
        super(groupName, manager);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isDebug()) {
            Logger.getLogger("PermissionsEx").info("[PermissionsEx] Group " + this.getName() + " initialized");
        }
    }

    public String getOwnPrefix() {
        return this.getOwnPrefix(null);
    }

    public abstract String getOwnPrefix(String var1);

    public final String getOwnSuffix() {
        return this.getOwnSuffix(null);
    }

    public abstract String getOwnSuffix(String var1);

    public abstract String[] getOwnPermissions(String var1);

    public abstract String getOwnOption(String var1, String var2, String var3);

    public String getOwnOption(String option) {
        return this.getOwnOption(option, null, null);
    }

    public String getOwnOption(String option, String world) {
        return this.getOwnOption(option, world, null);
    }

    public boolean getOwnOptionBoolean(String optionName, String world, boolean defaultValue) {
        String option = this.getOwnOption(optionName, world, Boolean.toString(defaultValue));
        if ("false".equalsIgnoreCase(option)) {
            return false;
        }
        if ("true".equalsIgnoreCase(option)) {
            return true;
        }
        return defaultValue;
    }

    public int getOwnOptionInteger(String optionName, String world, int defaultValue) {
        String option = this.getOwnOption(optionName, world, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(option);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getOwnOptionDouble(String optionName, String world, double defaultValue) {
        String option = this.getOwnOption(optionName, world, Double.toString(defaultValue));
        try {
            return Double.parseDouble(option);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getWeight() {
        if (this.dirtyWeight) {
            this.weight = this.getOptionInteger("weight", null, 0);
            this.dirtyWeight = false;
        }
        return this.weight;
    }

    public void setWeight(int weight) {
        this.setOption("weight", Integer.toString(weight));
        this.dirtyWeight = true;
        this.clearMembersCache();
        this.callEvent(PermissionEntityEvent.Action.WEIGHT_CHANGED);
    }

    public boolean isRanked() {
        return this.getRank() > 0;
    }

    public int getRank() {
        return this.getOwnOptionInteger("rank", null, 0);
    }

    public void setRank(int rank) {
        if (rank > 0) {
            this.setOption("rank", Integer.toString(rank));
        } else {
            this.setOption("rank", null);
        }
        this.callEvent(PermissionEntityEvent.Action.RANK_CHANGED);
    }

    public String getRankLadder() {
        return this.getOption("rank-ladder", "", "default");
    }

    public void setRankLadder(String rankLadder) {
        if (rankLadder.isEmpty() || rankLadder.equals("default")) {
            rankLadder = null;
        }
        this.setOption("rank-ladder", rankLadder);
        this.callEvent(PermissionEntityEvent.Action.RANK_CHANGED);
    }

    protected abstract String[] getParentGroupsNamesImpl(String var1);

    public PermissionGroup[] getParentGroups(String worldName) {
        LinkedList<PermissionGroup> parentGroups = new LinkedList<PermissionGroup>();
        for (String parentGroup : this.getParentGroupsNamesImpl(worldName)) {
            PermissionGroup group;
            if ((parentGroup = parentGroup.trim()).isEmpty() || parentGroup.equals(this.getName()) || parentGroups.contains(group = this.manager.getGroup(parentGroup)) || group.isChildOf(this, worldName, true)) continue;
            parentGroups.add(group);
        }
        if (worldName != null) {
            for (String parentWorld : this.manager.getWorldInheritance(worldName)) {
                parentGroups.addAll(Arrays.asList(this.getParentGroups(parentWorld)));
            }
            parentGroups.addAll(Arrays.asList(this.getParentGroups(null)));
        }
        Collections.sort(parentGroups);
        return parentGroups.toArray(new PermissionGroup[0]);
    }

    public PermissionGroup[] getParentGroups() {
        return this.getParentGroups(null);
    }

    public Map<String, PermissionGroup[]> getAllParentGroups() {
        HashMap<String, PermissionGroup[]> allGroups = new HashMap<String, PermissionGroup[]>();
        for (String worldName : this.getWorlds()) {
            allGroups.put(worldName, this.getWorldGroups(worldName));
        }
        allGroups.put(null, this.getWorldGroups(null));
        return allGroups;
    }

    protected PermissionGroup[] getWorldGroups(String worldName) {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        for (String groupName : this.getParentGroupsNamesImpl(worldName)) {
            PermissionGroup group;
            if (groupName == null || groupName.isEmpty() || groupName.equalsIgnoreCase(this.getName()) || groups.contains(group = this.manager.getGroup(groupName))) continue;
            groups.add(group);
        }
        Collections.sort(groups);
        return groups.toArray(new PermissionGroup[0]);
    }

    public String[] getParentGroupsNames(String worldName) {
        LinkedList<String> groups = new LinkedList<String>();
        for (PermissionGroup group : this.getParentGroups(worldName)) {
            groups.add(group.getName());
        }
        return groups.toArray(new String[0]);
    }

    public String[] getParentGroupsNames() {
        return this.getParentGroupsNames(null);
    }

    public abstract void setParentGroups(String[] var1, String var2);

    public void setParentGroups(String[] parentGroups) {
        this.setParentGroups(parentGroups, null);
    }

    public void setParentGroups(PermissionGroup[] parentGroups, String worldName) {
        LinkedList<String> groups = new LinkedList<String>();
        for (PermissionGroup group : parentGroups) {
            groups.add(group.getName());
        }
        this.setParentGroups(groups.toArray(new String[0]), worldName);
        this.callEvent(PermissionEntityEvent.Action.INHERITANCE_CHANGED);
    }

    public void setParentGroups(PermissionGroup[] parentGroups) {
        this.setParentGroups(parentGroups, null);
    }

    protected abstract void removeGroup();

    public boolean isChildOf(PermissionGroup group, String worldName, boolean checkInheritance) {
        if (group == null) {
            return false;
        }
        for (PermissionGroup parentGroup : this.getParentGroups(worldName)) {
            if (group.equals(parentGroup)) {
                return true;
            }
            if (!checkInheritance || !parentGroup.isChildOf(group, worldName, checkInheritance)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(PermissionGroup group, boolean checkInheritance) {
        for (String worldName : this.getWorlds()) {
            if (!this.isChildOf(group, worldName, checkInheritance)) continue;
            return true;
        }
        return this.isChildOf(group, null, checkInheritance);
    }

    public boolean isChildOf(PermissionGroup group, String worldName) {
        return this.isChildOf(group, worldName, false);
    }

    public boolean isChildOf(PermissionGroup group) {
        return this.isChildOf(group, false);
    }

    public boolean isChildOf(String groupName, String worldName, boolean checkInheritance) {
        return this.isChildOf(this.manager.getGroup(groupName), worldName, checkInheritance);
    }

    public boolean isChildOf(String groupName, boolean checkInheritance) {
        return this.isChildOf(this.manager.getGroup(groupName), checkInheritance);
    }

    public boolean isChildOf(String groupName, String worldName) {
        return this.isChildOf(groupName, worldName, false);
    }

    public boolean isChildOf(String groupName) {
        return this.isChildOf(groupName, false);
    }

    public PermissionGroup[] getChildGroups(String worldName) {
        return this.manager.getGroups(this.getName(), worldName, false);
    }

    public PermissionGroup[] getChildGroups() {
        return this.manager.getGroups(this.getName(), false);
    }

    public PermissionGroup[] getDescendantGroups(String worldName) {
        return this.manager.getGroups(this.getName(), worldName, true);
    }

    public PermissionGroup[] getDescendantGroups() {
        return this.manager.getGroups(this.getName(), true);
    }

    public PermissionUser[] getUsers(String worldName) {
        return this.manager.getUsers(this.getName(), worldName, false);
    }

    public PermissionUser[] getUsers() {
        return this.manager.getUsers(this.getName());
    }

    public boolean isDefault(String worldName) {
        return this.equals(this.manager.getDefaultGroup(worldName));
    }

    @Override
    public String getPrefix(String worldName) {
        String localPrefix = this.getOwnPrefix(worldName);
        if (worldName != null && (localPrefix == null || localPrefix.isEmpty())) {
            for (String parentWorld : this.manager.getWorldInheritance(worldName)) {
                String prefix = this.getOwnPrefix(parentWorld);
                if (prefix == null || prefix.isEmpty()) continue;
                localPrefix = prefix;
                break;
            }
            if (localPrefix == null || localPrefix.isEmpty()) {
                localPrefix = this.getOwnPrefix(null);
            }
        }
        if (localPrefix == null || localPrefix.isEmpty()) {
            Object group;
            Object[] arr$ = this.getParentGroups(worldName);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((localPrefix = ((PermissionGroup)(group = arr$[i$])).getPrefix(worldName)) == null || localPrefix.isEmpty()); ++i$) {
            }
        }
        if (localPrefix == null) {
            localPrefix = "";
        }
        return localPrefix;
    }

    @Override
    public String getSuffix(String worldName) {
        String localSuffix = this.getOwnSuffix(worldName);
        if (worldName != null && (localSuffix == null || localSuffix.isEmpty())) {
            for (String parentWorld : this.manager.getWorldInheritance(worldName)) {
                String suffix = this.getOwnSuffix(parentWorld);
                if (suffix == null || suffix.isEmpty()) continue;
                localSuffix = suffix;
                break;
            }
            if (localSuffix == null || localSuffix.isEmpty()) {
                localSuffix = this.getOwnSuffix(null);
            }
        }
        if (localSuffix == null || localSuffix.isEmpty()) {
            Object group;
            Object[] arr$ = this.getParentGroups(worldName);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((localSuffix = ((PermissionGroup)(group = arr$[i$])).getSuffix(worldName)) == null || localSuffix.isEmpty()); ++i$) {
            }
        }
        if (localSuffix == null) {
            localSuffix = "";
        }
        return localSuffix;
    }

    @Override
    public String[] getPermissions(String world) {
        LinkedList<String> permissions = new LinkedList<String>();
        this.getInheritedPermissions(world, permissions, true, false, new HashSet<PermissionGroup>());
        return permissions.toArray(new String[0]);
    }

    @Override
    public void addPermission(String permission, String worldName) {
        LinkedList<String> permissions = new LinkedList<String>(Arrays.asList(this.getOwnPermissions(worldName)));
        if (permissions.contains(permission)) {
            permissions.remove(permission);
        }
        permissions.add(0, permission);
        this.setPermissions(permissions.toArray(new String[0]), worldName);
    }

    @Override
    public void removePermission(String permission, String worldName) {
        LinkedList<String> permissions = new LinkedList<String>(Arrays.asList(this.getOwnPermissions(worldName)));
        permissions.remove(permission);
        this.setPermissions(permissions.toArray(new String[0]), worldName);
    }

    protected void getInheritedPermissions(String worldName, List<String> permissions, boolean groupInheritance, boolean worldInheritance, Set<PermissionGroup> visitedGroups) {
        if (visitedGroups.size() == 0) {
            permissions.addAll(Arrays.asList(this.getTimedPermissions(worldName)));
            permissions.addAll(Arrays.asList(this.getOwnPermissions(worldName)));
        } else {
            this.copyFilterPermissions(NON_INHERITABLE_PREFIX, permissions, this.getTimedPermissions(worldName));
            this.copyFilterPermissions(NON_INHERITABLE_PREFIX, permissions, this.getOwnPermissions(worldName));
        }
        if (worldName != null) {
            for (String parentWorld : this.manager.getWorldInheritance(worldName)) {
                this.getInheritedPermissions(parentWorld, permissions, false, true, visitedGroups);
            }
            if (!worldInheritance) {
                this.getInheritedPermissions(null, permissions, false, true, visitedGroups);
            }
        }
        if (groupInheritance && !visitedGroups.contains(this)) {
            visitedGroups.add(this);
            for (PermissionGroup group : this.getParentGroups(worldName)) {
                group.getInheritedPermissions(worldName, permissions, true, false, visitedGroups);
            }
        }
    }

    protected void copyFilterPermissions(String filterPrefix, List<String> to, String[] from) {
        for (String permission : from) {
            if (permission.startsWith(filterPrefix)) continue;
            to.add(permission);
        }
    }

    @Override
    public void addTimedPermission(String permission, String world, int lifeTime) {
        super.addTimedPermission(permission, world, lifeTime);
        this.clearMembersCache();
    }

    @Override
    public void removeTimedPermission(String permission, String world) {
        super.removeTimedPermission(permission, world);
        this.clearMembersCache();
    }

    protected void clearMembersCache() {
        for (PermissionUser user : this.getUsers()) {
            user.clearCache();
        }
    }

    @Override
    public final void remove() {
        for (String world : this.getWorlds()) {
            this.clearChildren(world);
        }
        this.clearChildren(null);
        this.removeGroup();
        this.callEvent(PermissionEntityEvent.Action.REMOVED);
    }

    private void clearChildren(String worldName) {
        for (PermissionGroup permissionGroup : this.getChildGroups(worldName)) {
            LinkedList<PermissionGroup> parentGroups = new LinkedList<PermissionGroup>(Arrays.asList(permissionGroup.getParentGroups(worldName)));
            parentGroups.remove(this);
            permissionGroup.setParentGroups(parentGroups.toArray(new PermissionGroup[0]), worldName);
        }
        for (PermissionEntity permissionEntity : this.getUsers(worldName)) {
            ((PermissionUser)permissionEntity).removeGroup(this, worldName);
        }
    }

    @Override
    public String getOption(String optionName, String worldName, String defaultValue) {
        return this.getOption(optionName, worldName, defaultValue, new HashSet<PermissionGroup>());
    }

    protected String getOption(String optionName, String worldName, String defaultValue, Set<PermissionGroup> alreadyVisited) {
        String value = this.getOwnOption(optionName, worldName, null);
        if (value != null) {
            return value;
        }
        if (worldName != null) {
            for (String world : this.manager.getWorldInheritance(worldName)) {
                value = this.getOption(optionName, world, null);
                if (value == null) continue;
                return value;
            }
            value = this.getOption(optionName, null, null);
            if (value != null) {
                return value;
            }
        }
        if (!alreadyVisited.contains(this)) {
            alreadyVisited.add(this);
            for (PermissionGroup group : this.getParentGroups(worldName)) {
                value = group.getOption(optionName, worldName, null, alreadyVisited);
                if (value == null) continue;
                return value;
            }
        }
        return defaultValue;
    }

    @Override
    public int compareTo(PermissionGroup o) {
        return this.getWeight() - o.getWeight();
    }
}

