/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.events.PermissionEntityEvent;

public abstract class PermissionEntity {
    protected PermissionManager manager;
    private String name;
    protected boolean virtual = true;
    protected Map<String, List<String>> timedPermissions = new ConcurrentHashMap<String, List<String>>();
    protected Map<String, Long> timedPermissionsTime = new ConcurrentHashMap<String, Long>();
    protected boolean debugMode = false;

    public PermissionEntity(String name, PermissionManager manager) {
        this.manager = manager;
        this.name = name;
    }

    public void initialize() {
        this.debugMode = this.getOptionBoolean("debug", null, this.debugMode);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public abstract String getPrefix(String var1);

    public String getPrefix() {
        return this.getPrefix(null);
    }

    public abstract void setPrefix(String var1, String var2);

    public abstract String getSuffix(String var1);

    public String getSuffix() {
        return this.getSuffix(null);
    }

    public abstract void setSuffix(String var1, String var2);

    public boolean has(String permission) {
        return this.has(permission, ((World)Bukkit.getServer().getWorlds().get(0)).getName());
    }

    public boolean has(String permission, String world) {
        if (permission != null && permission.isEmpty()) {
            return true;
        }
        String expression = this.getMatchingExpression(permission, world);
        if (this.isDebug()) {
            Logger.getLogger("Minecraft").info("User " + this.getName() + " checked for \"" + permission + "\", " + (expression == null ? "no permission found" : "\"" + expression + "\" found"));
        }
        return this.explainExpression(expression);
    }

    public abstract String[] getPermissions(String var1);

    public abstract Map<String, String[]> getAllPermissions();

    public void addPermission(String permission, String world) {
        throw new UnsupportedOperationException("You shouldn't call this method");
    }

    public void addPermission(String permission) {
        this.addPermission(permission, "");
    }

    public void removePermission(String permission, String worldName) {
        throw new UnsupportedOperationException("You shouldn't call this method");
    }

    public void removePermission(String permission) {
        for (String world : this.getAllPermissions().keySet()) {
            this.removePermission(permission, world);
        }
    }

    public abstract void setPermissions(String[] var1, String var2);

    public void setPermissions(String[] permission) {
        this.setPermissions(permission, "");
    }

    public abstract String getOption(String var1, String var2, String var3);

    public String getOption(String option) {
        return this.getOption(option, "", "");
    }

    public String getOption(String option, String world) {
        return this.getOption(option, world, "");
    }

    public int getOptionInteger(String optionName, String world, int defaultValue) {
        try {
            return Integer.parseInt(this.getOption(optionName, world, Integer.toString(defaultValue)));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getOptionDouble(String optionName, String world, double defaultValue) {
        String option = this.getOption(optionName, world, Double.toString(defaultValue));
        try {
            return Double.parseDouble(option);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getOptionBoolean(String optionName, String world, boolean defaultValue) {
        String option = this.getOption(optionName, world, Boolean.toString(defaultValue));
        if ("false".equalsIgnoreCase(option)) {
            return false;
        }
        if ("true".equalsIgnoreCase(option)) {
            return true;
        }
        return defaultValue;
    }

    public abstract void setOption(String var1, String var2, String var3);

    public void setOption(String permission, String value) {
        this.setOption(permission, value, "");
    }

    public abstract Map<String, String> getOptions(String var1);

    public abstract Map<String, Map<String, String>> getAllOptions();

    public abstract void save();

    public abstract void remove();

    public boolean isVirtual() {
        return this.virtual;
    }

    public abstract String[] getWorlds();

    public String[] getTimedPermissions(String world) {
        if (world == null) {
            world = "";
        }
        if (!this.timedPermissions.containsKey(world)) {
            return new String[0];
        }
        return this.timedPermissions.get(world).toArray(new String[0]);
    }

    public int getTimedPermissionLifetime(String permission, String world) {
        if (world == null) {
            world = "";
        }
        if (!this.timedPermissionsTime.containsKey(world + ":" + permission)) {
            return 0;
        }
        return (int)(this.timedPermissionsTime.get(world + ":" + permission) - System.currentTimeMillis() / 1000L);
    }

    public void addTimedPermission(final String permission, String world, int lifeTime) {
        if (world == null) {
            world = "";
        }
        if (!this.timedPermissions.containsKey(world)) {
            this.timedPermissions.put(world, new LinkedList());
        }
        this.timedPermissions.get(world).add(permission);
        final String finalWorld = world;
        if (lifeTime > 0) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    PermissionEntity.this.removeTimedPermission(permission, finalWorld);
                }
            };
            this.manager.registerTask(task, lifeTime);
            this.timedPermissionsTime.put(world + ":" + permission, System.currentTimeMillis() / 1000L + (long)lifeTime);
        }
        this.callEvent(PermissionEntityEvent.Action.PERMISSIONS_CHANGED);
    }

    public void removeTimedPermission(String permission, String world) {
        if (world == null) {
            world = "";
        }
        if (!this.timedPermissions.containsKey(world)) {
            return;
        }
        this.timedPermissions.get(world).remove(permission);
        this.timedPermissions.remove(world + ":" + permission);
        this.callEvent(PermissionEntityEvent.Action.PERMISSIONS_CHANGED);
    }

    protected void callEvent(PermissionEntityEvent event) {
        this.manager.callEvent(event);
    }

    protected void callEvent(PermissionEntityEvent.Action action) {
        this.callEvent(new PermissionEntityEvent(this, action));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PermissionEntity other = (PermissionEntity)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    public String getMatchingExpression(String permission, String world) {
        return this.getMatchingExpression(this.getPermissions(world), permission);
    }

    public String getMatchingExpression(String[] permissions, String permission) {
        for (String expression : permissions) {
            if (!this.isMatches(expression, permission, true)) continue;
            return expression;
        }
        return null;
    }

    public boolean isMatches(String expression, String permission, boolean additionalChecks) {
        return this.manager.getPermissionMatcher().isMatches(expression, permission);
    }

    public boolean explainExpression(String expression) {
        if (expression == null || expression.isEmpty()) {
            return false;
        }
        return !expression.startsWith("-");
    }

    public boolean isDebug() {
        return this.debugMode || this.manager.isDebug();
    }

    public void setDebug(boolean debug) {
        this.debugMode = debug;
    }
}

