/*
 * Decompiled with CFR 0.152.
 */
package me.richdev.BungeeSpigotCommandConnector.Bungee;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class Commands
extends Command {
    public Commands() {
        super("bcmd", "BSCC.Command", new String[]{"bungeecmd"});
    }

    public void execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7cCommands: ");
            sender.sendMessage("\u00a7e/bcmd -console -all or -server:[servers] [cmd]  \u00a73Execute a command from the console from a another server.");
            sender.sendMessage("\u00a7e/bcmd -player:[players] [cmd] \u00a73Execute a command using a player in a defined server.");
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7eEspecial modifiers: "));
            sender.sendMessage("\u00a7e-all \u00a7b>> Executes something on every server. (Most used with -console");
            sender.sendMessage("\u00a7e-server:[servers] \u00a7b>> Select a server to execute the command. (Most used with -player:[players]");
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a76Examples: "));
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a76/bcmd -console -server:lobby,pve,skyblock broadcast Have a nice day! \u00a7b>> Executes \"broadcast Have a ncie day\" on lobby, pve and skyblock."));
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a76/bcmd -console -server:lobby broadcast Hello \u00a7b>> Executes \"broadcast Hello\" on on lobby."));
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a76/bcmd -player:RichTheLord -server:PVE give Wirlie Diamond \u00a7b>> Executes \"give Wirlie Diamond\" on PVE server."));
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a76/bcmd -player:RichTheLord,Wirlie -server:PVE,Skyblock give AnotherPlayer Diamond \u00a7b>> Executes \"give AnotherPlayer Diamond\" on PVE or Skyblock server."));
        } else {
            CommandBuilder builder = new CommandBuilder(sender);
            for (String arg : args) {
                if (arg.contains("-console") || arg.contains("-bconsole")) {
                    builder.setFromConsole(true);
                    continue;
                }
                if (arg.contains("-player") || arg.contains("-bplayer")) {
                    builder.translatePlayers(arg);
                    continue;
                }
                if (arg.contains("-all")) {
                    builder.setWithAllServers(true);
                    continue;
                }
                if (arg.contains("-server")) {
                    builder.translateServers(arg);
                    continue;
                }
                builder.appendCmd(arg);
            }
            builder.executeSend();
        }
    }

    private class CommandBuilder {
        private boolean console;
        private boolean all;
        private String[] players;
        private List<String> servers;
        private StringBuilder command;
        private CommandSender sender;

        public CommandBuilder(CommandSender sender) {
            this.sender = sender;
            this.command = new StringBuilder();
        }

        public void setFromConsole(boolean fromConsole) {
            if (!this.sender.hasPermission("BSCC.bungee.console")) {
                this.sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7cYou don't have permission to execute from console. Skipping tag."));
                return;
            }
            this.console = fromConsole;
        }

        public void translatePlayers(String players) {
            if (!this.sender.hasPermission("BSCC.bungee.player")) {
                this.sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7cYou don't have permission to force a player to execute a command. Skipping tag."));
                return;
            }
            String data = players.split(":")[1];
            this.players = data.split(",");
        }

        public void translateServers(String usingServers) {
            String[] preproces;
            String data = usingServers.split(":")[1];
            for (String a : preproces = data.split(",")) {
                if (!this.sender.hasPermission("BSCC.bungee.server." + a)) {
                    this.sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a7cYou don't have permission to execute commands on: " + a + ". Skipping Server.")));
                    continue;
                }
                if (this.servers == null) {
                    this.servers = Lists.newArrayList();
                }
                this.servers.add(a);
            }
        }

        public void setWithAllServers(boolean all) {
            if (!this.sender.hasPermission("BSCC.bungee.all")) {
                this.sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7cYou don't have permission to execute from every server.. Skipping tag."));
                return;
            }
            this.all = all;
        }

        public void appendCmd(String cmd) {
            this.command.append(cmd).append(" ");
        }

        public void executeSend() {
            ServerInfo found;
            if (!this.console && this.players == null) {
                this.sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7cI don't know who will execute this command. \n \u00a7cAdd: -console or -player:[player]"));
                return;
            }
            if (!this.all && this.servers == null) {
                this.sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7cI don't know were to execute this command. \n \u00a7cAdd: -all or -server:[server]"));
                return;
            }
            if (this.console) {
                if (this.all) {
                    ProxyServer.getInstance().getServers().forEach((string, info) -> {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        DataOutputStream out = new DataOutputStream(stream);
                        try {
                            out.writeUTF("@CONSOLE");
                            out.writeUTF(this.command.toString());
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        info.sendData("BSCC", stream.toByteArray());
                    });
                } else if (this.servers != null) {
                    for (String server : this.servers) {
                        found = ProxyServer.getInstance().getServerInfo(server);
                        if (found != null) {
                            ByteArrayOutputStream stream = new ByteArrayOutputStream();
                            DataOutputStream out = new DataOutputStream(stream);
                            try {
                                out.writeUTF("@CONSOLE");
                                out.writeUTF(this.command.toString());
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                            found.sendData("BSCC", stream.toByteArray());
                            continue;
                        }
                        this.sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a7cServer " + server + " wasn't found.")));
                    }
                }
            }
            if (this.players != null) {
                if (this.all) {
                    for (String player : this.players) {
                        ProxyServer.getInstance().getPlayer(player).chat("/" + this.command.toString());
                    }
                } else if (this.servers != null) {
                    for (String server : this.servers) {
                        found = ProxyServer.getInstance().getServerInfo(server);
                        if (found != null) {
                            for (String player : this.players) {
                                if (!this.serverContainsPlayer(found, player)) continue;
                                ProxyServer.getInstance().getPlayer(player).chat("/" + this.command.toString());
                            }
                            continue;
                        }
                        this.sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a7cServer \u00a7e" + server + " \u00a7cwasn't found.")));
                    }
                }
            }
            this.sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7aExecuting Command."));
        }

        private boolean serverContainsPlayer(ServerInfo info, String playerName) {
            for (ProxiedPlayer player : info.getPlayers()) {
                if (!player.getName().equals(playerName)) continue;
                return true;
            }
            return false;
        }
    }
}

