/*
 * Decompiled with CFR 0.152.
 */
package villagerapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ReflectionUtils {
    public static Object createNMSGameMode(GameMode gameMode) {
        Class c = ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".EnumGamemode");
        try {
            Method method = c.getDeclaredMethod("getById", Integer.TYPE);
            method.setAccessible(true);
            return method.invoke(null, gameMode.getValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <WrappedGameProfile> Object createPlayerInfoData(WrappedGameProfile profile, GameMode gameMode, int ping, String nickName) {
        Object nmsGameMode = ReflectionUtils.createNMSGameMode(gameMode);
        try {
            Constructor constructor = ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".PlayerInfoData").getDeclaredConstructor(ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".PacketPlayOutPlayerInfo"), ReflectionUtils.getClassByName("com.mojang.authlib.GameProfile"), Integer.TYPE, ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".EnumGamemode"), ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".IChatBaseComponent"));
            constructor.setAccessible(true);
            return constructor.newInstance(null, ((NMSMerchantRecipeList)profile).getHandle(), ping, nmsGameMode, ReflectionUtils.createNMSTextComponent(nickName));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object createNMSTextComponent(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        Class c = ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".ChatComponentText");
        try {
            Constructor constructor = c.getDeclaredConstructor(String.class);
            return constructor.newInstance(text);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object toEntityHuman(Player player) {
        try {
            Class c = ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getOBCPackageName()) + ".entity.CraftPlayer");
            Method m = c.getDeclaredMethod("getHandle", new Class[0]);
            m.setAccessible(true);
            return m.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getClassByName(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getField(Class c, Object obj, String key) throws Exception {
        Field field = c.getDeclaredField(key);
        field.setAccessible(true);
        return field.get(obj);
    }

    public static void replaceField(Class c, Object obj, String key, Object value) throws Exception {
        Field field = c.getDeclaredField(key);
        field.setAccessible(true);
        field.set(obj, value);
    }

    public static String getNMSPackageName() {
        return "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    }

    public static String getOBCPackageName() {
        return "org.bukkit.craftbukkit." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    }

    public static class NMSMerchantRecipe {
        private Object merchantRecipe;

        public NMSMerchantRecipe(Object merchantRecipe) {
            this.merchantRecipe = merchantRecipe;
        }

        public NMSMerchantRecipe(Object item1, Object item3) {
            this(item1, null, item3);
        }

        public NMSMerchantRecipe(Object item1, Object item2, Object item3) {
            try {
                Class isClass = ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".ItemStack");
                this.merchantRecipe = NMSMerchantRecipe.getNMSClass().getDeclaredConstructor(isClass, isClass, isClass).newInstance(item1, item2, item3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static Class getNMSClass() {
            return ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".MerchantRecipe");
        }

        public Object getBuyItem1() {
            try {
                Method m = NMSMerchantRecipe.getNMSClass().getDeclaredMethod("getBuyItem1", new Class[0]);
                m.setAccessible(true);
                return m.invoke(this.merchantRecipe, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getBuyItem2() {
            try {
                Method m = NMSMerchantRecipe.getNMSClass().getDeclaredMethod("getBuyItem2", new Class[0]);
                m.setAccessible(true);
                return m.invoke(this.merchantRecipe, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getBuyItem3() {
            try {
                Method m = NMSMerchantRecipe.getNMSClass().getDeclaredMethod("getBuyItem3", new Class[0]);
                m.setAccessible(true);
                return m.invoke(this.merchantRecipe, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getMaxUses() {
            try {
                Field field = NMSMerchantRecipe.getNMSClass().getDeclaredField("maxUses");
                field.setAccessible(true);
                return field.getByte(this.merchantRecipe);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public void setMaxUses(int maxUses) {
            try {
                Field field = NMSMerchantRecipe.getNMSClass().getDeclaredField("maxUses");
                field.setAccessible(true);
                field.set(this.merchantRecipe, maxUses);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Object getMerchantRecipe() {
            return this.merchantRecipe;
        }
    }

    public static class NMSMerchantRecipeList {
        private Object handle;

        public static Class getNMSClass() {
            return ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".MerchantRecipeList");
        }

        public NMSMerchantRecipeList() {
            try {
                this.handle = NMSMerchantRecipeList.getNMSClass().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public NMSMerchantRecipeList(Object handle) {
            this.handle = handle;
        }

        public Object getHandle() {
            return this.handle;
        }

        public void clear() {
            try {
                Method m = ArrayList.class.getDeclaredMethod("clear", new Class[0]);
                m.setAccessible(true);
                m.invoke(this.handle, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void add(NMSMerchantRecipe recipe) {
            try {
                Method m = ArrayList.class.getDeclaredMethod("add", Object.class);
                m.setAccessible(true);
                m.invoke(this.handle, recipe.getMerchantRecipe());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public List<NMSMerchantRecipe> getRecipes() {
            ArrayList<NMSMerchantRecipe> recipeList = new ArrayList<NMSMerchantRecipe>();
            for (Object obj : (List)this.handle) {
                recipeList.add(new NMSMerchantRecipe(obj));
            }
            return recipeList;
        }
    }

    public static class OBCCraftItemStack {
        public static Class getOBCClass() {
            return ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getOBCPackageName()) + ".inventory.CraftItemStack");
        }

        public static ItemStack asBukkitCopy(Object nmsItemStack) {
            try {
                Method m = OBCCraftItemStack.getOBCClass().getDeclaredMethod("asBukkitCopy", ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".ItemStack"));
                m.setAccessible(true);
                return (ItemStack)m.invoke(null, nmsItemStack);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static Object asNMSCopy(ItemStack stack) {
            try {
                Method m = OBCCraftItemStack.getOBCClass().getDeclaredMethod("asNMSCopy", ItemStack.class);
                m.setAccessible(true);
                return m.invoke(null, stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class PlayerInfoAction {
        public static Object UPDATE_GAME_MODE = PlayerInfoAction.getNMSAction("UPDATE_GAME_MODE");
        public static Object ADD_PLAYER = PlayerInfoAction.getNMSAction("ADD_PLAYER");
        public static Object UPDATE_DISPLAY_NAME = PlayerInfoAction.getNMSAction("UPDATE_DISPLAY_NAME");
        public static Object REMOVE_PLAYER = PlayerInfoAction.getNMSAction("REMOVE_PLAYER");

        private static Object getNMSAction(String name) {
            try {
                Field field = PlayerInfoAction.getNMSClass().getDeclaredField(name);
                field.setAccessible(true);
                return field.get(null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static Class getNMSClass() {
            return ReflectionUtils.getClassByName(String.valueOf(ReflectionUtils.getNMSPackageName()) + ".EnumPlayerInfoAction");
        }
    }
}

