/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.object;

import io.github.maxmar628.DestruyeElNexus.listeners.SoulboundListener;
import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public enum Kit {
    CIVILIAN(Material.WORKBENCH){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WORKBENCH));
            this.lore.add("You are the backbone.");
            this.lore.add("");
            this.lore.add("Fuel all facets of the");
            this.lore.add("war machine with your");
            this.lore.add("set of wooden tools and");
            this.lore.add("prepare for battle!");
        }
    }
    ,
    WARRIOR(Material.STONE_SWORD){
        {
            this.spawnItems.add(new ItemStack(Material.STONE_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new Potion(PotionType.INSTANT_HEAL, 1).toItemStack(1));
            ((ItemStack)this.spawnItems.get(0)).addEnchantment(Enchantment.KNOCKBACK, 1);
            this.lore.add("You are the sword.");
            this.lore.add("");
            this.lore.add("You deal +1 damage with");
            this.lore.add("any melee weapon.");
            this.lore.add("");
            this.lore.add("Spawn with a knockback");
            this.lore.add("sword and a health potion");
            this.lore.add("which enable you to move");
            this.lore.add("immediately on the enemy");
            this.lore.add("and attack!");
        }
    }
    ,
    ARCHER(Material.BOW){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.BOW));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_SPADE));
            this.spawnItems.add(new Potion(PotionType.INSTANT_HEAL, 1).toItemStack(1));
            this.spawnItems.add(new ItemStack(Material.ARROW, 16));
            ((ItemStack)this.spawnItems.get(1)).addEnchantment(Enchantment.ARROW_KNOCKBACK, 1);
            this.lore.add("You are the rain.");
            this.lore.add("");
            this.lore.add("You deal +1 damage with");
            this.lore.add("a bow and can craft arrows");
            this.lore.add("without feathers.");
            this.lore.add("");
            this.lore.add("Place flint on top of sticks");
            this.lore.add("in your crafting interface");
            this.lore.add("to create 3 arrows!");
        }
    }
    ,
    MINER(Material.STONE_PICKAXE){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.STONE_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.FURNACE));
            this.spawnItems.add(new ItemStack(Material.COAL, 4));
            ((ItemStack)this.spawnItems.get(1)).addEnchantment(Enchantment.DIG_SPEED, 1);
            this.lore.add("You are the hands.");
            this.lore.add("");
            this.lore.add("Spawn with an efficiency");
            this.lore.add("stone pickaxe and mine");
            this.lore.add(")precious resources for");
            this.lore.add("your team more quickly with");
            this.lore.add("your doubled ore drops!");
        }
    }
    ,
    LUMBERJACK(Material.STONE_AXE){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.STONE_AXE));
            ((ItemStack)this.spawnItems.get(2)).addEnchantment(Enchantment.DIG_SPEED, 1);
            this.lore.add("You are the wedge.");
            this.lore.add("");
            this.lore.add("Spawn with an efficiency");
            this.lore.add("stone axe and use your");
            this.lore.add("doubled log drops to obtain");
            this.lore.add("large amounts of wood for");
            this.lore.add("your team's builders!");
        }
    }
    ,
    SCOUT(Material.FISHING_ROD){
        {
            this.spawnItems.add(new ItemStack(Material.GOLD_SWORD));
            this.spawnItems.add(new ItemStack(Material.FISHING_ROD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            ItemMeta meta = ((ItemStack)this.spawnItems.get(1)).getItemMeta();
            meta.setDisplayName("Grapple");
            ((ItemStack)this.spawnItems.get(1)).setItemMeta(meta);
            this.lore.add("You are the feet.");
            this.lore.add("");
            this.lore.add("Use your permanent speed");
            this.lore.add("boost to maneuver around");
            this.lore.add("the battlefield and your");
            this.lore.add("grapple to climb obstacles");
            this.lore.add("and enemy defenses!");
            this.lore.add("");
            this.lore.add("You can only wear light");
            this.lore.add("armor; anything heavier");
            this.lore.add("than chainmail will slow");
            this.lore.add("you down.");
        }
    }
    ,
    BERSERKER(Material.CHAINMAIL_CHESTPLATE){
        {
            this.spawnItems.add(new ItemStack(Material.STONE_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new Potion(PotionType.INSTANT_HEAL, 1).toItemStack(1));
            this.lore.add("You are the tank.");
            this.lore.add("");
            this.lore.add("Start each life with only");
            this.lore.add("7 hearts. For every enemy");
            this.lore.add("kill, you garner yourself");
            this.lore.add("an extra heart, allowing");
            this.lore.add("you to gain up to 15 hearts!");
        }
    }
    ,
    OPERATIVE(Material.SOUL_SAND){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.SOUL_SAND));
            ItemMeta meta = ((ItemStack)this.spawnItems.get(3)).getItemMeta();
            meta.setDisplayName(ChatColor.AQUA + "Return Point");
            ((ItemStack)this.spawnItems.get(3)).setItemMeta(meta);
            this.lore.add("You are the <something>");
            this.lore.add("");
            this.lore.add("Carry out your plans for");
            this.lore.add("offense and safely escape!");
            this.lore.add("");
            this.lore.add("You spawn with a block of");
            this.lore.add("soulsand, which when placed");
            this.lore.add("will set a return point. In");
            this.lore.add("90 seconds, you will be");
            this.lore.add("teleported back. Make sure");
            this.lore.add("to place it safe from enemies!");
        }
    }
    ,
    ACROBAT(Material.FEATHER){
        {
            this.spawnItems.add(new ItemStack(Material.IRON_SWORD));
            this.spawnItems.add(new ItemStack(Material.IRON_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.IRON_AXE));
            this.spawnItems.add(new ItemStack(Material.WORKBENCH));
            this.spawnItems.add(new Potion(PotionType.SPEED, 1).toItemStack(3));
            this.lore.add("Obtienes:");
            this.lore.add("");
            this.lore.add("Tres Speed Potion");
            this.lore.add("");
            this.lore.add("Tambien el kit civilian");
        }
    }
    ,
    ASSASSIN(Material.GOLD_SWORD){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WORKBENCH));
            this.lore.add("");
            this.lore.add("");
            this.lore.add("PROXIMAMENTE.");
            this.lore.add("");
            this.lore.add("");
        }
    }
    ,
    ENCHANTER(Material.EXP_BOTTLE){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.BOOK));
            this.spawnItems.add(new ItemStack(Material.EXP_BOTTLE, 25));
            this.lore.add("Obtienes:");
            this.lore.add("");
            this.lore.add("Un libro para");
            this.lore.add("tus encantamientos");
            this.lore.add("");
            this.lore.add("Tambien recibiras");
            this.lore.add("25 botellas de experiencia");
            this.lore.add("");
            this.lore.add("Tambien el kit civilian");
        }
    }
    ,
    DEFENDER(Material.STONE_SWORD){
        {
            this.spawnItems.add(new ItemStack(Material.STONE_SWORD));
            this.spawnItems.add(new ItemStack(Material.IRON_CHESTPLATE));
            this.spawnItems.add(new ItemStack(Material.IRON_BOOTS));
            this.spawnItems.add(new ItemStack(Material.IRON_HELMET));
            this.spawnItems.add(new ItemStack(Material.IRON_LEGGINGS));
            this.spawnItems.add(new Potion(PotionType.INSTANT_HEAL, 1).toItemStack(1));
            this.lore.add("Obtienes:");
            this.lore.add("");
            this.lore.add("Set completo");
            this.lore.add("de Hierro y espada");
        }
    }
    ,
    PYRO(Material.FIRE){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.FLINT_AND_STEEL, 3));
            this.spawnItems.add(new Potion(PotionType.FIRE_RESISTANCE, 1).toItemStack(1));
            this.lore.add("Obtienes:");
            this.lore.add("");
            this.lore.add("Tres encendedores");
            this.lore.add("");
            this.lore.add("Tambien recibiras");
            this.lore.add("1 pocion de resistencia");
            this.lore.add("al fuego");
            this.lore.add("");
            this.lore.add("Tambien el kit civilian");
        }
    }
    ,
    SCORPIO(Material.NETHER_STAR){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WORKBENCH));
            this.lore.add("");
            this.lore.add("");
            this.lore.add("PROXIMAMENTE.");
            this.lore.add("");
            this.lore.add("");
        }
    }
    ,
    SUCCUBUS(Material.INK_SACK){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WORKBENCH));
            this.lore.add("");
            this.lore.add("");
            this.lore.add("PROXIMAMENTE.");
            this.lore.add("");
            this.lore.add("");
        }
    }
    ,
    SWAPPER(Material.GREEN_RECORD){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WORKBENCH));
            this.lore.add("");
            this.lore.add("");
            this.lore.add("PROXIMAMENTE.");
            this.lore.add("");
            this.lore.add("");
        }
    }
    ,
    THOR(Material.GOLD_AXE){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WORKBENCH));
            this.lore.add("");
            this.lore.add("");
            this.lore.add("PROXIMAMENTE.");
            this.lore.add("");
            this.lore.add("");
        }
    };

    private ItemStack icon;
    List<String> lore = new ArrayList<String>();
    List<ItemStack> spawnItems = new ArrayList<ItemStack>();
    ItemStack[] spawnArmor = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), new ItemStack(Material.LEATHER_HELMET)};

    static {
        Kit[] kitArray = Kit.values();
        int n = kitArray.length;
        int n2 = 0;
        while (n2 < n) {
            Kit kit = kitArray[n2];
            kit.init();
            ++n2;
        }
    }

    private Kit(Material m) {
        this.icon = new ItemStack(m);
        ItemMeta meta = this.icon.getItemMeta();
        meta.setDisplayName(this.getName());
        this.icon.setItemMeta(meta);
    }

    private void init() {
        int i = 0;
        while (i < this.lore.size()) {
            String s = this.lore.get(i);
            s = ChatColor.AQUA + s;
            this.lore.set(i, s);
            ++i;
        }
        ItemMeta meta = this.icon.getItemMeta();
        meta.setLore(this.lore);
        this.icon.setItemMeta(meta);
    }

    public static Kit getKit(String name) {
        Kit[] kitArray = Kit.values();
        int n = kitArray.length;
        int n2 = 0;
        while (n2 < n) {
            Kit type = kitArray[n2];
            if (type.name().equalsIgnoreCase(name)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public void give(Player recipient, GameTeam team) {
        PlayerInventory inv = recipient.getInventory();
        inv.clear();
        for (ItemStack item : this.spawnItems) {
            ItemStack toGive = item.clone();
            SoulboundListener.soulbind(toGive);
            inv.addItem(new ItemStack[]{toGive});
        }
        recipient.removePotionEffect(PotionEffectType.SPEED);
        ItemStack compass = new ItemStack(Material.COMPASS);
        ItemMeta compassMeta = compass.getItemMeta();
        compassMeta.setDisplayName(team.color() + "Pointing to " + team.toString() + " Nexus");
        compass.setItemMeta(compassMeta);
        SoulboundListener.soulbind(compass);
        inv.addItem(new ItemStack[]{compass});
        recipient.setCompassTarget(team.getNexus().getLocation());
        inv.setArmorContents(this.spawnArmor);
        this.colorizeArmor(inv, this.getTeamColor(team));
        ItemStack[] itemStackArray = inv.getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack armor = itemStackArray[n2];
            SoulboundListener.soulbind(armor);
            ++n2;
        }
        if (this == SCOUT) {
            this.addScoutParticles(recipient);
        }
        if (this == BERSERKER) {
            recipient.setMaxHealth(14.0);
        } else {
            recipient.setMaxHealth(20.0);
        }
    }

    private Color getTeamColor(GameTeam team) {
        switch (team) {
            case RED: {
                return Color.RED;
            }
            case YELLOW: {
                return Color.YELLOW;
            }
            case GREEN: {
                return Color.GREEN;
            }
            case BLUE: {
                return Color.BLUE;
            }
        }
        return Color.WHITE;
    }

    private void colorizeArmor(PlayerInventory inv, Color color) {
        ItemStack[] itemStackArray = inv.getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item.getItemMeta() instanceof LeatherArmorMeta) {
                LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
                meta.setColor(color);
                item.setItemMeta((ItemMeta)meta);
            }
            ++n2;
        }
    }

    public String getName() {
        return String.valueOf(this.name().substring(0, 1)) + this.name().substring(1).toLowerCase();
    }

    public boolean isOwnedBy(Player p) {
        return p.isOp() || this == CIVILIAN || p.hasPermission("annihilation.class." + this.getName().toLowerCase());
    }

    public void addScoutParticles(Player p) {
        if (this != SCOUT) {
            return;
        }
        p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 0, true), true);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    /* synthetic */ Kit(String string, int n, Material material, Kit kit) {
        this(material);
    }
}

