/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.manager;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.Util;
import io.github.maxmar628.DestruyeElNexus.bar.BarUtil;
import io.github.maxmar628.DestruyeElNexus.manager.PhaseManager;
import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RestartHandler {
    private final DestruyeElNexus plugin;
    private long time;
    private long delay;
    private int taskID;
    private int fwID;

    public RestartHandler(DestruyeElNexus plugin, long delay) {
        this.plugin = plugin;
        this.delay = delay;
    }

    public void start(long gameTime, final Color c) {
        for (Entity entity : this.plugin.getMapManager().getCurrentMap().getWorld().getEntities()) {
            if (entity.getType() != EntityType.IRON_GOLEM) continue;
            entity.remove();
        }
        this.time = this.delay;
        final String totalTime = PhaseManager.timeString(gameTime);
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (RestartHandler.this.time <= 0L) {
                    RestartHandler.this.stop();
                    return;
                }
                String message = ChatColor.GOLD + "Total time: " + ChatColor.WHITE + totalTime + " | " + ChatColor.GREEN + "Restarting in " + RestartHandler.this.time;
                float percent = (float)RestartHandler.this.time / (float)RestartHandler.this.delay;
                Player[] playerArray = Bukkit.getOnlinePlayers();
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player p = playerArray[n2];
                    BarUtil.setMessageAndPercent(p, message, percent);
                    ++n2;
                }
                RestartHandler restartHandler = RestartHandler.this;
                restartHandler.time = restartHandler.time - 1L;
            }
        }, 0L, 20L);
        this.fwID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                GameTeam[] gameTeamArray = GameTeam.values();
                int n = gameTeamArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GameTeam gt = gameTeamArray[n2];
                    if (gt != GameTeam.NONE) {
                        for (Location l : gt.getSpawns()) {
                            Util.spawnFirework(l, c, c);
                        }
                    }
                    ++n2;
                }
            }
        }, 0L, 40L);
    }

    private void stop() {
        Bukkit.getScheduler().cancelTask(this.taskID);
        Bukkit.getScheduler().cancelTask(this.fwID);
        if (this.plugin.runCommand) {
            for (String c : this.plugin.commands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)c);
            }
        } else {
            this.plugin.reset();
        }
    }
}

