/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.manager;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.Util;
import io.github.maxmar628.DestruyeElNexus.bar.BarUtil;
import io.github.maxmar628.DestruyeElNexus.chat.ChatUtil;
import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class PhaseManager {
    private long time;
    private long startTime;
    private long phaseTime;
    private int phase;
    private boolean isRunning;
    private final DestruyeElNexus plugin;
    private int taskID;

    public PhaseManager(DestruyeElNexus plugin, int start, int period) {
        this.plugin = plugin;
        this.startTime = start;
        this.phaseTime = period;
        this.phase = 0;
    }

    public void start() {
        if (!this.isRunning) {
            BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
            this.taskID = scheduler.scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    PhaseManager.this.onSecond();
                }
            }, 20L, 20L);
            this.isRunning = true;
        }
        this.time = -this.startTime;
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            BarUtil.setMessageAndPercent(p, ChatColor.GREEN + "Starting in " + -this.time, 1.0f);
            ++n2;
        }
        this.plugin.getSignHandler().updateSigns(GameTeam.RED);
        this.plugin.getSignHandler().updateSigns(GameTeam.BLUE);
        this.plugin.getSignHandler().updateSigns(GameTeam.GREEN);
        this.plugin.getSignHandler().updateSigns(GameTeam.YELLOW);
    }

    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            Bukkit.getServer().getScheduler().cancelTask(this.taskID);
        }
    }

    public void reset() {
        this.stop();
        this.time = -this.startTime;
        this.phase = 0;
    }

    public long getTime() {
        return this.time;
    }

    public long getRemainingPhaseTime() {
        if (this.phase == 5) {
            return this.phaseTime;
        }
        if (this.phase >= 1) {
            return this.time % this.phaseTime;
        }
        return -this.time;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void onSecond() {
        String text;
        float percent;
        ++this.time;
        if (this.getRemainingPhaseTime() == 0L) {
            ++this.phase;
            this.plugin.advancePhase();
        }
        if (this.phase == 0) {
            percent = (float)(-this.time) / (float)this.startTime;
            text = ChatColor.GREEN + "Starting in " + -this.time;
        } else {
            percent = this.phase == 5 ? 1.0f : (float)this.getRemainingPhaseTime() / (float)this.phaseTime;
            text = String.valueOf(Util.getPhaseColor(this.phase)) + ChatColor.WHITE + " Fase " + ChatUtil.translateRoman(this.phase) + ChatColor.WHITE + " - " + ChatColor.WHITE + PhaseManager.timeString(this.time);
            this.plugin.getSignHandler().updateSigns(GameTeam.RED);
            this.plugin.getSignHandler().updateSigns(GameTeam.BLUE);
            this.plugin.getSignHandler().updateSigns(GameTeam.GREEN);
            this.plugin.getSignHandler().updateSigns(GameTeam.YELLOW);
        }
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            BarUtil.setMessageAndPercent(p, text, percent);
            ++n2;
        }
        this.plugin.onSecond();
    }

    public static String timeString(long time) {
        long hours = time / 3600L;
        long minutes = (time - hours * 3600L) / 60L;
        long seconds = time - hours * 3600L - minutes * 60L;
        return String.format(ChatColor.WHITE + "%02d" + ChatColor.GRAY + ":" + ChatColor.WHITE + "%02d" + ChatColor.GRAY + ":" + ChatColor.WHITE + "%02d", hours, minutes, seconds).replace("-", "");
    }
}

