/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.manager;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.maps.GameMap;
import io.github.maxmar628.DestruyeElNexus.maps.MapLoader;
import io.github.maxmar628.DestruyeElNexus.maps.VoidGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WorldCreator;
import org.bukkit.configuration.Configuration;
import org.bukkit.generator.ChunkGenerator;

public class MapManager {
    private final ArrayList<String> maps = new ArrayList();
    private GameMap currentMap = null;
    private Location lobbySpawn;
    private MapLoader mapLoader;

    public MapManager(DestruyeElNexus plugin, MapLoader loader, Configuration config) {
        this.mapLoader = loader;
        for (String s : config.getKeys(false)) {
            if (s.equalsIgnoreCase("lobby")) continue;
            this.maps.add(s);
        }
        WorldCreator wc = new WorldCreator("lobby");
        wc.generator((ChunkGenerator)new VoidGenerator());
        Bukkit.createWorld((WorldCreator)wc);
        this.lobbySpawn = this.parseLocation(config.getString("lobby.spawn"));
    }

    private Location parseLocation(String in) {
        String[] params = in.split(",");
        if (params.length == 3 || params.length == 5) {
            double x = Double.parseDouble(params[0]);
            double y = Double.parseDouble(params[1]);
            double z = Double.parseDouble(params[2]);
            Location loc = new Location(Bukkit.getWorld((String)"lobby"), x, y, z);
            if (params.length == 5) {
                loc.setYaw(Float.parseFloat(params[3]));
                loc.setPitch(Float.parseFloat(params[4]));
            }
            return loc;
        }
        return null;
    }

    public boolean selectMap(String mapName) {
        this.currentMap = new GameMap(this.mapLoader);
        return this.currentMap.loadIntoGame(mapName);
    }

    public boolean mapSelected() {
        return this.currentMap != null;
    }

    public GameMap getCurrentMap() {
        return this.currentMap;
    }

    public Location getLobbySpawnPoint() {
        return this.lobbySpawn;
    }

    public List<String> getRandomMaps() {
        LinkedList<String> shuffledMaps = new LinkedList<String>(this.maps);
        Collections.shuffle(shuffledMaps);
        return shuffledMaps.subList(0, Math.min(3, shuffledMaps.size()));
    }

    public void reset() {
        this.currentMap = null;
    }
}

