/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.listeners;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.object.Kit;
import io.github.maxmar628.DestruyeElNexus.object.PlayerMeta;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ResourceListener
implements Listener {
    private final DestruyeElNexus plugin;
    private final HashMap<Material, Resource> resources = new HashMap();
    private final HashSet<Location> queue = new HashSet();
    private final Set<Location> diamonds = new HashSet<Location>();
    private Random rand = new Random();

    public ResourceListener(DestruyeElNexus plugin) {
        this.plugin = plugin;
        this.addResource(Material.COAL_ORE, 8, 10);
        this.addResource(Material.IRON_ORE, 10, 20);
        this.addResource(Material.GOLD_ORE, 10, 20);
        this.addResource(Material.DIAMOND_ORE, 12, 30);
        this.addResource(Material.EMERALD_ORE, 18, 40);
        this.addResource(Material.REDSTONE_ORE, 10, 20);
        this.addResource(Material.GLOWING_REDSTONE_ORE, 10, 20);
        this.addResource(Material.LOG, 2, 10);
        this.addResource(Material.GRAVEL, 2, 20);
        this.addResource(Material.MELON_BLOCK, 0, 10);
    }

    @EventHandler(ignoreCancelled=false)
    public void onResourceBreak(BlockBreakEvent e) {
        if (this.resources.containsKey(e.getBlock().getType())) {
            e.setCancelled(true);
            this.breakResource(e.getPlayer(), e.getBlock());
            e.getBlock().getWorld().playEffect(e.getBlock().getLocation(), Effect.STEP_SOUND, e.getBlock().getTypeId());
        } else if (this.queue.contains(e.getBlock().getLocation())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=false)
    public void placeResource(BlockPlaceEvent e) {
        if (this.resources.containsKey(e.getBlock().getType())) {
            e.setCancelled(true);
        }
    }

    public void loadDiamonds(Set<Location> diamondLocations) {
        for (Location loc : diamondLocations) {
            if (loc.getBlock().getType() == Material.DIAMOND_ORE) {
                loc.getBlock().setType(Material.AIR);
            }
            this.diamonds.add(loc);
        }
    }

    public void spawnDiamonds() {
        for (Location loc : this.diamonds) {
            loc.getBlock().setType(Material.DIAMOND_ORE);
        }
    }

    private void breakResource(Player player, Block block) {
        Material type = block.getType();
        Kit kit = PlayerMeta.getMeta(player).getKit();
        Resource resource = this.resources.get(type);
        if (type.equals((Object)Material.GRAVEL)) {
            ItemStack[] drops;
            ItemStack[] itemStackArray = drops = this.getGravelDrops();
            int n = drops.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack stack = itemStackArray[n2];
                if (stack.getAmount() > 0) {
                    player.getInventory().addItem(new ItemStack[]{stack});
                }
                ++n2;
            }
        } else {
            Material dropType = resource.drop;
            int qty = this.getDropQuantity(type);
            if (type.name().contains("ORE") && kit == Kit.MINER || type.name().contains("LOG") && kit == Kit.LUMBERJACK) {
                qty *= (double)this.rand.nextFloat() < 0.9 ? 2 : 1;
            }
            player.getInventory().addItem(new ItemStack[]{new ItemStack(dropType, qty)});
        }
        if (resource.xp > 0) {
            player.giveExp(resource.xp.intValue());
            player.playSound(player.getLocation(), Sound.ORB_PICKUP, 1.0f, this.rand.nextFloat() * 0.2f + 0.9f);
        }
        this.queueRespawn(block);
    }

    private void queueRespawn(final Block block) {
        final Material type = block.getType();
        block.setType(this.getRespawnMaterial(type));
        this.queue.add(block.getLocation());
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                block.setType(type);
                ResourceListener.this.queue.remove(block.getLocation());
                block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, block.getTypeId());
            }
        }, (long)this.resources.get((Object)type).delay.intValue() * 20L);
    }

    private int getDropQuantity(Material type) {
        switch (type) {
            case MELON_BLOCK: {
                return 3 + this.rand.nextInt(5);
            }
            case REDSTONE_ORE: 
            case GLOWING_REDSTONE_ORE: {
                return 4 + (this.rand.nextBoolean() ? 1 : 0);
            }
        }
        return 1;
    }

    private Material getRespawnMaterial(Material type) {
        switch (type) {
            case LOG: 
            case MELON_BLOCK: {
                return Material.AIR;
            }
        }
        return Material.COBBLESTONE;
    }

    private ItemStack[] getGravelDrops() {
        ItemStack arrows = new ItemStack(Material.ARROW, Math.max(this.rand.nextInt(5) - 2, 0));
        ItemStack flint = new ItemStack(Material.FLINT, Math.max(this.rand.nextInt(4) - 2, 0));
        ItemStack feathers = new ItemStack(Material.FEATHER, Math.max(this.rand.nextInt(4) - 2, 0));
        ItemStack string = new ItemStack(Material.STRING, Math.max(this.rand.nextInt(5) - 3, 0));
        ItemStack bones = new ItemStack(Material.BONE, Math.max(this.rand.nextInt(4) - 2, 0));
        return new ItemStack[]{arrows, flint, feathers, string, bones};
    }

    private void addResource(Material type, int xp, int delay) {
        this.resources.put(type, new Resource(this.getDropMaterial(type), xp, delay));
    }

    private Material getDropMaterial(Material type) {
        switch (type) {
            case COAL_ORE: {
                return Material.COAL;
            }
            case DIAMOND_ORE: {
                return Material.DIAMOND;
            }
            case EMERALD_ORE: {
                return Material.EMERALD;
            }
            case REDSTONE_ORE: 
            case GLOWING_REDSTONE_ORE: {
                return Material.REDSTONE;
            }
            case MELON_BLOCK: {
                return Material.MELON;
            }
            case GRAVEL: {
                return null;
            }
        }
        return type;
    }

    private class Resource {
        public final Material drop;
        public final Integer xp;
        public final Integer delay;

        public Resource(Material drop, Integer xp, Integer delay) {
            this.drop = drop;
            this.xp = xp;
            this.delay = delay;
        }
    }
}

