/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.listeners;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.Util;
import io.github.maxmar628.DestruyeElNexus.api.NexusDamageEvent;
import io.github.maxmar628.DestruyeElNexus.api.NexusDestroyEvent;
import io.github.maxmar628.DestruyeElNexus.chat.ChatUtil;
import io.github.maxmar628.DestruyeElNexus.manager.PhaseManager;
import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import io.github.maxmar628.DestruyeElNexus.object.Kit;
import io.github.maxmar628.DestruyeElNexus.object.PlayerMeta;
import io.github.maxmar628.DestruyeElNexus.stats.StatType;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.EnumClientCommand;
import net.minecraft.server.v1_7_R4.PacketPlayInClientCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class PlayerListener
implements Listener {
    private DestruyeElNexus plugin;
    private HashMap<String, Kit> kitsToGive = new HashMap();

    public PlayerListener(DestruyeElNexus plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onMOTDPing(ServerListPingEvent e) {
        if (this.plugin.motd) {
            String motd = this.plugin.getConfig().getString("motd");
            try {
                motd = motd.replaceAll("%PHASE%", String.valueOf(this.plugin.getPhase() == 0 ? "Starting" : Integer.valueOf(this.plugin.getPhase())));
                this.plugin.getPhaseManager();
                motd = motd.replaceAll("%TIME%", PhaseManager.timeString(this.plugin.getPhaseManager().getTime()));
                motd = motd.replaceAll("%PLAYERCOUNT", String.valueOf(Bukkit.getOnlinePlayers().length));
                motd = motd.replaceAll("%MAXPLAYERS%", String.valueOf(Bukkit.getMaxPlayers()));
                motd = motd.replaceAll("%GREENNEXUS%", String.valueOf(this.getNexus(GameTeam.GREEN)));
                motd = motd.replaceAll("%GREENCOUNT%", String.valueOf(this.getPlayers(GameTeam.GREEN)));
                motd = motd.replaceAll("%REDNEXUS%", String.valueOf(this.getNexus(GameTeam.RED)));
                motd = motd.replaceAll("%REDCOUNT%", String.valueOf(this.getPlayers(GameTeam.GREEN)));
                motd = motd.replaceAll("%BLUENEXUS%", String.valueOf(this.getNexus(GameTeam.BLUE)));
                motd = motd.replaceAll("%BLUECOUNT%", String.valueOf(this.getPlayers(GameTeam.GREEN)));
                motd = motd.replaceAll("%YELLOWNEXUS%", String.valueOf(this.getNexus(GameTeam.YELLOW)));
                motd = motd.replaceAll("%YELLOWCOUNT%", String.valueOf(this.getPlayers(GameTeam.GREEN)));
                e.setMotd(ChatColor.translateAlternateColorCodes((char)'&', (String)motd));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getNexus(GameTeam t) {
        int health = 0;
        if (t.getNexus() != null) {
            health = t.getNexus().getHealth();
        }
        return health;
    }

    private int getPlayers(GameTeam t) {
        int size = 0;
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            PlayerMeta meta = PlayerMeta.getMeta(p);
            if (meta.getTeam() == t) {
                ++size;
            }
            ++n2;
        }
        return size;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        String teamName;
        Sign s;
        Material clickedType;
        GameTeam team;
        ItemStack handItem;
        Player player = e.getPlayer();
        PlayerMeta pmeta = PlayerMeta.getMeta(player);
        Action a = e.getAction();
        if ((a == Action.RIGHT_CLICK_AIR || a == Action.RIGHT_CLICK_BLOCK) && (handItem = player.getItemInHand()) != null) {
            if (handItem.getType() == Material.FEATHER && handItem.getItemMeta().hasDisplayName() && handItem.getItemMeta().getDisplayName().contains("(Click Derecho) para seleccionar un kit")) {
                Util.showClassSelector(e.getPlayer(), "Selector de Kits");
                return;
            }
            if (handItem.getType() == Material.COMPASS) {
                boolean setCompass = false;
                boolean setToNext = false;
                block0: while (!setCompass) {
                    GameTeam[] gameTeamArray = GameTeam.teams();
                    int n = gameTeamArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        team = gameTeamArray[n2];
                        if (setToNext) {
                            ItemMeta meta = handItem.getItemMeta();
                            meta.setDisplayName(team.color() + "Apunta a " + team.toString() + " Nexus");
                            handItem.setItemMeta(meta);
                            player.setCompassTarget(team.getNexus().getLocation());
                            setCompass = true;
                            continue block0;
                        }
                        if (handItem.getItemMeta().getDisplayName().contains(team.toString())) {
                            setToNext = true;
                        }
                        ++n2;
                    }
                }
            }
        }
        if (e.getClickedBlock() != null && ((clickedType = e.getClickedBlock().getType()) == Material.SIGN_POST || clickedType == Material.WALL_SIGN) && (s = (Sign)e.getClickedBlock().getState()).getLine(0).contains(ChatColor.DARK_PURPLE + "[Team]") && (team = GameTeam.valueOf((teamName = ChatColor.stripColor((String)s.getLine(1))).toUpperCase())) != null && pmeta.getTeam() == GameTeam.NONE) {
            this.plugin.joinTeam(e.getPlayer(), teamName);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Player player = e.getPlayer();
        PlayerMeta meta = PlayerMeta.getMeta(player);
        if (meta.isAlive()) {
            if (this.kitsToGive.containsKey(e.getPlayer().getName())) {
                meta.setKit(this.kitsToGive.get(e.getPlayer().getName()));
                this.kitsToGive.remove(e.getPlayer().getName());
            }
            e.setRespawnLocation(meta.getTeam().getRandomSpawn());
            meta.getKit().give(player, meta.getTeam());
        } else {
            e.setRespawnLocation(this.plugin.getMapManager().getLobbySpawnPoint());
            ItemStack selector = new ItemStack(Material.FEATHER);
            ItemMeta itemMeta = selector.getItemMeta();
            itemMeta.setDisplayName(ChatColor.AQUA + "(Click Derecho) para seleccionar un kit");
            selector.setItemMeta(itemMeta);
            player.getInventory().setItem(0, selector);
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        if (e.getReason().equals(ChatColor.RED + "DestruyeElNexus-TRIGGER-KICK-01")) {
            e.setReason(ChatColor.RED + "No podras entrar en esta fase al juego");
            e.setLeaveMessage(null);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        String prefix = ChatColor.GOLD + "[DestruyeElNexus] " + ChatColor.GRAY;
        final Player player = e.getPlayer();
        PlayerMeta meta = PlayerMeta.getMeta(player);
        if (this.plugin.getPhase() > this.plugin.lastJoinPhase && !player.hasPermission("DestruyeElNexus.bypass.phaselimiter")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.kickPlayer(ChatColor.RED + "DestruyeElNexus-TRIGGER-KICK-01");
                }
            }, 1L);
            e.setJoinMessage(null);
            return;
        }
        player.sendMessage(String.valueOf(prefix) + ChatColor.GREEN + "Bienvenido a DestruyeElNexus by maxmar628");
        player.sendMessage(String.valueOf(prefix) + ChatColor.GREEN + "Suscribite --> http://youtube.com/maxmar628");
        if (player.hasPermission("DestruyeElNexus.misc.updatenotify") && this.plugin.updateAvailable) {
            player.sendMessage(String.valueOf(prefix) + ChatColor.GOLD + "Una actualizaci\u00f3n est\u00e1 disponible ! Por favor, reinicie el servidor para aplicar esta actualizaci\u00f3n.");
            player.sendMessage(String.valueOf(prefix) + "Versi\u00f3n Actual: " + ChatColor.WHITE + this.plugin.getDescription().getVersion() + ChatColor.DARK_GRAY + " | " + ChatColor.GRAY + "Ultima Version: " + ChatColor.WHITE + this.plugin.newVersion);
        }
        if (meta.isAlive()) {
            player.teleport(meta.getTeam().getRandomSpawn());
        } else {
            player.teleport(this.plugin.getMapManager().getLobbySpawnPoint());
            PlayerInventory inv = player.getInventory();
            inv.setHelmet(null);
            inv.setChestplate(null);
            inv.setLeggings(null);
            inv.setBoots(null);
            player.getInventory().clear();
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            player.setLevel(0);
            player.setExp(0.0f);
            player.setSaturation(20.0f);
            ItemStack selector = new ItemStack(Material.FEATHER);
            ItemMeta itemMeta = selector.getItemMeta();
            itemMeta.setDisplayName(ChatColor.AQUA + "(Click Derecho) para seleccionar un kit");
            selector.setItemMeta(itemMeta);
            player.getInventory().setItem(0, selector);
            player.updateInventory();
        }
        if (this.plugin.useMysql) {
            this.plugin.getDatabaseHandler().query("INSERT IGNORE INTO `DestruyeElNexus` (`username`, `kills`, `deaths`, `wins`, `losses`, `nexus_damage`) VALUES ('" + player.getName() + "', '0', '0', '0', '0', '0');");
        }
        if (this.plugin.getPhase() == 0 && this.plugin.getVotingManager().isRunning()) {
            this.plugin.checkStarting();
        }
        this.plugin.getSignHandler().updateSigns(meta.getTeam());
        this.plugin.getScoreboardHandler().update();
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        PlayerMeta meta;
        final Player p = e.getEntity();
        if (this.plugin.getPhase() > 0 && !(meta = PlayerMeta.getMeta(p)).getTeam().getNexus().isAlive()) {
            meta.setAlive(false);
            Player[] playerArray = Bukkit.getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player pp = playerArray[n2];
                pp.hidePlayer(p);
                ++n2;
            }
        }
        this.plugin.getStatsManager().setValue(StatType.DEATHS, p, this.plugin.getStatsManager().getStat(StatType.DEATHS, p) + 1);
        if (p.getKiller() != null && !p.getKiller().equals(p)) {
            Player killer = p.getKiller();
            this.plugin.getStatsManager().incrementStat(StatType.KILLS, killer);
            e.setDeathMessage(ChatUtil.formatDeathMessage(p, p.getKiller(), e.getDeathMessage()));
            if (PlayerMeta.getMeta(killer).getKit() == Kit.BERSERKER) {
                this.addHeart(killer);
            }
        } else {
            e.setDeathMessage(ChatUtil.formatDeathMessage(p, e.getDeathMessage()));
        }
        e.setDroppedExp(p.getTotalExperience());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                PacketPlayInClientCommand in = new PacketPlayInClientCommand(EnumClientCommand.PERFORM_RESPAWN);
                EntityPlayer cPlayer = ((CraftPlayer)p).getHandle();
                cPlayer.playerConnection.a(in);
            }
        }, 1L);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && e.getEntity().getWorld().getName().equals("lobby")) {
            e.setCancelled(true);
            if (e.getCause() == EntityDamageEvent.DamageCause.VOID) {
                e.getEntity().teleport(this.plugin.getMapManager().getLobbySpawnPoint());
            }
        }
    }

    @EventHandler
    public void onPlayerPortal(PlayerPortalEvent e) {
        final Player player = e.getPlayer();
        player.setHealth(0.0);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Util.showClassSelector(player, "Selector de Kits");
            }
        }, 4L);
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent e) {
        Entity damager = e.getDamager();
        if (damager instanceof Player) {
            String lowercaseName;
            ItemStack hand;
            if (damager.getWorld().getName().equals("lobby")) {
                e.setCancelled(true);
                return;
            }
            if (this.plugin.getPhase() < 1) {
                e.setCancelled(true);
                return;
            }
            Player attacker = (Player)damager;
            if (PlayerMeta.getMeta(attacker).getKit() == Kit.WARRIOR && (hand = attacker.getItemInHand()) != null && ((lowercaseName = hand.getType().toString().toLowerCase()).contains("sword") || lowercaseName.contains("axe"))) {
                e.setDamage(e.getDamage() + 1.0);
            }
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        if (this.plugin.getPhase() > 0) {
            if (Util.isEmptyColumn(e.getBlock().getLocation())) {
                e.setCancelled(true);
            }
            if (this.tooClose(e.getBlock().getLocation()) && !e.getPlayer().hasPermission("DestruyeElNexus.buildbypass")) {
                e.getPlayer().sendMessage(ChatColor.RED + "No podras construir cerca del Nexus");
                e.setCancelled(true);
            }
        } else if (!e.getPlayer().hasPermission("DestruyeElNexus.buildbypass")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignPlace(SignChangeEvent e) {
        if (e.getPlayer().hasPermission("DestruyeElNexus.buildbypass") && e.getLine(0).toLowerCase().contains("[Shop]".toLowerCase())) {
            e.setLine(0, ChatColor.DARK_PURPLE + "[Shop]");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        if (this.plugin.getPhase() > 0) {
            GameTeam[] gameTeamArray = GameTeam.teams();
            int n = gameTeamArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameTeam t = gameTeamArray[n2];
                if (t.getNexus().getLocation().equals((Object)e.getBlock().getLocation())) {
                    e.setCancelled(true);
                    if (t.getNexus().isAlive()) {
                        this.breakNexus(t, e.getPlayer());
                    }
                    return;
                }
                ++n2;
            }
            if (this.tooClose(e.getBlock().getLocation()) && !e.getPlayer().hasPermission("DestruyeElNexus.buildbypass") && e.getBlock().getType() != Material.ENDER_STONE) {
                e.getPlayer().sendMessage(ChatColor.RED + "No se puede construir tan cerca del nexus!");
                e.setCancelled(true);
            }
        } else if (!e.getPlayer().hasPermission("DestruyeElNexus.buildbypass")) {
            e.setCancelled(true);
        }
    }

    private boolean tooClose(Location loc) {
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        GameTeam[] gameTeamArray = GameTeam.teams();
        int n = gameTeamArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameTeam team = gameTeamArray[n2];
            Location nexusLoc = team.getNexus().getLocation();
            double nX = nexusLoc.getX();
            double nY = nexusLoc.getY();
            double nZ = nexusLoc.getZ();
            if (Math.abs(nX - x) <= (double)this.plugin.build && Math.abs(nY - y) <= (double)this.plugin.build && Math.abs(nZ - z) <= (double)this.plugin.build) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addHeart(Player player) {
        double maxHealth = 0.0;
        if (maxHealth < 30.0) {
            double newMaxHealth = maxHealth + 2.0;
            player.setMaxHealth(newMaxHealth);
        }
    }

    private void breakNexus(final GameTeam victim, Player breaker) {
        final GameTeam attacker = PlayerMeta.getMeta(breaker).getTeam();
        if (victim == attacker) {
            breaker.sendMessage(ChatColor.GOLD + "No se puede da\u00f1ar a tu propio Nexus");
        } else if (this.plugin.getPhase() == 1) {
            breaker.sendMessage(ChatColor.GOLD + "Los Nexus son invencibles en la fase 1");
        } else {
            this.plugin.getScoreboardHandler().sb.getTeam(String.valueOf(victim.name()) + "SB").setPrefix(ChatColor.RESET.toString());
            victim.getNexus().damage(this.plugin.getPhase() == 5 ? 2 : 1);
            this.plugin.getStatsManager().incrementStat(StatType.NEXUS_DAMAGE, breaker, this.plugin.getPhase() == 5 ? 2 : 1);
            String msg = ChatUtil.nexusBreakMessage(breaker, attacker, victim);
            for (Player p : attacker.getPlayers()) {
                p.sendMessage(msg);
            }
            this.plugin.getScoreboardHandler().scores.get(victim.name()).setScore(victim.getNexus().getHealth());
            Bukkit.getServer().getPluginManager().callEvent((Event)new NexusDamageEvent(breaker, victim, victim.getNexus().getHealth()));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ((PlayerListener)PlayerListener.this).plugin.getScoreboardHandler().sb.getTeam(String.valueOf(victim.name()) + "SB").setPrefix(victim.color().toString());
                }
            }, 2L);
            Random r = new Random();
            float pitch = 0.5f + r.nextFloat() * 0.5f;
            victim.getNexus().getLocation().getWorld().playSound(victim.getNexus().getLocation(), Sound.ANVIL_LAND, 1.0f, pitch);
            Location nexus = victim.getNexus().getLocation().clone();
            nexus.add(0.5, 0.0, 0.5);
            Util.ParticleEffects.sendToLocation(Util.ParticleEffects.LAVA_SPARK, nexus, 1.0f, 1.0f, 1.0f, 0.0f, 20);
            Util.ParticleEffects.sendToLocation(Util.ParticleEffects.LARGE_SMOKE, nexus, 1.0f, 1.0f, 1.0f, 0.0f, 20);
            if (victim.getNexus().getHealth() == 0) {
                this.plugin.getScoreboardHandler().sb.resetScores(this.plugin.getScoreboardHandler().scores.remove(victim.name()).getPlayer());
                Bukkit.getServer().getPluginManager().callEvent((Event)new NexusDestroyEvent(breaker, victim));
                ChatUtil.nexusDestroyed(attacker, victim, breaker);
                this.plugin.checkWin();
                for (Player p : victim.getPlayers()) {
                    this.plugin.getStatsManager().incrementStat(StatType.LOSSES, p);
                }
                Player[] playerArray = Bukkit.getOnlinePlayers();
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    player.getWorld().playSound(player.getLocation(), Sound.EXPLODE, 1.0f, 1.25f);
                    ++n2;
                }
                for (final Location spawn : victim.getSpawns()) {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            Util.spawnFirework(spawn, attacker.getColor(attacker), attacker.getColor(attacker));
                        }
                    }, (long)new Random().nextInt(20));
                }
                Util.ParticleEffects.sendToLocation(Util.ParticleEffects.LARGE_EXPLODE, nexus, 1.0f, 1.0f, 1.0f, 0.0f, 20);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Location nexus = victim.getNexus().getLocation().clone();
                        boolean found = false;
                        int y = 0;
                        while (!found) {
                            ++y;
                            Block b = nexus.add(0.0, 1.0, 0.0).getBlock();
                            if (b != null && b.getType() == Material.BEACON) {
                                b.setType(Material.AIR);
                            }
                            if (y <= 10) continue;
                            found = true;
                        }
                    }
                });
            }
            this.plugin.getSignHandler().updateSigns(victim);
        }
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity().getWorld().getName().equals("lobby")) {
            event.setCancelled(true);
            event.setFoodLevel(20);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        Inventory inv = e.getInventory();
        Player player = (Player)e.getWhoClicked();
        if (inv.getTitle().startsWith("Selector de Kits")) {
            if (e.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            player.closeInventory();
            e.setCancelled(true);
            String name = e.getCurrentItem().getItemMeta().getDisplayName();
            PlayerMeta meta = PlayerMeta.getMeta(player);
            if (!Kit.valueOf(ChatColor.stripColor((String)name).toUpperCase()).isOwnedBy(player)) {
                player.sendMessage(ChatColor.RED + "No estas habilitado para utlizar este kit.");
                return;
            }
            player.sendMessage(ChatColor.GREEN + "Recibiras este kit cuando reaparezcas.");
            meta.setKit(Kit.getKit(ChatColor.stripColor((String)name)));
            player.sendMessage(ChatColor.GOLD + "Kit seleccionado: " + ChatColor.stripColor((String)name));
        }
    }
}

