/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.listeners;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import io.github.maxmar628.DestruyeElNexus.object.Kit;
import io.github.maxmar628.DestruyeElNexus.object.PlayerMeta;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class KitAbilityListener
implements Listener {
    private final HashMap<String, Location> blockLocations = new HashMap();
    private final HashMap<String, Long> cooldowns = new HashMap();
    private final DestruyeElNexus plugin;

    public KitAbilityListener(DestruyeElNexus plugin) {
        this.plugin = plugin;
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                KitAbilityListener.this.update();
            }
        }, 20L, 20L);
    }

    @EventHandler
    public void onSpecialBlockBreak(BlockBreakEvent e) {
        Block b = e.getBlock();
        for (Map.Entry<String, Location> entry : this.blockLocations.entrySet()) {
            if (!entry.getValue().equals((Object)b.getLocation())) continue;
            PlayerMeta meta = PlayerMeta.getMeta(entry.getKey());
            GameTeam ownerTeam = meta.getTeam();
            if (PlayerMeta.getMeta(e.getPlayer()).getTeam() == ownerTeam) {
                e.setCancelled(true);
                break;
            }
            Kit kit = meta.getKit();
            if (kit != Kit.OPERATIVE || !b.getType().equals((Object)Material.SOUL_SAND)) continue;
            Player owner = Bukkit.getPlayer((String)entry.getKey());
            String ownerName = ownerTeam.color() + entry.getKey();
            owner.sendMessage(ChatColor.RED + "Your return point was broken! You will not teleport back now.");
            e.getPlayer().sendMessage(ChatColor.DARK_AQUA + "You broke " + ownerName + "'s return point!");
            this.cooldowns.remove(entry.getKey());
            this.blockLocations.remove(entry.getKey());
            break;
        }
    }

    @EventHandler
    public void onSpecialBlockPlace(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = e.getPlayer();
        Kit kit = PlayerMeta.getMeta(player).getKit();
        if (kit == Kit.OPERATIVE) {
            final Block placed = e.getClickedBlock().getRelative(e.getBlockFace());
            ItemStack held = player.getItemInHand();
            if (held.hasItemMeta() && held.getType() == Material.SOUL_SAND && held.getItemMeta().getDisplayName().equals(ChatColor.AQUA + "Return Point")) {
                e.setCancelled(true);
                if (this.blockLocations.get(player.getName()) == null) {
                    player.updateInventory();
                    this.blockLocations.put(player.getName(), placed.getLocation());
                    this.cooldowns.put(player.getName(), 90L);
                    player.sendMessage(ChatColor.AQUA + "You will be teleported back here in 90 seconds");
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            placed.setType(Material.SOUL_SAND);
                        }
                    }, 1L);
                } else {
                    player.sendMessage(ChatColor.RED + "You have already placed a return point; you will return in " + this.cooldowns.get(player.getName()) + " seconds");
                }
            }
        }
    }

    @EventHandler
    public void onScoutGrapple(PlayerFishEvent e) {
        Material belowType;
        Player player = e.getPlayer();
        player.getItemInHand().setDurability((short)-10);
        if (PlayerMeta.getMeta(player).getKit() != Kit.SCOUT) {
            return;
        }
        if (!player.getItemInHand().getItemMeta().getDisplayName().contains("Grapple")) {
            return;
        }
        Location hookLoc = e.getHook().getLocation();
        Location playerLoc = player.getLocation();
        double hookX = (int)hookLoc.getX();
        double hookY = (int)hookLoc.getY();
        double hookZ = (int)hookLoc.getZ();
        Material inType = hookLoc.getWorld().getBlockAt(hookLoc).getType();
        if (!(inType != Material.AIR && inType != Material.WATER && inType != Material.LAVA || (belowType = hookLoc.getWorld().getBlockAt((int)hookX, (int)(hookY - 0.1), (int)hookZ).getType()) != Material.AIR && inType != Material.WATER && inType != Material.LAVA)) {
            return;
        }
        playerLoc.setY(playerLoc.getY() + 0.5);
        player.teleport(playerLoc);
        Vector diff = hookLoc.toVector().subtract(playerLoc.toVector());
        Vector vel = new Vector();
        double d = hookLoc.distance(playerLoc);
        vel.setX((1.0 + 0.07 * d) * diff.getX() / d);
        vel.setY((1.0 + 0.03 * d) * diff.getY() / d + 0.04 * d);
        vel.setZ((1.0 + 0.07 * d) * diff.getZ() / d);
        player.setVelocity(vel);
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getEntity();
        PlayerMeta meta = PlayerMeta.getMeta(player);
        if (meta.getKit() == Kit.SCOUT && e.getCause() == EntityDamageEvent.DamageCause.FALL && player.getItemInHand() != null && player.getItemInHand().hasItemMeta() && player.getItemInHand().getItemMeta().hasDisplayName() && player.getItemInHand().getItemMeta().getDisplayName().contains("Grapple")) {
            e.setDamage(e.getDamage() / 2.0);
        }
    }

    private void update() {
        block3: for (Map.Entry<String, Long> entry : this.cooldowns.entrySet()) {
            long cooldown = entry.getValue();
            if (cooldown <= 0L) continue;
            entry.setValue(--cooldown);
            String name = entry.getKey();
            final Player player = Bukkit.getPlayer((String)name);
            if (!player.isOnline()) continue;
            switch (PlayerMeta.getMeta(player).getKit()) {
                case OPERATIVE: {
                    if (cooldown == 0L) {
                        final Location returnPoint = this.blockLocations.get(name);
                        returnPoint.getBlock().setType(Material.AIR);
                        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                player.teleport(returnPoint);
                                player.sendMessage(ChatColor.DARK_AQUA + "You have been teleported back to your return point.");
                            }
                        }, 1L);
                        this.blockLocations.remove(name);
                        break;
                    }
                    if (cooldown != 20L && cooldown != 10L && cooldown > 5L) continue block3;
                    player.sendMessage(ChatColor.DARK_AQUA + "Teleporting back in " + cooldown + " second" + (cooldown == 1L ? "" : "s"));
                }
            }
        }
    }
}

