/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.listeners;

import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import io.github.maxmar628.DestruyeElNexus.object.PlayerMeta;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EnderChestListener
implements Listener {
    private HashMap<GameTeam, Location> chests = new HashMap();
    private HashMap<String, Inventory> inventories = new HashMap();

    @EventHandler
    public void onChestOpen(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.ENDER_CHEST) {
            return;
        }
        Block clicked = e.getClickedBlock();
        Player player = e.getPlayer();
        GameTeam team = PlayerMeta.getMeta(player).getTeam();
        if (team == GameTeam.NONE || !this.chests.containsKey((Object)team)) {
            return;
        }
        e.setCancelled(true);
        if (this.chests.get((Object)team).equals((Object)clicked.getLocation())) {
            this.openEnderChest(player);
        } else {
            GameTeam owner = this.getTeamWithChest(clicked.getLocation());
            if (owner != GameTeam.NONE) {
                this.openEnemyEnderChest(player, owner);
            }
        }
    }

    public void setEnderChestLocation(GameTeam team, Location loc) {
        this.chests.put(team, loc);
    }

    private void openEnderChest(Player player) {
        String name = player.getName();
        if (!this.inventories.containsKey(name)) {
            Inventory inv = Bukkit.createInventory(null, (int)9);
            this.inventories.put(name, inv);
        }
        player.openInventory(this.inventories.get(name));
    }

    @EventHandler
    public void onFurnaceBreak(BlockBreakEvent e) {
        if (this.chests.values().contains(e.getBlock().getLocation())) {
            e.setCancelled(true);
        }
    }

    private void openEnemyEnderChest(Player player, GameTeam owner) {
        LinkedList<Inventory> shuffledInventories = new LinkedList<Inventory>();
        for (Map.Entry<String, Inventory> entry : this.inventories.entrySet()) {
            if (PlayerMeta.getMeta(entry.getKey()).getTeam() != owner) continue;
            shuffledInventories.add(entry.getValue());
        }
        Collections.shuffle(shuffledInventories);
        int inventories = Math.min(9, shuffledInventories.size());
        if (inventories == 0) {
            return;
        }
        Inventory view = Bukkit.createInventory(null, (int)(inventories * 9));
        for (Inventory inv : shuffledInventories.subList(0, inventories)) {
            ItemStack[] itemStackArray = inv.getContents();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack stack = itemStackArray[n2];
                if (stack != null) {
                    view.addItem(new ItemStack[]{stack});
                }
                ++n2;
            }
        }
        player.openInventory(view);
    }

    private GameTeam getTeamWithChest(Location loc) {
        for (Map.Entry<GameTeam, Location> entry : this.chests.entrySet()) {
            if (!entry.getValue().equals((Object)loc)) continue;
            return entry.getKey();
        }
        return GameTeam.NONE;
    }
}

