/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.listeners;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.Util;
import io.github.maxmar628.DestruyeElNexus.chat.ChatUtil;
import io.github.maxmar628.DestruyeElNexus.object.Boss;
import io.github.maxmar628.DestruyeElNexus.object.PlayerMeta;
import org.bukkit.Bukkit;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class BossListener
implements Listener {
    private DestruyeElNexus plugin;

    public BossListener(DestruyeElNexus instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onHit(EntityDamageEvent event) {
        if (event.getEntity() instanceof IronGolem) {
            IronGolem g = (IronGolem)event.getEntity();
            if (g.getCustomName() == null) {
                return;
            }
            final Boss b = this.plugin.getBossManager().bossNames.get(g.getCustomName());
            if (b == null) {
                return;
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
                event.getEntity().remove();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Boss n = BossListener.this.plugin.getBossManager().newBoss(b);
                        BossListener.this.plugin.getBossManager().spawn(n);
                    }
                });
                return;
            }
        }
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof IronGolem) {
            IronGolem g;
            if (!(event.getDamager() instanceof Player)) {
                event.setCancelled(true);
            }
            if ((g = (IronGolem)event.getEntity()).getCustomName() == null) {
                return;
            }
            final Boss b = this.plugin.getBossManager().bossNames.get(g.getCustomName());
            if (b == null) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    BossListener.this.plugin.getBossManager().update(b, g);
                }
            });
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof IronGolem) {
            IronGolem g = (IronGolem)event.getEntity();
            if (g.getCustomName() == null) {
                return;
            }
            Boss b = this.plugin.getBossManager().bossNames.get(g.getCustomName());
            if (b == null) {
                return;
            }
            event.getDrops().clear();
            b.spawnLootChest();
            if (g.getKiller() != null) {
                Player killer = g.getKiller();
                ChatUtil.bossDeath(b, killer, PlayerMeta.getMeta(killer).getTeam());
                this.respawn(b);
                Util.spawnFirework(event.getEntity().getLocation(), PlayerMeta.getMeta(killer).getTeam().getColor(PlayerMeta.getMeta(killer).getTeam()), PlayerMeta.getMeta(killer).getTeam().getColor(PlayerMeta.getMeta(killer).getTeam()));
            } else {
                g.teleport(b.getSpawn());
            }
        }
    }

    private void respawn(final Boss b) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Boss n = BossListener.this.plugin.getBossManager().newBoss(b);
                ChatUtil.bossRespawn(b);
                BossListener.this.plugin.getBossManager().spawn(n);
            }
        }, (long)(20 * this.plugin.respawn * 60));
    }
}

