/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.commands;

import io.github.maxmar628.DestruyeElNexus.Translation;
import io.github.maxmar628.DestruyeElNexus.manager.VotingManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class VoteCommand
implements CommandExecutor {
    private final VotingManager manager;

    public VoteCommand(VotingManager manager) {
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.manager.isRunning()) {
            sender.sendMessage(ChatColor.RED + Translation._("INFO_COMMAND_VOTING_ENDED"));
        } else if (args.length == 0) {
            this.listMaps(sender);
        } else if (!this.manager.vote(sender, args[0])) {
            sender.sendMessage(ChatColor.RED + Translation._("INFO_COMMAND_VOTING_INVALID"));
            this.listMaps(sender);
        }
        return true;
    }

    private void listMaps(CommandSender sender) {
        sender.sendMessage(ChatColor.DARK_AQUA + Translation._("INFO_COMMAND_VOTING_MAPS"));
        int count = 0;
        for (String map : this.manager.getMaps().values()) {
            sender.sendMessage(ChatColor.DARK_GRAY + " - " + ChatColor.AQUA + "[" + ++count + "] " + ChatColor.GRAY + map);
        }
    }
}

